/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.virtual;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableMap;
import java.util.HashMap;
import java.util.Map;
import nl.jqno.equalsverifier.EqualsVerifier;
import org.apache.druid.query.expression.TestExprMacroTable;
import org.apache.druid.segment.TestHelper;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.virtual.NestedObjectVirtualColumn;
import org.junit.Assert;
import org.junit.Test;

public class NestedObjectVirtualColumnTest {
    private static final ObjectMapper JSON_MAPPER = TestHelper.makeJsonMapper();

    @Test
    public void testSerde() throws JsonProcessingException {
        ImmutableMap keyExprMap = ImmutableMap.of((Object)"computed", (Object)new NestedObjectVirtualColumn.TypedExpression("col1 + col2", ColumnType.LONG), (Object)"concatenated", (Object)new NestedObjectVirtualColumn.TypedExpression("concat(col3, '_suffix')", ColumnType.STRING));
        NestedObjectVirtualColumn there = new NestedObjectVirtualColumn("computed_obj", (Map)keyExprMap, TestExprMacroTable.INSTANCE);
        String json = JSON_MAPPER.writeValueAsString((Object)there);
        NestedObjectVirtualColumn andBackAgain = (NestedObjectVirtualColumn)JSON_MAPPER.readValue(json, NestedObjectVirtualColumn.class);
        Assert.assertEquals((Object)there, (Object)andBackAgain);
    }

    @Test
    public void testGetKeyExprMap() {
        HashMap<String, NestedObjectVirtualColumn.TypedExpression> keyExprMap = new HashMap<String, NestedObjectVirtualColumn.TypedExpression>();
        keyExprMap.put("key1", new NestedObjectVirtualColumn.TypedExpression("expr1", ColumnType.STRING));
        keyExprMap.put("key2", new NestedObjectVirtualColumn.TypedExpression("expr2", ColumnType.DOUBLE));
        NestedObjectVirtualColumn column = new NestedObjectVirtualColumn("test_obj", keyExprMap, TestExprMacroTable.INSTANCE);
        Assert.assertEquals(keyExprMap, (Object)column.getKeyExprMap());
    }

    @Test
    public void testToString() {
        ImmutableMap keyExprMap = ImmutableMap.of((Object)"key1", (Object)new NestedObjectVirtualColumn.TypedExpression("col1", ColumnType.STRING));
        NestedObjectVirtualColumn column = new NestedObjectVirtualColumn("test_obj", (Map)keyExprMap, TestExprMacroTable.INSTANCE);
        String result = column.toString();
        Assert.assertTrue((boolean)result.startsWith("NestedObjectVirtualColumn{"));
        Assert.assertTrue((boolean)result.contains("name='test_obj'"));
        Assert.assertTrue((boolean)result.contains("object="));
    }

    @Test
    public void testTypedExpressionSerde() throws JsonProcessingException {
        NestedObjectVirtualColumn.TypedExpression there = new NestedObjectVirtualColumn.TypedExpression("col1 + col2", ColumnType.LONG);
        String json = JSON_MAPPER.writeValueAsString((Object)there);
        NestedObjectVirtualColumn.TypedExpression andBackAgain = (NestedObjectVirtualColumn.TypedExpression)JSON_MAPPER.readValue(json, NestedObjectVirtualColumn.TypedExpression.class);
        Assert.assertEquals((Object)there, (Object)andBackAgain);
    }

    @Test
    public void testTypedExpressionGetters() {
        NestedObjectVirtualColumn.TypedExpression typedExpr = new NestedObjectVirtualColumn.TypedExpression("test_expression", ColumnType.DOUBLE);
        Assert.assertEquals((Object)"test_expression", (Object)typedExpr.getExpression());
        Assert.assertEquals((Object)ColumnType.DOUBLE, (Object)typedExpr.getType());
    }

    @Test
    public void testTypedExpressionEqualsAndHashcode() {
        EqualsVerifier.forClass(NestedObjectVirtualColumn.TypedExpression.class).withNonnullFields(new String[]{"expression", "type"}).usingGetClass().verify();
    }
}

