/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.tasklogs;

import com.google.common.base.Optional;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import org.apache.druid.tasklogs.SwitchingTaskLogs;
import org.apache.druid.tasklogs.TaskLogs;
import org.easymock.EasyMock;
import org.easymock.EasyMockRunner;
import org.easymock.EasyMockSupport;
import org.easymock.Mock;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=EasyMockRunner.class)
public class SwitchingTaskLogsTest
extends EasyMockSupport {
    @Mock
    private TaskLogs defaultTaskLogs;
    @Mock
    private TaskLogs reportTaskLogs;
    @Mock
    private TaskLogs streamerTaskLogs;
    @Mock
    private TaskLogs pusherTaskLogs;
    private SwitchingTaskLogs taskLogs;

    @Before
    public void setUp() {
        this.taskLogs = new SwitchingTaskLogs(this.defaultTaskLogs, this.reportTaskLogs, this.streamerTaskLogs, this.pusherTaskLogs);
    }

    @Test
    public void test_streamTaskLog_usesStreamerTaskLogs() throws IOException {
        String taskId = "test-task-id";
        long offset = 0L;
        ByteArrayInputStream logStream = new ByteArrayInputStream("test log content".getBytes(StandardCharsets.UTF_8));
        EasyMock.expect((Object)this.streamerTaskLogs.streamTaskLog(taskId, offset)).andReturn((Object)Optional.of((Object)logStream));
        this.replayAll();
        Optional actualLogStream = this.taskLogs.streamTaskLog(taskId, offset);
        Assert.assertTrue((boolean)actualLogStream.isPresent());
        Assert.assertEquals((Object)logStream, (Object)actualLogStream.get());
        this.verifyAll();
    }

    @Test
    public void test_streamTaskReports_usesReportTaskLogs() throws IOException {
        String taskId = "test-task-id";
        ByteArrayInputStream reportStream = new ByteArrayInputStream("test report content".getBytes(StandardCharsets.UTF_8));
        EasyMock.expect((Object)this.reportTaskLogs.streamTaskReports(taskId)).andReturn((Object)Optional.of((Object)reportStream));
        this.replayAll();
        Optional actualReportStream = this.taskLogs.streamTaskReports(taskId);
        Assert.assertTrue((boolean)actualReportStream.isPresent());
        Assert.assertEquals((Object)reportStream, (Object)actualReportStream.get());
        this.verifyAll();
    }

    @Test
    public void test_streamTaskStatus_usesReportTaskLogs() throws IOException {
        String taskId = "test-task-id";
        ByteArrayInputStream statusStream = new ByteArrayInputStream("test status content".getBytes(StandardCharsets.UTF_8));
        EasyMock.expect((Object)this.reportTaskLogs.streamTaskStatus(taskId)).andReturn((Object)Optional.of((Object)statusStream));
        this.replayAll();
        Optional actualStatusStream = this.taskLogs.streamTaskStatus(taskId);
        Assert.assertTrue((boolean)actualStatusStream.isPresent());
        Assert.assertEquals((Object)statusStream, (Object)actualStatusStream.get());
        this.verifyAll();
    }

    @Test
    public void test_streamTaskPayload_usesReportTaskLogs() throws IOException {
        String taskId = "test-task-id";
        ByteArrayInputStream payloadStream = new ByteArrayInputStream("test payload content".getBytes(StandardCharsets.UTF_8));
        EasyMock.expect((Object)this.reportTaskLogs.streamTaskPayload(taskId)).andReturn((Object)Optional.of((Object)payloadStream));
        this.replayAll();
        Optional actualPayloadStream = this.taskLogs.streamTaskPayload(taskId);
        Assert.assertTrue((boolean)actualPayloadStream.isPresent());
        Assert.assertEquals((Object)payloadStream, (Object)actualPayloadStream.get());
        this.verifyAll();
    }

    @Test
    public void test_pushTaskLog_usesPusherTaskLogs() throws IOException {
        String taskId = "test-task-id";
        File logFile = new File("test.log");
        this.pusherTaskLogs.pushTaskLog(taskId, logFile);
        EasyMock.expectLastCall();
        this.replayAll();
        this.taskLogs.pushTaskLog(taskId, logFile);
        this.verifyAll();
    }

    @Test
    public void test_pushTaskReports_usesReportTaskLogs() throws IOException {
        String taskId = "test-task-id";
        File logFile = new File("test.log");
        this.reportTaskLogs.pushTaskReports(taskId, logFile);
        EasyMock.expectLastCall();
        this.replayAll();
        this.taskLogs.pushTaskReports(taskId, logFile);
        this.verifyAll();
    }

    @Test
    public void test_pushTaskStatus_usesReportTaskLogs() throws IOException {
        String taskId = "test-task-id";
        File logFile = new File("test.log");
        this.reportTaskLogs.pushTaskStatus(taskId, logFile);
        EasyMock.expectLastCall();
        this.replayAll();
        this.taskLogs.pushTaskStatus(taskId, logFile);
        this.verifyAll();
    }

    @Test
    public void test_pushTaskPayload_usesReportTaskLogs() throws IOException {
        String taskId = "test-task-id";
        File logFile = new File("test.log");
        this.reportTaskLogs.pushTaskPayload(taskId, logFile);
        EasyMock.expectLastCall();
        this.replayAll();
        this.taskLogs.pushTaskPayload(taskId, logFile);
        this.verifyAll();
    }

    @Test
    public void test_killAll_usesReportTaskLogs() throws IOException {
        this.reportTaskLogs.killAll();
        EasyMock.expectLastCall();
        this.replayAll();
        this.taskLogs.killAll();
        this.verifyAll();
    }

    @Test
    public void test_killOlderThan_usesReportTaskLogs() throws IOException {
        long timestamp = System.currentTimeMillis();
        this.reportTaskLogs.killOlderThan(timestamp);
        EasyMock.expectLastCall();
        this.replayAll();
        this.taskLogs.killOlderThan(timestamp);
        this.verifyAll();
    }
}

