/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.timeline.partition;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableRangeSet;
import com.google.common.collect.Range;
import com.google.common.collect.RangeSet;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.druid.data.input.InputRow;
import org.apache.druid.data.input.MapBasedInputRow;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.timeline.partition.HashBasedNumberedPartialShardSpec;
import org.apache.druid.timeline.partition.NumberedOverwritePartialShardSpec;
import org.apache.druid.timeline.partition.NumberedPartialShardSpec;
import org.apache.druid.timeline.partition.PartialShardSpec;
import org.apache.druid.timeline.partition.ShardSpec;
import org.apache.druid.timeline.partition.ShardSpecLookup;
import org.apache.druid.timeline.partition.SingleDimensionPartialShardSpec;
import org.apache.druid.timeline.partition.SingleDimensionShardSpec;
import org.junit.Assert;
import org.junit.Test;

public class SingleDimensionShardSpecTest {
    private final ObjectMapper OBJECT_MAPPER = new ObjectMapper();

    @Test
    public void testPossibleInDomain() {
        ImmutableMap domain1 = ImmutableMap.of((Object)"dim1", SingleDimensionShardSpecTest.rangeSet((List<Range<String>>)ImmutableList.of((Object)Range.lessThan((Comparable)((Object)"abc")))));
        ImmutableMap domain2 = ImmutableMap.of((Object)"dim1", SingleDimensionShardSpecTest.rangeSet((List<Range<String>>)ImmutableList.of((Object)Range.singleton((Comparable)((Object)"e")))), (Object)"dim2", SingleDimensionShardSpecTest.rangeSet((List<Range<String>>)ImmutableList.of((Object)Range.singleton((Comparable)((Object)"na")))));
        SingleDimensionShardSpec shard1 = this.makeSpec("dim1", null, "abc");
        SingleDimensionShardSpec shard2 = this.makeSpec("dim1", "abc", "def");
        SingleDimensionShardSpec shard3 = this.makeSpec("dim1", "def", null);
        SingleDimensionShardSpec shard4 = this.makeSpec("dim2", null, "hello");
        SingleDimensionShardSpec shard5 = this.makeSpec("dim2", "hello", "jk");
        SingleDimensionShardSpec shard6 = this.makeSpec("dim2", "jk", "na");
        SingleDimensionShardSpec shard7 = this.makeSpec("dim2", "na", null);
        Assert.assertTrue((boolean)shard1.possibleInDomain((Map)domain1));
        Assert.assertFalse((boolean)shard2.possibleInDomain((Map)domain1));
        Assert.assertFalse((boolean)shard3.possibleInDomain((Map)domain1));
        Assert.assertTrue((boolean)shard4.possibleInDomain((Map)domain1));
        Assert.assertTrue((boolean)shard5.possibleInDomain((Map)domain1));
        Assert.assertTrue((boolean)shard6.possibleInDomain((Map)domain1));
        Assert.assertTrue((boolean)shard7.possibleInDomain((Map)domain1));
        Assert.assertFalse((boolean)shard1.possibleInDomain((Map)domain2));
        Assert.assertFalse((boolean)shard2.possibleInDomain((Map)domain2));
        Assert.assertTrue((boolean)shard3.possibleInDomain((Map)domain2));
        Assert.assertFalse((boolean)shard4.possibleInDomain((Map)domain2));
        Assert.assertFalse((boolean)shard5.possibleInDomain((Map)domain2));
        Assert.assertTrue((boolean)shard6.possibleInDomain((Map)domain2));
        Assert.assertTrue((boolean)shard7.possibleInDomain((Map)domain2));
    }

    @Test
    public void testSharePartitionSpace() {
        SingleDimensionShardSpec shardSpec = this.makeSpec("start", "end");
        Assert.assertTrue((boolean)shardSpec.sharePartitionSpace((PartialShardSpec)NumberedPartialShardSpec.instance()));
        Assert.assertTrue((boolean)shardSpec.sharePartitionSpace((PartialShardSpec)new HashBasedNumberedPartialShardSpec(null, 0, 1, null)));
        Assert.assertTrue((boolean)shardSpec.sharePartitionSpace((PartialShardSpec)new SingleDimensionPartialShardSpec("dim", 0, null, null, 1)));
        Assert.assertFalse((boolean)shardSpec.sharePartitionSpace((PartialShardSpec)new NumberedOverwritePartialShardSpec(0, 2, 1)));
    }

    @Test
    public void testSerde() throws IOException {
        this.testSerde(new SingleDimensionShardSpec("dim", null, null, 10, null));
        this.testSerde(new SingleDimensionShardSpec("dim", "abc", null, 5, Integer.valueOf(10)));
        this.testSerde(new SingleDimensionShardSpec("dim", null, "xyz", 10, Integer.valueOf(1)));
        this.testSerde(new SingleDimensionShardSpec("dim", "abc", "xyz", 10, null));
    }

    @Test
    public void testDeserialize() throws JsonProcessingException {
        String json = "{\"type\": \"single\", \"dimension\": \"dim\", \"start\": \"abc\",\"end\": \"xyz\",\"partitionNum\": 5,\"numCorePartitions\": 10}";
        ShardSpec shardSpec = (ShardSpec)this.OBJECT_MAPPER.readValue("{\"type\": \"single\", \"dimension\": \"dim\", \"start\": \"abc\",\"end\": \"xyz\",\"partitionNum\": 5,\"numCorePartitions\": 10}", ShardSpec.class);
        Assert.assertTrue((boolean)(shardSpec instanceof SingleDimensionShardSpec));
        Assert.assertEquals((Object)"single", (Object)shardSpec.getType());
        SingleDimensionShardSpec singleDimShardSpec = (SingleDimensionShardSpec)shardSpec;
        Assert.assertEquals((Object)new SingleDimensionShardSpec("dim", "abc", "xyz", 5, Integer.valueOf(10)), (Object)singleDimShardSpec);
    }

    @Test
    public void testShardSpecLookup() {
        ImmutableList shardSpecs = ImmutableList.of((Object)new SingleDimensionShardSpec("dim", null, "c", 1, Integer.valueOf(1)), (Object)new SingleDimensionShardSpec("dim", "c", "h", 2, Integer.valueOf(1)), (Object)new SingleDimensionShardSpec("dim", "h", null, 3, Integer.valueOf(1)));
        ShardSpecLookup lookup = ((ShardSpec)shardSpecs.get(0)).getLookup((List)shardSpecs);
        long currentTime = DateTimes.nowUtc().getMillis();
        Assert.assertEquals(shardSpecs.get(0), (Object)lookup.getShardSpec(currentTime, (InputRow)new MapBasedInputRow(currentTime, Collections.singletonList("dim"), (Map)ImmutableMap.of((Object)"dim", (Object)"a", (Object)"time", (Object)currentTime))));
        Assert.assertEquals(shardSpecs.get(0), (Object)lookup.getShardSpec(currentTime, (InputRow)new MapBasedInputRow(currentTime, Collections.singletonList("dim"), (Map)ImmutableMap.of((Object)"time", (Object)currentTime))));
        Assert.assertEquals(shardSpecs.get(0), (Object)lookup.getShardSpec(currentTime, (InputRow)new MapBasedInputRow(currentTime, Collections.singletonList("dim"), (Map)ImmutableMap.of((Object)"dim", Arrays.asList("a", "b"), (Object)"time", (Object)currentTime))));
        Assert.assertEquals(shardSpecs.get(1), (Object)lookup.getShardSpec(currentTime, (InputRow)new MapBasedInputRow(currentTime, Collections.singletonList("dim"), (Map)ImmutableMap.of((Object)"dim", (Object)"g", (Object)"time", (Object)currentTime))));
        Assert.assertEquals(shardSpecs.get(2), (Object)lookup.getShardSpec(currentTime, (InputRow)new MapBasedInputRow(currentTime, Collections.singletonList("dim"), (Map)ImmutableMap.of((Object)"dim", (Object)"k", (Object)"time", (Object)currentTime))));
    }

    private void testSerde(SingleDimensionShardSpec shardSpec) throws IOException {
        String json = this.OBJECT_MAPPER.writeValueAsString((Object)shardSpec);
        SingleDimensionShardSpec deserializedSpec = (SingleDimensionShardSpec)this.OBJECT_MAPPER.readValue(json, SingleDimensionShardSpec.class);
        Assert.assertEquals((Object)shardSpec, (Object)deserializedSpec);
    }

    private static RangeSet<String> rangeSet(List<Range<String>> ranges) {
        ImmutableRangeSet.Builder builder = ImmutableRangeSet.builder();
        for (Range<String> range : ranges) {
            builder.add(range);
        }
        return builder.build();
    }

    private SingleDimensionShardSpec makeSpec(String start, String end) {
        return this.makeSpec("billy", start, end);
    }

    private SingleDimensionShardSpec makeSpec(String dimension, String start, String end) {
        return new SingleDimensionShardSpec(dimension, start, end, 0, Integer.valueOf(-1));
    }
}

