/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.frame.field;

import org.apache.druid.error.DruidException;
import org.apache.druid.frame.FrameType;

public class TransformUtils {
    public static long transformFromDouble(double n, FrameType frameType) {
        switch (frameType) {
            case ROW_BASED_V1: {
                return TransformUtils.transformFromDoubleLegacy(n);
            }
            case ROW_BASED_V2: {
                return TransformUtils.transformFromDouble(n);
            }
        }
        throw DruidException.defensive("Unexpected frameType[%s]", new Object[]{frameType});
    }

    private static long transformFromDouble(double n) {
        long bits = Double.doubleToLongBits(n);
        long mask = (bits & Long.MIN_VALUE) >> 63 | Long.MIN_VALUE;
        return Long.reverseBytes(bits ^ mask);
    }

    private static long transformFromDoubleLegacy(double n) {
        long bits = Double.doubleToLongBits(n);
        long mask = (bits & Long.MIN_VALUE) >> 11 | Long.MIN_VALUE;
        return Long.reverseBytes(bits ^ mask);
    }

    public static double detransformToDouble(long transformedBits, FrameType frameType) {
        switch (frameType) {
            case ROW_BASED_V1: {
                return TransformUtils.detransformToDoubleLegacy(transformedBits);
            }
            case ROW_BASED_V2: {
                return TransformUtils.detransformToDouble(transformedBits);
            }
        }
        throw DruidException.defensive("Unexpected frameType[%s]", new Object[]{frameType});
    }

    private static double detransformToDouble(long transformedBits) {
        long reversedBits = Long.reverseBytes(transformedBits);
        long mask = ((reversedBits ^ Long.MIN_VALUE) & Long.MIN_VALUE) >> 63 | Long.MIN_VALUE;
        return Double.longBitsToDouble(reversedBits ^ mask);
    }

    private static double detransformToDoubleLegacy(long bits) {
        long reversedBits = Long.reverseBytes(bits);
        long mask = ((reversedBits ^ Long.MIN_VALUE) & Long.MIN_VALUE) >> 11 | Long.MIN_VALUE;
        return Double.longBitsToDouble(reversedBits ^ mask);
    }

    public static long transformFromLong(long n) {
        return Long.reverseBytes(n ^ Long.MIN_VALUE);
    }

    public static long detransformToLong(long bits) {
        return Long.reverseBytes(bits) ^ Long.MIN_VALUE;
    }

    public static int transformFromFloat(float n, FrameType frameType) {
        switch (frameType) {
            case ROW_BASED_V1: {
                return TransformUtils.transformFromFloatLegacy(n);
            }
            case ROW_BASED_V2: {
                return TransformUtils.transformFromFloat(n);
            }
        }
        throw DruidException.defensive("Unexpected frameType[%s]", new Object[]{frameType});
    }

    private static int transformFromFloat(float n) {
        int bits = Float.floatToIntBits(n);
        int mask = (bits & Integer.MIN_VALUE) >> 31 | Integer.MIN_VALUE;
        return Integer.reverseBytes(bits ^ mask);
    }

    private static int transformFromFloatLegacy(float n) {
        int bits = Float.floatToIntBits(n);
        int mask = (bits & Integer.MIN_VALUE) >> 8 | Integer.MIN_VALUE;
        return Integer.reverseBytes(bits ^ mask);
    }

    public static float detransformToFloat(int transformedBits, FrameType frameType) {
        switch (frameType) {
            case ROW_BASED_V1: {
                return TransformUtils.detransformToFloatLegacy(transformedBits);
            }
            case ROW_BASED_V2: {
                return TransformUtils.detransformToFloat(transformedBits);
            }
        }
        throw DruidException.defensive("Unexpected frameType[%s]", new Object[]{frameType});
    }

    private static float detransformToFloat(int transformedBits) {
        int reversedBits = Integer.reverseBytes(transformedBits);
        int mask = ((reversedBits ^ Integer.MIN_VALUE) & Integer.MIN_VALUE) >> 31 | Integer.MIN_VALUE;
        return Float.intBitsToFloat(reversedBits ^ mask);
    }

    private static float detransformToFloatLegacy(int bits) {
        int reversedBits = Integer.reverseBytes(bits);
        int mask = ((reversedBits ^ Integer.MIN_VALUE) & Integer.MIN_VALUE) >> 8 | Integer.MIN_VALUE;
        return Float.intBitsToFloat(reversedBits ^ mask);
    }
}

