/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation.cardinality.types;

import com.google.common.hash.Hasher;
import org.apache.druid.hll.HyperLogLogCollector;
import org.apache.druid.query.aggregation.cardinality.CardinalityAggregator;
import org.apache.druid.query.aggregation.cardinality.types.CardinalityAggregatorColumnSelectorStrategy;
import org.apache.druid.segment.BaseDoubleColumnValueSelector;

public class DoubleCardinalityAggregatorColumnSelectorStrategy
implements CardinalityAggregatorColumnSelectorStrategy<BaseDoubleColumnValueSelector> {
    public static void addDoubleToCollector(HyperLogLogCollector collector, double n) {
        collector.add(CardinalityAggregator.HASH_FUNCTION.hashLong(Double.doubleToLongBits(n)).asBytes());
    }

    @Override
    public void hashRow(BaseDoubleColumnValueSelector selector, Hasher hasher) {
        if (!selector.isNull()) {
            hasher.putDouble(selector.getDouble());
        }
    }

    @Override
    public void hashValues(BaseDoubleColumnValueSelector selector, HyperLogLogCollector collector) {
        if (!selector.isNull()) {
            DoubleCardinalityAggregatorColumnSelectorStrategy.addDoubleToCollector(collector, selector.getDouble());
        }
    }
}

