/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation.cardinality.vector;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.apache.druid.hll.HyperLogLogCollector;
import org.apache.druid.query.aggregation.cardinality.types.FloatCardinalityAggregatorColumnSelectorStrategy;
import org.apache.druid.query.aggregation.cardinality.vector.CardinalityVectorProcessor;
import org.apache.druid.segment.vector.VectorValueSelector;

public class FloatCardinalityVectorProcessor
implements CardinalityVectorProcessor {
    private final VectorValueSelector selector;

    public FloatCardinalityVectorProcessor(VectorValueSelector selector) {
        this.selector = selector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void aggregate(ByteBuffer buf, int position, int startRow, int endRow) {
        int oldPosition = buf.position();
        int oldLimit = buf.limit();
        try {
            float[] vector = this.selector.getFloatVector();
            boolean[] nullVector = this.selector.getNullVector();
            buf.limit(position + HyperLogLogCollector.getLatestNumBytesForDenseStorage());
            buf.position(position);
            HyperLogLogCollector collector = HyperLogLogCollector.makeCollector(buf);
            for (int i = startRow; i < endRow; ++i) {
                if (nullVector != null && nullVector[i]) continue;
                FloatCardinalityAggregatorColumnSelectorStrategy.addFloatToCollector(collector, vector[i]);
            }
        }
        finally {
            buf.limit(oldLimit);
            buf.position(oldPosition);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void aggregate(ByteBuffer buf, int numRows, int[] positions, @Nullable int[] rows, int positionOffset) {
        int oldPosition = buf.position();
        int oldLimit = buf.limit();
        try {
            float[] vector = this.selector.getFloatVector();
            boolean[] nullVector = this.selector.getNullVector();
            for (int i = 0; i < numRows; ++i) {
                int idx;
                int n = idx = rows != null ? rows[i] : i;
                if (nullVector != null && nullVector[idx]) continue;
                int position = positions[i] + positionOffset;
                buf.limit(position + HyperLogLogCollector.getLatestNumBytesForDenseStorage());
                buf.position(position);
                HyperLogLogCollector collector = HyperLogLogCollector.makeCollector(buf);
                FloatCardinalityAggregatorColumnSelectorStrategy.addFloatToCollector(collector, vector[idx]);
            }
        }
        finally {
            buf.limit(oldLimit);
            buf.position(oldPosition);
        }
    }
}

