/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.http;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.druid.query.http.ClientSqlParameter;

public class ClientSqlQuery {
    @JsonProperty
    private final String query;
    @JsonProperty
    private final String resultFormat;
    @JsonProperty
    private final boolean header;
    @JsonProperty
    private final boolean typesHeader;
    @JsonProperty
    private final boolean sqlTypesHeader;
    @JsonProperty
    private final Map<String, Object> context;
    @JsonProperty
    private final List<ClientSqlParameter> parameters;

    @JsonCreator
    public ClientSqlQuery(@JsonProperty(value="query") String query, @JsonProperty(value="resultFormat") String resultFormat, @JsonProperty(value="header") boolean header, @JsonProperty(value="typesHeader") boolean typesHeader, @JsonProperty(value="sqlTypesHeader") boolean sqlTypesHeader, @JsonProperty(value="context") Map<String, Object> context, @JsonProperty(value="parameters") List<ClientSqlParameter> parameters) {
        this.query = query;
        this.resultFormat = resultFormat;
        this.header = header;
        this.typesHeader = typesHeader;
        this.sqlTypesHeader = sqlTypesHeader;
        this.context = context;
        this.parameters = parameters;
    }

    public String getQuery() {
        return this.query;
    }

    public String getResultFormat() {
        return this.resultFormat;
    }

    public boolean isHeader() {
        return this.header;
    }

    public boolean isTypesHeader() {
        return this.typesHeader;
    }

    public boolean isSqlTypesHeader() {
        return this.sqlTypesHeader;
    }

    public Map<String, Object> getContext() {
        return this.context;
    }

    public List<ClientSqlParameter> getParameters() {
        return this.parameters;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClientSqlQuery sqlQuery = (ClientSqlQuery)o;
        return this.header == sqlQuery.header && this.typesHeader == sqlQuery.typesHeader && this.sqlTypesHeader == sqlQuery.sqlTypesHeader && Objects.equals(this.query, sqlQuery.query) && Objects.equals(this.resultFormat, sqlQuery.resultFormat) && Objects.equals(this.context, sqlQuery.context) && Objects.equals(this.parameters, sqlQuery.parameters);
    }

    public int hashCode() {
        return Objects.hash(this.query, this.resultFormat, this.header, this.typesHeader, this.sqlTypesHeader, this.context, this.parameters);
    }

    public String toString() {
        return "ClientSqlQuery{query='" + this.query + "', resultFormat=" + this.resultFormat + ", header=" + this.header + ", typesHeader=" + this.typesHeader + ", sqlTypesHeader=" + this.sqlTypesHeader + ", context=" + this.context + ", parameters=" + this.parameters + "}";
    }
}

