/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import org.apache.druid.java.util.common.io.Closer;
import org.apache.druid.math.expr.Expr;
import org.apache.druid.query.Order;
import org.apache.druid.query.OrderBy;
import org.apache.druid.query.filter.BooleanFilter;
import org.apache.druid.query.filter.DimFilter;
import org.apache.druid.query.filter.EqualityFilter;
import org.apache.druid.query.filter.Filter;
import org.apache.druid.query.filter.InDimFilter;
import org.apache.druid.query.filter.NullFilter;
import org.apache.druid.query.filter.RangeFilter;
import org.apache.druid.segment.ColumnInspector;
import org.apache.druid.segment.Cursor;
import org.apache.druid.segment.CursorBuildSpec;
import org.apache.druid.segment.CursorFactory;
import org.apache.druid.segment.CursorHolder;
import org.apache.druid.segment.Cursors;
import org.apache.druid.segment.UnnestColumnValueSelectorCursor;
import org.apache.druid.segment.UnnestDimensionCursor;
import org.apache.druid.segment.VirtualColumn;
import org.apache.druid.segment.VirtualColumns;
import org.apache.druid.segment.column.ColumnCapabilities;
import org.apache.druid.segment.column.ColumnCapabilitiesImpl;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.RowSignature;
import org.apache.druid.segment.column.TypeSignature;
import org.apache.druid.segment.column.ValueType;
import org.apache.druid.segment.filter.AndFilter;
import org.apache.druid.segment.filter.BoundFilter;
import org.apache.druid.segment.filter.Filters;
import org.apache.druid.segment.filter.LikeFilter;
import org.apache.druid.segment.filter.NotFilter;
import org.apache.druid.segment.filter.OrFilter;
import org.apache.druid.segment.filter.SelectorFilter;
import org.apache.druid.segment.join.PostJoinCursor;
import org.apache.druid.segment.virtual.ExpressionVirtualColumn;
import org.apache.druid.utils.CloseableUtils;

public class UnnestCursorFactory
implements CursorFactory {
    private final CursorFactory baseCursorFactory;
    private final VirtualColumn unnestColumn;
    @Nullable
    private final DimFilter filter;

    public UnnestCursorFactory(CursorFactory baseCursorFactory, VirtualColumn unnestColumn, @Nullable DimFilter filter) {
        this.baseCursorFactory = baseCursorFactory;
        this.unnestColumn = unnestColumn;
        this.filter = filter;
    }

    @Override
    public CursorHolder makeCursorHolder(final CursorBuildSpec spec) {
        String input = this.getUnnestInputIfDirectAccess(this.unnestColumn);
        final UnnestFilterSplit filterSplit = UnnestCursorFactory.computeBaseAndPostUnnestFilters(spec.getFilter(), this.filter != null ? this.filter.toFilter() : null, spec.getVirtualColumns(), this.unnestColumn, input, input == null ? null : spec.getVirtualColumns().getColumnCapabilitiesWithFallback(this.baseCursorFactory, input));
        final CursorBuildSpec unnestBuildSpec = UnnestCursorFactory.transformCursorBuildSpec(spec, this.unnestColumn, filterSplit.getBaseTableFilter());
        return new CursorHolder(){
            final Closer closer = Closer.create();
            final Supplier<CursorHolder> cursorHolderSupplier = Suppliers.memoize(() -> this.closer.register(UnnestCursorFactory.this.baseCursorFactory.makeCursorHolder(unnestBuildSpec)));

            @Override
            public Cursor asCursor() {
                Cursor cursor = this.cursorHolderSupplier.get().asCursor();
                if (cursor == null) {
                    return null;
                }
                ColumnCapabilities capabilities = UnnestCursorFactory.this.unnestColumn.capabilities(cursor.getColumnSelectorFactory(), UnnestCursorFactory.this.unnestColumn.getOutputName());
                Cursor unnestCursor = UnnestCursorFactory.useDimensionCursor(capabilities) ? new UnnestDimensionCursor(cursor, cursor.getColumnSelectorFactory(), UnnestCursorFactory.this.unnestColumn) : new UnnestColumnValueSelectorCursor(cursor, cursor.getColumnSelectorFactory(), UnnestCursorFactory.this.unnestColumn);
                return PostJoinCursor.wrap(unnestCursor, spec.getVirtualColumns(), filterSplit.getPostUnnestFilter());
            }

            @Override
            public List<OrderBy> getOrdering() {
                return UnnestCursorFactory.this.computeOrdering(this.cursorHolderSupplier.get().getOrdering());
            }

            @Override
            public void close() {
                CloseableUtils.closeAndWrapExceptions(this.closer);
            }
        };
    }

    @Override
    public RowSignature getRowSignature() {
        RowSignature.Builder builder = RowSignature.builder();
        RowSignature baseSignature = this.baseCursorFactory.getRowSignature();
        for (int i = 0; i < baseSignature.size(); ++i) {
            String column = baseSignature.getColumnName(i);
            if (this.unnestColumn.getOutputName().equals(column)) continue;
            builder.add(column, ColumnType.fromCapabilities(this.getColumnCapabilities(column)));
        }
        return builder.add(this.unnestColumn.getOutputName(), ColumnType.fromCapabilities(this.getColumnCapabilities(this.unnestColumn.getOutputName()))).build();
    }

    @Override
    @Nullable
    public ColumnCapabilities getColumnCapabilities(String column) {
        if (this.unnestColumn.getOutputName().equals(column)) {
            return UnnestCursorFactory.computeOutputColumnCapabilities(this.baseCursorFactory, this.unnestColumn);
        }
        return this.baseCursorFactory.getColumnCapabilities(column);
    }

    @VisibleForTesting
    public VirtualColumn getUnnestColumn() {
        return this.unnestColumn;
    }

    @Nullable
    @VisibleForTesting
    public String getUnnestInputIfDirectAccess(VirtualColumn unnestColumn) {
        if (unnestColumn instanceof ExpressionVirtualColumn) {
            return ((Expr)((ExpressionVirtualColumn)unnestColumn).getParsedExpression().get()).getBindingIfIdentifier();
        }
        return null;
    }

    @VisibleForTesting
    static UnnestFilterSplit computeBaseAndPostUnnestFilters(@Nullable Filter queryFilter, @Nullable Filter unnestFilter, VirtualColumns queryVirtualColumns, VirtualColumn unnestColumn, @Nullable String inputColumn, @Nullable ColumnCapabilities inputColumnCapabilites) {
        FilterSplitter filterSplitter = new FilterSplitter(inputColumn, inputColumnCapabilites, unnestColumn, queryVirtualColumns);
        if (queryFilter != null) {
            if (queryFilter.getRequiredColumns().contains(unnestColumn.getOutputName())) {
                if (queryFilter instanceof BooleanFilter) {
                    List<Filter> preFilterList = UnnestCursorFactory.recursiveRewriteOnUnnestFilters((BooleanFilter)queryFilter, unnestColumn, inputColumn, inputColumnCapabilites, filterSplitter);
                    if (!preFilterList.isEmpty()) {
                        if (queryFilter instanceof AndFilter) {
                            filterSplitter.addPreFilter(new AndFilter(preFilterList));
                        } else if (queryFilter instanceof OrFilter && filterSplitter.getPreFilterCount() == filterSplitter.getOriginalFilterCount()) {
                            filterSplitter.addPreFilter(new OrFilter(preFilterList));
                        }
                    }
                    filterSplitter.addPostFilterWithPreFilterIfRewritePossible(queryFilter, true);
                } else {
                    filterSplitter.addPostFilterWithPreFilterIfRewritePossible(queryFilter, false);
                }
            } else {
                filterSplitter.addPreFilter(queryFilter);
            }
        }
        filterSplitter.addPostFilterWithPreFilterIfRewritePossible(unnestFilter, false);
        return new UnnestFilterSplit(Filters.maybeAnd(filterSplitter.filtersPushedDownToBaseCursor).orElse(null), Filters.maybeAnd(filterSplitter.filtersForPostUnnestCursor).orElse(null));
    }

    private static List<Filter> recursiveRewriteOnUnnestFilters(BooleanFilter queryFilter, VirtualColumn unnestColumn, String inputColumn, ColumnCapabilities inputColumnCapabilites, FilterSplitter filterSplitter) {
        ArrayList<Filter> preFilterList = new ArrayList<Filter>();
        for (Filter filter : queryFilter.getFilters()) {
            if (filter.getRequiredColumns().contains(unnestColumn.getOutputName())) {
                if (filter instanceof AndFilter) {
                    List<Filter> andChildFilters = UnnestCursorFactory.recursiveRewriteOnUnnestFilters((BooleanFilter)filter, unnestColumn, inputColumn, inputColumnCapabilites, filterSplitter);
                    if (andChildFilters.isEmpty()) continue;
                    preFilterList.add(new AndFilter(andChildFilters));
                    continue;
                }
                if (filter instanceof OrFilter) {
                    List<Filter> orChildFilters = UnnestCursorFactory.recursiveRewriteOnUnnestFilters((BooleanFilter)filter, unnestColumn, inputColumn, inputColumnCapabilites, filterSplitter);
                    if (orChildFilters.size() != ((OrFilter)filter).getFilters().size()) continue;
                    preFilterList.add(new OrFilter(orChildFilters));
                    continue;
                }
                if (filter instanceof NotFilter) continue;
                Filter newFilter = UnnestCursorFactory.rewriteFilterOnUnnestColumnIfPossible(filter, unnestColumn, inputColumn, inputColumnCapabilites);
                if (newFilter != null) {
                    preFilterList.add(newFilter);
                    filterSplitter.addToPreFilterCount(1);
                }
                filterSplitter.addToOriginalFilterCount(1);
                continue;
            }
            preFilterList.add(filter);
            int filterCount = Filters.countNumberOfFilters(filter);
            filterSplitter.addToOriginalFilterCount(filterCount);
            filterSplitter.addToPreFilterCount(filterCount);
        }
        return preFilterList;
    }

    private List<OrderBy> computeOrdering(List<OrderBy> baseOrdering) {
        String columnName;
        int limit;
        for (limit = 0; limit < baseOrdering.size() && !(columnName = baseOrdering.get(limit).getColumnName()).equals(this.unnestColumn.getOutputName()); ++limit) {
        }
        return limit == baseOrdering.size() ? baseOrdering : baseOrdering.subList(0, limit);
    }

    @Nullable
    private static Filter rewriteFilterOnUnnestColumnIfPossible(Filter filter, VirtualColumn unnestColumn, @Nullable String inputColumn, @Nullable ColumnCapabilities inputColumnCapabilities) {
        if (inputColumn == null || inputColumnCapabilities == null || inputColumnCapabilities.getType() != ValueType.STRING) {
            return null;
        }
        if (UnnestCursorFactory.filterMapsOverMultiValueStrings(filter)) {
            return filter.rewriteRequiredColumns((Map<String, String>)ImmutableMap.of((Object)unnestColumn.getOutputName(), (Object)inputColumn));
        }
        return null;
    }

    @Nullable
    static ColumnCapabilities computeOutputColumnCapabilities(ColumnInspector baseColumnInspector, VirtualColumn unnestColumn) {
        ColumnCapabilities capabilities = unnestColumn.capabilities(baseColumnInspector, unnestColumn.getOutputName());
        if (capabilities == null) {
            return null;
        }
        ColumnType outputType = capabilities.isArray() ? capabilities.getElementType() : capabilities.toColumnType();
        boolean useDimensionCursor = UnnestCursorFactory.useDimensionCursor(capabilities);
        return ColumnCapabilitiesImpl.createDefault().setType((TypeSignature<ValueType>)outputType).setHasMultipleValues(false).setDictionaryEncoded(useDimensionCursor).setDictionaryValuesUnique(useDimensionCursor);
    }

    @VisibleForTesting
    static CursorBuildSpec transformCursorBuildSpec(CursorBuildSpec spec, VirtualColumn unnestColumn, @Nullable Filter baseTableFilter) {
        HashSet<String> physicalColumns;
        if (spec.getPhysicalColumns() == null) {
            physicalColumns = null;
        } else {
            physicalColumns = new HashSet<String>();
            for (String column : spec.getPhysicalColumns()) {
                if (column.equals(unnestColumn.getOutputName())) continue;
                physicalColumns.add(column);
            }
            for (String input : unnestColumn.requiredColumns()) {
                if (spec.getVirtualColumns().exists(input)) continue;
                physicalColumns.add(input);
            }
            if (baseTableFilter != null) {
                for (String column : baseTableFilter.getRequiredColumns()) {
                    if (spec.getVirtualColumns().exists(column)) continue;
                    physicalColumns.add(column);
                }
            }
        }
        Order timeOrder = Cursors.getTimeOrdering(spec.getPreferredOrdering());
        List<OrderBy> maybeOrderByTime = List.of();
        if (timeOrder == Order.DESCENDING) {
            maybeOrderByTime = Cursors.descendingTimeOrder();
        } else if (timeOrder == Order.ASCENDING) {
            maybeOrderByTime = Cursors.ascendingTimeOrder();
        }
        return CursorBuildSpec.builder().setInterval(spec.getInterval()).setFilter(baseTableFilter).setPhysicalColumns(physicalColumns).setVirtualColumns(VirtualColumns.create(List.of(unnestColumn))).setPreferredOrdering(maybeOrderByTime).setQueryContext(spec.getQueryContext()).setQueryMetrics(spec.getQueryMetrics()).build();
    }

    private static boolean filterMapsOverMultiValueStrings(Filter filter) {
        if (filter instanceof BooleanFilter) {
            for (Filter child : ((BooleanFilter)filter).getFilters()) {
                if (UnnestCursorFactory.filterMapsOverMultiValueStrings(child)) continue;
                return false;
            }
            return true;
        }
        if (filter instanceof NotFilter) {
            return false;
        }
        return filter instanceof SelectorFilter || filter instanceof InDimFilter || filter instanceof LikeFilter || filter instanceof BoundFilter || filter instanceof NullFilter || filter instanceof EqualityFilter || filter instanceof RangeFilter;
    }

    private static boolean useDimensionCursor(@Nullable ColumnCapabilities capabilities) {
        if (capabilities == null) {
            return false;
        }
        if (capabilities.isDictionaryEncoded().and(capabilities.areDictionaryValuesUnique()).isTrue()) {
            return capabilities.is(ValueType.STRING);
        }
        return false;
    }

    @VisibleForTesting
    static final class UnnestFilterSplit {
        @Nullable
        private final Filter baseTableFilter;
        @Nullable
        private final Filter postUnnestFilter;

        private UnnestFilterSplit(@Nullable Filter baseTableFilter, @Nullable Filter postUnnestFilter) {
            this.baseTableFilter = baseTableFilter;
            this.postUnnestFilter = postUnnestFilter;
        }

        @Nullable
        public Filter getBaseTableFilter() {
            return this.baseTableFilter;
        }

        @Nullable
        public Filter getPostUnnestFilter() {
            return this.postUnnestFilter;
        }
    }

    private static class FilterSplitter {
        private final String inputColumn;
        private final ColumnCapabilities inputColumnCapabilites;
        private final VirtualColumn unnestColumn;
        private final VirtualColumns queryVirtualColumns;
        private int originalFilterCount = 0;
        private int preFilterCount = 0;
        final List<Filter> filtersPushedDownToBaseCursor = new ArrayList<Filter>();
        final List<Filter> filtersForPostUnnestCursor = new ArrayList<Filter>();

        public FilterSplitter(String inputColumn, ColumnCapabilities inputColumnCapabilites, VirtualColumn unnestColumn, VirtualColumns queryVirtualColumns) {
            this.inputColumn = inputColumn;
            this.inputColumnCapabilites = inputColumnCapabilites;
            this.unnestColumn = unnestColumn;
            this.queryVirtualColumns = queryVirtualColumns;
        }

        void addPostFilterWithPreFilterIfRewritePossible(@Nullable Filter filter, boolean skipPreFilters) {
            Filter newFilter;
            if (filter == null) {
                return;
            }
            if (!skipPreFilters && (newFilter = UnnestCursorFactory.rewriteFilterOnUnnestColumnIfPossible(filter, this.unnestColumn, this.inputColumn, this.inputColumnCapabilites)) != null) {
                this.filtersPushedDownToBaseCursor.add(newFilter);
            }
            this.filtersForPostUnnestCursor.add(filter);
        }

        void addPreFilter(@Nullable Filter filter) {
            if (filter == null) {
                return;
            }
            Set<String> requiredColumns = filter.getRequiredColumns();
            if (this.queryVirtualColumns.getVirtualColumns().length > 0) {
                for (String column : requiredColumns) {
                    if (!this.queryVirtualColumns.exists(column)) continue;
                    this.filtersForPostUnnestCursor.add(filter);
                    return;
                }
            }
            this.filtersPushedDownToBaseCursor.add(filter);
        }

        public void addToOriginalFilterCount(int c) {
            this.originalFilterCount += c;
        }

        public void addToPreFilterCount(int c) {
            this.preFilterCount += c;
        }

        public int getOriginalFilterCount() {
            return this.originalFilterCount;
        }

        public int getPreFilterCount() {
            return this.preFilterCount;
        }
    }
}

