/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.shim;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.apache.druid.query.filter.DruidPredicateFactory;
import org.apache.druid.query.filter.ValueMatcher;
import org.apache.druid.query.monomorphicprocessing.RuntimeShapeInspector;
import org.apache.druid.segment.DimensionSelector;
import org.apache.druid.segment.DimensionSelectorUtils;
import org.apache.druid.segment.IdLookup;
import org.apache.druid.segment.data.IndexedInts;
import org.apache.druid.segment.data.SingleIndexedInt;
import org.apache.druid.segment.shim.ShimCursor;
import org.apache.druid.segment.vector.ReadableVectorInspector;
import org.apache.druid.segment.vector.SingleValueDimensionVectorSelector;

public class ShimSingleValueDimensionSelector
implements DimensionSelector {
    private final ShimCursor cursor;
    private final ReadableVectorInspector vectorInspector;
    private final SingleValueDimensionVectorSelector vectorSelector;
    private final SingleIndexedInt currentRow = new SingleIndexedInt();
    private int[] rowVector;
    private int currentId = -1;

    public ShimSingleValueDimensionSelector(ShimCursor cursor, SingleValueDimensionVectorSelector vectorSelector) {
        this.cursor = cursor;
        this.vectorInspector = cursor.vectorColumnSelectorFactory.getReadableVectorInspector();
        this.vectorSelector = vectorSelector;
    }

    @Override
    public IndexedInts getRow() {
        this.populateRowVector();
        this.currentRow.setValue(this.rowVector[this.cursor.currentIndexInVector]);
        return this.currentRow;
    }

    @Override
    @Nullable
    public Object getObject() {
        this.populateRowVector();
        return this.lookupName(this.rowVector[this.cursor.currentIndexInVector]);
    }

    @Override
    public ValueMatcher makeValueMatcher(@Nullable String value) {
        return DimensionSelectorUtils.makeValueMatcherGeneric((DimensionSelector)this, value);
    }

    @Override
    public ValueMatcher makeValueMatcher(DruidPredicateFactory predicateFactory) {
        return DimensionSelectorUtils.makeValueMatcherGeneric((DimensionSelector)this, predicateFactory);
    }

    @Override
    public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
    }

    @Override
    public Class<?> classOfObject() {
        return String.class;
    }

    @Override
    public int getValueCardinality() {
        return this.vectorSelector.getValueCardinality();
    }

    @Override
    public boolean supportsLookupNameUtf8() {
        return this.vectorSelector.supportsLookupNameUtf8();
    }

    @Override
    @Nullable
    public String lookupName(int id) {
        return this.vectorSelector.lookupName(id);
    }

    @Override
    @Nullable
    public ByteBuffer lookupNameUtf8(int id) {
        return this.vectorSelector.lookupNameUtf8(id);
    }

    @Override
    public boolean nameLookupPossibleInAdvance() {
        return this.vectorSelector.nameLookupPossibleInAdvance();
    }

    @Override
    @Nullable
    public IdLookup idLookup() {
        return this.vectorSelector.idLookup();
    }

    private void populateRowVector() {
        int id = this.vectorInspector.getId();
        if (id != this.currentId) {
            this.rowVector = this.vectorSelector.getRowVector();
            this.currentId = id;
        }
    }
}

