/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.guice.http;

import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableSet;
import com.google.inject.Binder;
import com.google.inject.Inject;
import com.google.inject.Module;
import com.google.inject.Provider;
import java.lang.annotation.Annotation;
import java.util.Set;
import javax.net.ssl.SSLContext;
import org.apache.druid.guice.JsonConfigProvider;
import org.apache.druid.guice.LazySingleton;
import org.apache.druid.guice.annotations.EscalatedClient;
import org.apache.druid.guice.annotations.EscalatedGlobal;
import org.apache.druid.guice.annotations.Global;
import org.apache.druid.guice.http.AbstractHttpClientProvider;
import org.apache.druid.guice.http.DruidHttpClientConfig;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.lifecycle.Lifecycle;
import org.apache.druid.java.util.http.client.HttpClient;
import org.apache.druid.java.util.http.client.HttpClientConfig;
import org.apache.druid.java.util.http.client.HttpClientInit;
import org.apache.druid.server.security.Escalator;

public class HttpClientModule
implements Module {
    private static final Set<Class<? extends Annotation>> ESCALATING_ANNOTATIONS = ImmutableSet.of(EscalatedGlobal.class, EscalatedClient.class);
    private final String propertyPrefix;
    private Annotation annotation = null;
    private Class<? extends Annotation> annotationClazz = null;
    private boolean isEscalated = false;

    public static HttpClientModule global() {
        return new HttpClientModule("druid.global.http", Global.class);
    }

    public static HttpClientModule escalatedGlobal() {
        return new HttpClientModule("druid.global.http", EscalatedGlobal.class);
    }

    public HttpClientModule(String propertyPrefix) {
        this.propertyPrefix = propertyPrefix;
    }

    public HttpClientModule(String propertyPrefix, Class<? extends Annotation> annotation) {
        this.propertyPrefix = propertyPrefix;
        this.annotationClazz = annotation;
        this.isEscalated = ESCALATING_ANNOTATIONS.contains(this.annotationClazz);
    }

    public HttpClientModule(String propertyPrefix, Annotation annotation) {
        this.propertyPrefix = propertyPrefix;
        this.annotation = annotation;
    }

    public void configure(Binder binder) {
        if (this.annotation != null) {
            JsonConfigProvider.bind((Binder)binder, (String)this.propertyPrefix, DruidHttpClientConfig.class, (Annotation)this.annotation);
            binder.bind(HttpClient.class).annotatedWith(this.annotation).toProvider((Provider)new HttpClientProvider(this.annotation, this.isEscalated)).in(LazySingleton.class);
        } else if (this.annotationClazz != null) {
            JsonConfigProvider.bind((Binder)binder, (String)this.propertyPrefix, DruidHttpClientConfig.class, this.annotationClazz);
            binder.bind(HttpClient.class).annotatedWith(this.annotationClazz).toProvider((Provider)new HttpClientProvider(this.annotationClazz, this.isEscalated)).in(LazySingleton.class);
        } else {
            JsonConfigProvider.bind((Binder)binder, (String)this.propertyPrefix, DruidHttpClientConfig.class);
            binder.bind(HttpClient.class).toProvider((Provider)new HttpClientProvider(this.isEscalated)).in(LazySingleton.class);
        }
    }

    public static class HttpClientProvider
    extends AbstractHttpClientProvider<HttpClient> {
        private boolean isEscalated;
        private Escalator escalator;

        public HttpClientProvider(boolean isEscalated) {
            this.isEscalated = isEscalated;
        }

        public HttpClientProvider(Annotation annotation, boolean isEscalated) {
            super(annotation);
            this.isEscalated = isEscalated;
        }

        public HttpClientProvider(Class<? extends Annotation> annotationClazz, boolean isEscalated) {
            super(annotationClazz);
            this.isEscalated = isEscalated;
        }

        @Inject
        public void inject(Escalator escalator) {
            this.escalator = escalator;
        }

        public HttpClient get() {
            DruidHttpClientConfig config = (DruidHttpClientConfig)((Supplier)this.getConfigProvider().get()).get();
            HttpClientConfig.Builder builder = HttpClientConfig.builder().withNumConnections(config.getNumConnections()).withReadTimeout(config.getReadTimeout()).withWorkerCount(config.getNumMaxThreads()).withCompressionCodec(HttpClientConfig.CompressionCodec.valueOf((String)StringUtils.toUpperCase((String)config.getCompressionCodec()))).withUnusedConnectionTimeoutDuration(config.getUnusedConnectionTimeout());
            if (this.getSslContextBinding() != null) {
                builder.withSslContext((SSLContext)this.getSslContextBinding().getProvider().get());
            }
            HttpClient client = HttpClientInit.createClient((HttpClientConfig)builder.build(), (Lifecycle)((Lifecycle)this.getLifecycleProvider().get()));
            if (this.isEscalated) {
                return this.escalator.createEscalatedClient(client);
            }
            return client;
        }
    }
}

