/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.metadata;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.metadata.MetadataStorageActionHandlerTypes;
import org.apache.druid.metadata.SQLMetadataConnector;
import org.apache.druid.metadata.SQLMetadataStorageActionHandler;
import org.joda.time.DateTime;
import org.skife.jdbi.v2.Handle;
import org.skife.jdbi.v2.Query;

public class SQLServerMetadataStorageActionHandler<EntryType, StatusType, LogType, LockType>
extends SQLMetadataStorageActionHandler<EntryType, StatusType, LogType, LockType> {
    public SQLServerMetadataStorageActionHandler(SQLMetadataConnector connector, ObjectMapper jsonMapper, MetadataStorageActionHandlerTypes<EntryType, StatusType, LogType, LockType> types, String entryTypeName, String entryTable, String logTable, String lockTable) {
        super(connector, jsonMapper, types, entryTypeName, entryTable, logTable, lockTable);
    }

    @Override
    protected Query<Map<String, Object>> createCompletedTaskInfoQuery(Handle handle, DateTime timestamp, @Nullable Integer maxNumStatuses, @Nullable String dataSource) {
        String sql = maxNumStatuses == null ? "SELECT " : "SELECT TOP (:n) ";
        sql = sql + StringUtils.format((String)("    id,   status_payload,   created_date,   datasource,   payload FROM   %s WHERE " + this.getWhereClauseForInactiveStatusesSinceQuery(dataSource) + "ORDER BY created_date DESC"), (Object[])new Object[]{this.getEntryTable()});
        Query query = (Query)handle.createQuery(sql).bind("start", timestamp.toString());
        if (maxNumStatuses != null) {
            query = (Query)query.bind("n", maxNumStatuses);
        }
        if (dataSource != null) {
            query = (Query)query.bind("ds", dataSource);
        }
        return query;
    }

    private String getWhereClauseForInactiveStatusesSinceQuery(@Nullable String datasource) {
        String sql = StringUtils.format((String)"active = FALSE AND created_date >= :start ", (Object[])new Object[0]);
        if (datasource != null) {
            sql = sql + " AND datasource = :ds ";
        }
        return sql;
    }
}

