/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiFunction;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.guava.BaseSequence;
import org.apache.druid.java.util.common.guava.MergeSequence;
import org.apache.druid.java.util.common.guava.Sequence;
import org.apache.druid.java.util.common.guava.Yielder;
import org.apache.druid.java.util.common.guava.YieldingAccumulator;
import org.apache.druid.java.util.common.guava.YieldingSequenceBase;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.query.Queries;
import org.apache.druid.query.Query;
import org.apache.druid.query.QueryPlus;
import org.apache.druid.query.QueryRunner;
import org.apache.druid.query.RetryQueryRunnerConfig;
import org.apache.druid.query.SegmentDescriptor;
import org.apache.druid.query.context.ResponseContext;
import org.apache.druid.segment.SegmentMissingException;

public class RetryQueryRunner<T>
implements QueryRunner<T> {
    private static final Logger LOG = new Logger(RetryQueryRunner.class);
    private final QueryRunner<T> baseRunner;
    private final BiFunction<Query<T>, List<SegmentDescriptor>, QueryRunner<T>> retryRunnerCreateFn;
    private final RetryQueryRunnerConfig config;
    private final ObjectMapper jsonMapper;
    private final Runnable runnableAfterFirstAttempt;
    private int totalNumRetries;

    public RetryQueryRunner(QueryRunner<T> baseRunner, BiFunction<Query<T>, List<SegmentDescriptor>, QueryRunner<T>> retryRunnerCreateFn, RetryQueryRunnerConfig config, ObjectMapper jsonMapper) {
        this(baseRunner, retryRunnerCreateFn, config, jsonMapper, () -> {});
    }

    @VisibleForTesting
    RetryQueryRunner(QueryRunner<T> baseRunner, BiFunction<Query<T>, List<SegmentDescriptor>, QueryRunner<T>> retryRunnerCreateFn, RetryQueryRunnerConfig config, ObjectMapper jsonMapper, Runnable runnableAfterFirstAttempt) {
        this.baseRunner = baseRunner;
        this.retryRunnerCreateFn = retryRunnerCreateFn;
        this.config = config;
        this.jsonMapper = jsonMapper;
        this.runnableAfterFirstAttempt = runnableAfterFirstAttempt;
    }

    @VisibleForTesting
    int getTotalNumRetries() {
        return this.totalNumRetries;
    }

    public Sequence<T> run(final QueryPlus<T> queryPlus, final ResponseContext context) {
        return new YieldingSequenceBase<T>(){

            public <OutType> Yielder<OutType> toYielder(OutType initValue, YieldingAccumulator<OutType, T> accumulator) {
                BaseSequence retryingSequence = new BaseSequence(new BaseSequence.IteratorMaker<Sequence<T>, RetryingSequenceIterator>(){

                    public RetryingSequenceIterator make() {
                        return new RetryingSequenceIterator(queryPlus, context, RetryQueryRunner.this.baseRunner, RetryQueryRunner.this.runnableAfterFirstAttempt);
                    }

                    public void cleanup(RetryingSequenceIterator iterFromMake) {
                        RetryQueryRunner.this.totalNumRetries = iterFromMake.retryCount;
                    }
                });
                return new MergeSequence(queryPlus.getQuery().getResultOrdering(), (Sequence)retryingSequence).toYielder(initValue, accumulator);
            }
        };
    }

    private List<SegmentDescriptor> getMissingSegments(QueryPlus<T> queryPlus, ResponseContext context) {
        ConcurrentHashMap idToRemainingResponses = (ConcurrentHashMap)Preconditions.checkNotNull((Object)context.get((ResponseContext.BaseKey)ResponseContext.Key.REMAINING_RESPONSES_FROM_QUERY_SERVERS), (String)"%s in responseContext", (Object[])new Object[]{ResponseContext.Key.REMAINING_RESPONSES_FROM_QUERY_SERVERS.getName()});
        int remainingResponses = (Integer)Preconditions.checkNotNull(idToRemainingResponses.get(queryPlus.getQuery().getMostSpecificId()), (String)"Number of remaining responses for query[%s]", (Object[])new Object[]{queryPlus.getQuery().getMostSpecificId()});
        if (remainingResponses > 0) {
            throw new ISE("Failed to check missing segments due to missing responses from [%d] servers", new Object[]{remainingResponses});
        }
        Object maybeMissingSegments = context.get((ResponseContext.BaseKey)ResponseContext.Key.MISSING_SEGMENTS);
        if (maybeMissingSegments == null) {
            return Collections.emptyList();
        }
        return (List)this.jsonMapper.convertValue(maybeMissingSegments, (TypeReference)new TypeReference<List<SegmentDescriptor>>(){});
    }

    private class RetryingSequenceIterator
    implements Iterator<Sequence<T>> {
        private final QueryPlus<T> queryPlus;
        private final ResponseContext context;
        private final QueryRunner<T> baseQueryRunner;
        private final Runnable runnableAfterFirstAttempt;
        private boolean first = true;
        private Sequence<T> sequence = null;
        private int retryCount = 0;

        private RetryingSequenceIterator(QueryPlus<T> queryPlus, ResponseContext context, QueryRunner<T> baseQueryRunner, Runnable runnableAfterFirstAttempt) {
            this.queryPlus = queryPlus;
            this.context = context;
            this.baseQueryRunner = baseQueryRunner;
            this.runnableAfterFirstAttempt = runnableAfterFirstAttempt;
        }

        @Override
        public boolean hasNext() {
            if (this.first) {
                this.sequence = this.baseQueryRunner.run(this.queryPlus, this.context);
                this.runnableAfterFirstAttempt.run();
                this.first = false;
                return true;
            }
            if (this.sequence != null) {
                return true;
            }
            List missingSegments = RetryQueryRunner.this.getMissingSegments(this.queryPlus, this.context);
            if (missingSegments.isEmpty()) {
                return false;
            }
            if (this.retryCount >= RetryQueryRunner.this.config.getNumTries()) {
                if (!RetryQueryRunner.this.config.isReturnPartialResults()) {
                    throw new SegmentMissingException("No results found for segments[%s]", new Object[]{missingSegments});
                }
                return false;
            }
            ++this.retryCount;
            LOG.info("[%,d] missing segments found. Retry attempt [%,d]", new Object[]{missingSegments.size(), this.retryCount});
            this.context.put((ResponseContext.BaseKey)ResponseContext.Key.MISSING_SEGMENTS, new ArrayList());
            QueryPlus retryQueryPlus = this.queryPlus.withQuery(Queries.withSpecificSegments((Query)this.queryPlus.getQuery(), (List)missingSegments));
            this.sequence = ((QueryRunner)RetryQueryRunner.this.retryRunnerCreateFn.apply(retryQueryPlus.getQuery(), missingSegments)).run(retryQueryPlus, this.context);
            return true;
        }

        @Override
        public Sequence<T> next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            Sequence next = this.sequence;
            this.sequence = null;
            return next;
        }
    }
}

