/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.loading;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.annotations.VisibleForTesting;
import com.google.inject.Inject;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.druid.guice.annotations.Json;
import org.apache.druid.java.util.common.FileUtils;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.emitter.EmittingLogger;
import org.apache.druid.segment.IndexIO;
import org.apache.druid.segment.Segment;
import org.apache.druid.segment.loading.DataSegmentPusher;
import org.apache.druid.segment.loading.LoadSpec;
import org.apache.druid.segment.loading.MMappedQueryableSegmentizerFactory;
import org.apache.druid.segment.loading.SegmentLoader;
import org.apache.druid.segment.loading.SegmentLoaderConfig;
import org.apache.druid.segment.loading.SegmentLoadingException;
import org.apache.druid.segment.loading.SegmentizerFactory;
import org.apache.druid.segment.loading.StorageLocation;
import org.apache.druid.segment.loading.StorageLocationConfig;
import org.apache.druid.segment.loading.StorageLocationSelectorStrategy;
import org.apache.druid.timeline.DataSegment;

public class SegmentLoaderLocalCacheManager
implements SegmentLoader {
    private static final EmittingLogger log = new EmittingLogger(SegmentLoaderLocalCacheManager.class);
    private final IndexIO indexIO;
    private final SegmentLoaderConfig config;
    private final ObjectMapper jsonMapper;
    private final List<StorageLocation> locations;
    private final Object directoryWriteRemoveLock = new Object();
    private final ConcurrentHashMap<DataSegment, ReferenceCountingLock> segmentLocks = new ConcurrentHashMap();
    private final StorageLocationSelectorStrategy strategy;

    @Inject
    public SegmentLoaderLocalCacheManager(IndexIO indexIO, SegmentLoaderConfig config, @Json ObjectMapper mapper) {
        this.indexIO = indexIO;
        this.config = config;
        this.jsonMapper = mapper;
        this.locations = new ArrayList<StorageLocation>();
        for (StorageLocationConfig locationConfig : config.getLocations()) {
            this.locations.add(new StorageLocation(locationConfig.getPath(), locationConfig.getMaxSize(), locationConfig.getFreeSpacePercent()));
        }
        this.strategy = config.getStorageLocationSelectorStrategy(this.locations);
    }

    @Override
    public boolean isSegmentLoaded(DataSegment segment) {
        return this.findStorageLocationIfLoaded(segment) != null;
    }

    private StorageLocation findStorageLocationIfLoaded(DataSegment segment) {
        for (StorageLocation location : this.locations) {
            File localStorageDir = new File(location.getPath(), DataSegmentPusher.getDefaultStorageDir((DataSegment)segment, (boolean)false));
            if (!localStorageDir.exists()) continue;
            return location;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Segment getSegment(DataSegment segment, boolean lazy) throws SegmentLoadingException {
        MMappedQueryableSegmentizerFactory factory;
        File segmentFiles;
        ReferenceCountingLock lock;
        ReferenceCountingLock referenceCountingLock = lock = this.createOrGetLock(segment);
        synchronized (referenceCountingLock) {
            try {
                segmentFiles = this.getSegmentFiles(segment);
            }
            finally {
                this.unlock(segment, lock);
            }
        }
        File factoryJson = new File(segmentFiles, "factory.json");
        if (factoryJson.exists()) {
            try {
                factory = (SegmentizerFactory)this.jsonMapper.readValue(factoryJson, SegmentizerFactory.class);
            }
            catch (IOException e) {
                throw new SegmentLoadingException((Throwable)e, "%s", new Object[]{e.getMessage()});
            }
        } else {
            factory = new MMappedQueryableSegmentizerFactory(this.indexIO);
        }
        return factory.factorize(segment, segmentFiles, lazy);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public File getSegmentFiles(DataSegment segment) throws SegmentLoadingException {
        ReferenceCountingLock lock;
        ReferenceCountingLock referenceCountingLock = lock = this.createOrGetLock(segment);
        synchronized (referenceCountingLock) {
            File file;
            try {
                StorageLocation loc = this.findStorageLocationIfLoaded(segment);
                String storageDir = DataSegmentPusher.getDefaultStorageDir((DataSegment)segment, (boolean)false);
                if (loc == null) {
                    loc = this.loadSegmentWithRetry(segment, storageDir);
                }
                file = new File(loc.getPath(), storageDir);
                this.unlock(segment, lock);
            }
            catch (Throwable throwable) {
                this.unlock(segment, lock);
                throw throwable;
            }
            return file;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private StorageLocation loadSegmentWithRetry(DataSegment segment, String storageDirStr) throws SegmentLoadingException {
        Iterator<StorageLocation> locationsIterator = this.strategy.getLocations();
        while (locationsIterator.hasNext()) {
            StorageLocation loc = locationsIterator.next();
            File storageDir = loc.reserve(storageDirStr, segment);
            if (storageDir == null) continue;
            try {
                this.loadInLocationWithStartMarker(segment, storageDir);
                return loc;
            }
            catch (SegmentLoadingException e) {
                try {
                    log.makeAlert((Throwable)e, "Failed to load segment in current location [%s], try next location if any", new Object[]{loc.getPath().getAbsolutePath()}).addData("location", (Object)loc.getPath().getAbsolutePath()).emit();
                }
                finally {
                    loc.removeSegmentDir(storageDir, segment);
                    this.cleanupCacheFiles(loc.getPath(), storageDir);
                }
            }
        }
        throw new SegmentLoadingException("Failed to load segment %s in all locations.", new Object[]{segment.getId()});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadInLocationWithStartMarker(DataSegment segment, File storageDir) throws SegmentLoadingException {
        File downloadStartMarker = new File(storageDir, "downloadStartMarker");
        Object object = this.directoryWriteRemoveLock;
        synchronized (object) {
            if (!storageDir.mkdirs()) {
                log.debug("Unable to make parent file[%s]", new Object[]{storageDir});
            }
            try {
                if (!downloadStartMarker.createNewFile()) {
                    throw new SegmentLoadingException("Was not able to create new download marker for [%s]", new Object[]{storageDir});
                }
            }
            catch (IOException e) {
                throw new SegmentLoadingException((Throwable)e, "Unable to create marker file for [%s]", new Object[]{storageDir});
            }
        }
        this.loadInLocation(segment, storageDir);
        if (!downloadStartMarker.delete()) {
            throw new SegmentLoadingException("Unable to remove marker file for [%s]", new Object[]{storageDir});
        }
    }

    private void loadInLocation(DataSegment segment, File storageDir) throws SegmentLoadingException {
        LoadSpec loadSpec = (LoadSpec)this.jsonMapper.convertValue((Object)segment.getLoadSpec(), LoadSpec.class);
        LoadSpec.LoadSpecResult result = loadSpec.loadSegment(storageDir);
        if (result.getSize() != segment.getSize()) {
            log.warn("Segment [%s] is different than expected size. Expected [%d] found [%d]", new Object[]{segment.getId(), segment.getSize(), result.getSize()});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cleanup(DataSegment segment) {
        ReferenceCountingLock lock;
        if (!this.config.isDeleteOnRemove()) {
            return;
        }
        ReferenceCountingLock referenceCountingLock = lock = this.createOrGetLock(segment);
        synchronized (referenceCountingLock) {
            try {
                StorageLocation loc = this.findStorageLocationIfLoaded(segment);
                if (loc == null) {
                    log.warn("Asked to cleanup something[%s] that didn't exist.  Skipping.", new Object[]{segment.getId()});
                    return;
                }
                for (StorageLocation location : this.locations) {
                    File localStorageDir = new File(location.getPath(), DataSegmentPusher.getDefaultStorageDir((DataSegment)segment, (boolean)false));
                    if (!localStorageDir.exists()) continue;
                    this.cleanupCacheFiles(location.getPath(), localStorageDir);
                    location.removeSegmentDir(localStorageDir, segment);
                }
            }
            finally {
                this.unlock(segment, lock);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanupCacheFiles(File baseFile, File cacheFile) {
        File[] children;
        if (cacheFile.equals(baseFile)) {
            return;
        }
        Object object = this.directoryWriteRemoveLock;
        synchronized (object) {
            log.info("Deleting directory[%s]", new Object[]{cacheFile});
            try {
                FileUtils.deleteDirectory((File)cacheFile);
            }
            catch (Exception e) {
                log.error((Throwable)e, "Unable to remove directory[%s]", new Object[]{cacheFile});
            }
        }
        File parent = cacheFile.getParentFile();
        if (parent != null && ((children = parent.listFiles()) == null || children.length == 0)) {
            this.cleanupCacheFiles(baseFile, parent);
        }
    }

    private ReferenceCountingLock createOrGetLock(DataSegment dataSegment) {
        return this.segmentLocks.compute(dataSegment, (segment, lock) -> {
            ReferenceCountingLock nonNullLock = lock == null ? new ReferenceCountingLock() : lock;
            nonNullLock.increment();
            return nonNullLock;
        });
    }

    private void unlock(DataSegment dataSegment, ReferenceCountingLock lock) {
        this.segmentLocks.compute(dataSegment, (segment, existingLock) -> {
            if (existingLock == null) {
                throw new ISE("WTH? the given lock has already been removed", new Object[0]);
            }
            if (existingLock != lock) {
                throw new ISE("WTH? Different lock instance", new Object[0]);
            }
            if (((ReferenceCountingLock)existingLock).numReferences == 1) {
                return null;
            }
            ((ReferenceCountingLock)existingLock).decrement();
            return existingLock;
        });
    }

    @VisibleForTesting
    public ConcurrentHashMap<DataSegment, ReferenceCountingLock> getSegmentLocks() {
        return this.segmentLocks;
    }

    @VisibleForTesting
    public List<StorageLocation> getLocations() {
        return this.locations;
    }

    @VisibleForTesting
    private static class ReferenceCountingLock {
        private int numReferences;

        private ReferenceCountingLock() {
        }

        private void increment() {
            ++this.numReferences;
        }

        private void decrement() {
            --this.numReferences;
        }
    }
}

