/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.realtime.appenderator;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Supplier;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.druid.data.input.Committer;
import org.apache.druid.data.input.InputRow;
import org.apache.druid.java.util.common.parsers.ParseException;
import org.apache.druid.query.QuerySegmentWalker;
import org.apache.druid.segment.incremental.IndexSizeExceededException;
import org.apache.druid.segment.realtime.appenderator.SegmentIdWithShardSpec;
import org.apache.druid.segment.realtime.appenderator.SegmentNotWritableException;
import org.apache.druid.segment.realtime.appenderator.SegmentsAndCommitMetadata;

public interface Appenderator
extends QuerySegmentWalker {
    public String getId();

    public String getDataSource();

    public Object startJob();

    default public AppenderatorAddResult add(SegmentIdWithShardSpec identifier, InputRow row, Supplier<Committer> committerSupplier) throws IndexSizeExceededException, SegmentNotWritableException {
        return this.add(identifier, row, committerSupplier, true);
    }

    public AppenderatorAddResult add(SegmentIdWithShardSpec var1, InputRow var2, @Nullable Supplier<Committer> var3, boolean var4) throws IndexSizeExceededException, SegmentNotWritableException;

    public List<SegmentIdWithShardSpec> getSegments();

    @VisibleForTesting
    public int getRowCount(SegmentIdWithShardSpec var1);

    public int getTotalRowCount();

    @VisibleForTesting
    public void clear() throws InterruptedException;

    public ListenableFuture<?> drop(SegmentIdWithShardSpec var1);

    public ListenableFuture<Object> persistAll(@Nullable Committer var1);

    public ListenableFuture<SegmentsAndCommitMetadata> push(Collection<SegmentIdWithShardSpec> var1, @Nullable Committer var2, boolean var3);

    public void close();

    public void closeNow();

    public static class AppenderatorAddResult {
        private final SegmentIdWithShardSpec segmentIdentifier;
        private final int numRowsInSegment;
        private final boolean isPersistRequired;
        @Nullable
        private final ParseException parseException;

        AppenderatorAddResult(SegmentIdWithShardSpec identifier, int numRowsInSegment, boolean isPersistRequired, @Nullable ParseException parseException) {
            this.segmentIdentifier = identifier;
            this.numRowsInSegment = numRowsInSegment;
            this.isPersistRequired = isPersistRequired;
            this.parseException = parseException;
        }

        SegmentIdWithShardSpec getSegmentIdentifier() {
            return this.segmentIdentifier;
        }

        int getNumRowsInSegment() {
            return this.numRowsInSegment;
        }

        boolean isPersistRequired() {
            return this.isPersistRequired;
        }

        @Nullable
        public ParseException getParseException() {
            return this.parseException;
        }
    }
}

