/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.realtime.appenderator;

import com.google.common.collect.ImmutableList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.druid.segment.SegmentUtils;
import org.apache.druid.timeline.DataSegment;

public class SegmentsAndCommitMetadata {
    private static final SegmentsAndCommitMetadata NIL = new SegmentsAndCommitMetadata(Collections.emptyList(), null);
    private final Object commitMetadata;
    private final ImmutableList<DataSegment> segments;

    public SegmentsAndCommitMetadata(List<DataSegment> segments, @Nullable Object commitMetadata) {
        this.segments = ImmutableList.copyOf(segments);
        this.commitMetadata = commitMetadata;
    }

    @Nullable
    public Object getCommitMetadata() {
        return this.commitMetadata;
    }

    public List<DataSegment> getSegments() {
        return this.segments;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SegmentsAndCommitMetadata that = (SegmentsAndCommitMetadata)o;
        return Objects.equals(this.commitMetadata, that.commitMetadata) && Objects.equals(this.segments, that.segments);
    }

    public int hashCode() {
        return Objects.hash(this.commitMetadata, this.segments);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{commitMetadata=" + this.commitMetadata + ", segments=" + SegmentUtils.commaSeparatedIdentifiers(this.segments) + '}';
    }

    public static SegmentsAndCommitMetadata nil() {
        return NIL;
    }
}

