/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.realtime.firehose;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import java.util.Objects;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.apache.druid.data.input.FiniteFirehoseFactory;
import org.apache.druid.data.input.Firehose;
import org.apache.druid.data.input.InputSplit;
import org.apache.druid.data.input.SplitHintSpec;
import org.apache.druid.data.input.impl.StringInputRowParser;
import org.apache.druid.segment.realtime.firehose.InlineFirehose;

public class InlineFirehoseFactory
implements FiniteFirehoseFactory<StringInputRowParser, String> {
    private final String data;

    @JsonCreator
    @VisibleForTesting
    public InlineFirehoseFactory(@JsonProperty(value="data") String data) {
        this.data = (String)Preconditions.checkNotNull((Object)data, (Object)"data");
    }

    @JsonProperty
    public String getData() {
        return this.data;
    }

    public Firehose connect(StringInputRowParser parser, @Nullable File temporaryDirectory) throws IOException {
        return new InlineFirehose(this.data, parser);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InlineFirehoseFactory factory = (InlineFirehoseFactory)o;
        return this.data.equals(factory.data);
    }

    public int hashCode() {
        return Objects.hash(this.data);
    }

    public boolean isSplittable() {
        return false;
    }

    public Stream<InputSplit<String>> getSplits(@Nullable SplitHintSpec splitHintSpec) {
        return Stream.of(new InputSplit((Object)this.data));
    }

    public int getNumSplits(@Nullable SplitHintSpec splitHintSpec) {
        return 1;
    }

    public FiniteFirehoseFactory<StringInputRowParser, String> withSplit(InputSplit<String> split) {
        return new InlineFirehoseFactory((String)split.get());
    }
}

