/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server;

import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.datatype.joda.ser.DateTimeSerializer;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.Nullable;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.druid.guice.LazySingleton;
import org.apache.druid.guice.annotations.Json;
import org.apache.druid.guice.annotations.Self;
import org.apache.druid.guice.annotations.Smile;
import org.apache.druid.java.util.emitter.EmittingLogger;
import org.apache.druid.query.Query;
import org.apache.druid.query.QueryInterruptedException;
import org.apache.druid.query.QueryToolChest;
import org.apache.druid.query.QueryUnsupportedException;
import org.apache.druid.server.DruidNode;
import org.apache.druid.server.QueryCapacityExceededException;
import org.apache.druid.server.QueryLifecycleFactory;
import org.apache.druid.server.QueryScheduler;
import org.apache.druid.server.ResponseContextConfig;
import org.apache.druid.server.metrics.QueryCountStatsProvider;
import org.apache.druid.server.security.Access;
import org.apache.druid.server.security.AuthConfig;
import org.apache.druid.server.security.AuthorizationUtils;
import org.apache.druid.server.security.AuthorizerMapper;
import org.apache.druid.server.security.ForbiddenException;
import org.apache.druid.server.security.ResourceAction;
import org.joda.time.DateTime;

@LazySingleton
@Path(value="/druid/v2/")
public class QueryResource
implements QueryCountStatsProvider {
    protected static final EmittingLogger log = new EmittingLogger(QueryResource.class);
    @Deprecated
    protected static final String APPLICATION_SMILE = "application/smile";
    public static final String HEADER_RESPONSE_CONTEXT = "X-Druid-Response-Context";
    public static final String HEADER_IF_NONE_MATCH = "If-None-Match";
    public static final String HEADER_ETAG = "ETag";
    protected final QueryLifecycleFactory queryLifecycleFactory;
    protected final ObjectMapper jsonMapper;
    protected final ObjectMapper smileMapper;
    protected final ObjectMapper serializeDateTimeAsLongJsonMapper;
    protected final ObjectMapper serializeDateTimeAsLongSmileMapper;
    protected final QueryScheduler queryScheduler;
    protected final AuthConfig authConfig;
    protected final AuthorizerMapper authorizerMapper;
    private final ResponseContextConfig responseContextConfig;
    private final DruidNode selfNode;
    private final AtomicLong successfulQueryCount = new AtomicLong();
    private final AtomicLong failedQueryCount = new AtomicLong();
    private final AtomicLong interruptedQueryCount = new AtomicLong();

    @Inject
    public QueryResource(QueryLifecycleFactory queryLifecycleFactory, @Json ObjectMapper jsonMapper, @Smile ObjectMapper smileMapper, QueryScheduler queryScheduler, AuthConfig authConfig, AuthorizerMapper authorizerMapper, ResponseContextConfig responseContextConfig, @Self DruidNode selfNode) {
        this.queryLifecycleFactory = queryLifecycleFactory;
        this.jsonMapper = jsonMapper;
        this.smileMapper = smileMapper;
        this.serializeDateTimeAsLongJsonMapper = this.serializeDataTimeAsLong(jsonMapper);
        this.serializeDateTimeAsLongSmileMapper = this.serializeDataTimeAsLong(smileMapper);
        this.queryScheduler = queryScheduler;
        this.authConfig = authConfig;
        this.authorizerMapper = authorizerMapper;
        this.responseContextConfig = responseContextConfig;
        this.selfNode = selfNode;
    }

    @DELETE
    @Path(value="{id}")
    @Produces(value={"application/json"})
    public Response cancelQuery(@PathParam(value="id") String queryId, @Context HttpServletRequest req) {
        Access authResult;
        Set<String> datasources;
        if (log.isDebugEnabled()) {
            log.debug("Received cancel request for query [%s]", new Object[]{queryId});
        }
        if ((datasources = this.queryScheduler.getQueryDatasources(queryId)) == null) {
            log.warn("QueryId [%s] not registered with QueryScheduler, cannot cancel", new Object[]{queryId});
            datasources = new TreeSet<String>();
        }
        if (!(authResult = AuthorizationUtils.authorizeAllResourceActions(req, (Iterable<ResourceAction>)Iterables.transform(datasources, AuthorizationUtils.DATASOURCE_WRITE_RA_GENERATOR), this.authorizerMapper)).isAllowed()) {
            throw new ForbiddenException(authResult.toString());
        }
        this.queryScheduler.cancelQuery(queryId);
        return Response.status((Response.Status)Response.Status.ACCEPTED).build();
    }

    /*
     * Exception decompiling
     */
    @POST
    @Produces(value={"application/json", "application/x-jackson-smile"})
    @Consumes(value={"application/json", "application/x-jackson-smile", "application/smile"})
    public Response doPost(InputStream in, @QueryParam(value="pretty") String pretty, @Context HttpServletRequest req) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [9[CATCHBLOCK]], but top level block is 5[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private Query<?> readQuery(HttpServletRequest req, InputStream in, ResourceIOReaderWriter ioReaderWriter) throws IOException {
        Query baseQuery = (Query)ioReaderWriter.getInputMapper().readValue(in, Query.class);
        String prevEtag = QueryResource.getPreviousEtag(req);
        if (prevEtag != null) {
            baseQuery = baseQuery.withOverriddenContext((Map)ImmutableMap.of((Object)HEADER_IF_NONE_MATCH, (Object)prevEtag));
        }
        return baseQuery;
    }

    private static String getPreviousEtag(HttpServletRequest req) {
        return req.getHeader(HEADER_IF_NONE_MATCH);
    }

    protected ObjectMapper serializeDataTimeAsLong(ObjectMapper mapper) {
        return mapper.copy().registerModule((Module)new SimpleModule().addSerializer(DateTime.class, (JsonSerializer)new DateTimeSerializer()));
    }

    protected ResourceIOReaderWriter createResourceIOReaderWriter(String requestType, boolean pretty) {
        boolean isSmile = "application/x-jackson-smile".equals(requestType) || APPLICATION_SMILE.equals(requestType);
        String contentType = isSmile ? "application/x-jackson-smile" : "application/json";
        return new ResourceIOReaderWriter(contentType, isSmile ? this.smileMapper : this.jsonMapper, isSmile ? this.serializeDateTimeAsLongSmileMapper : this.serializeDateTimeAsLongJsonMapper, pretty);
    }

    @Override
    public long getSuccessfulQueryCount() {
        return this.successfulQueryCount.get();
    }

    @Override
    public long getFailedQueryCount() {
        return this.failedQueryCount.get();
    }

    @Override
    public long getInterruptedQueryCount() {
        return this.interruptedQueryCount.get();
    }

    protected static class ResourceIOReaderWriter {
        private final String contentType;
        private final ObjectMapper inputMapper;
        private final ObjectMapper serializeDateTimeAsLongInputMapper;
        private final boolean isPretty;

        ResourceIOReaderWriter(String contentType, ObjectMapper inputMapper, ObjectMapper serializeDateTimeAsLongInputMapper, boolean isPretty) {
            this.contentType = contentType;
            this.inputMapper = inputMapper;
            this.serializeDateTimeAsLongInputMapper = serializeDateTimeAsLongInputMapper;
            this.isPretty = isPretty;
        }

        String getContentType() {
            return this.contentType;
        }

        ObjectMapper getInputMapper() {
            return this.inputMapper;
        }

        ObjectWriter newOutputWriter(@Nullable QueryToolChest toolChest, @Nullable Query query, boolean serializeDateTimeAsLong) {
            ObjectMapper mapper = serializeDateTimeAsLong ? this.serializeDateTimeAsLongInputMapper : this.inputMapper;
            ObjectMapper decoratedMapper = toolChest != null ? toolChest.decorateObjectMapper(mapper, (Query)Preconditions.checkNotNull((Object)query, (Object)"query")) : mapper;
            return this.isPretty ? decoratedMapper.writerWithDefaultPrettyPrinter() : decoratedMapper.writer();
        }

        Response ok(Object object) throws IOException {
            return Response.ok((Object)this.newOutputWriter(null, null, false).writeValueAsString(object), (String)this.contentType).build();
        }

        Response gotError(Exception e) throws IOException {
            return Response.serverError().type(this.contentType).entity((Object)this.newOutputWriter(null, null, false).writeValueAsBytes((Object)QueryInterruptedException.wrapIfNeeded((Throwable)e))).build();
        }

        Response gotLimited(QueryCapacityExceededException e) throws IOException {
            return Response.status((int)429).entity((Object)this.newOutputWriter(null, null, false).writeValueAsBytes((Object)e)).build();
        }

        Response gotUnsupported(QueryUnsupportedException e) throws IOException {
            return Response.status((int)400).entity((Object)this.newOutputWriter(null, null, false).writeValueAsBytes((Object)e)).build();
        }
    }
}

