/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.coordination;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import org.apache.druid.java.util.common.StringUtils;

public enum ServerType {
    HISTORICAL,
    BRIDGE,
    INDEXER_EXECUTOR{

        @Override
        public boolean isSegmentReplicationTarget() {
            return false;
        }
    }
    ,
    REALTIME{

        @Override
        public boolean isSegmentReplicationTarget() {
            return false;
        }
    }
    ,
    BROKER{

        @Override
        public boolean isSegmentReplicationTarget() {
            return false;
        }
    };


    public boolean isSegmentReplicationTarget() {
        return true;
    }

    public boolean isSegmentBroadcastTarget() {
        return true;
    }

    @JsonCreator
    public static ServerType fromString(String type) {
        return ServerType.valueOf(StringUtils.toUpperCase((String)type).replace('-', '_'));
    }

    @JsonValue
    public String toString() {
        return StringUtils.toLowerCase((String)this.name()).replace('_', '-');
    }
}

