/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.coordinator;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Ordering;
import com.google.common.collect.Sets;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.inject.Inject;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntMaps;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2LongMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.utils.ZKPaths;
import org.apache.druid.client.DataSourcesSnapshot;
import org.apache.druid.client.DruidDataSource;
import org.apache.druid.client.DruidServer;
import org.apache.druid.client.ImmutableDruidDataSource;
import org.apache.druid.client.ImmutableDruidServer;
import org.apache.druid.client.ServerInventoryView;
import org.apache.druid.client.coordinator.Coordinator;
import org.apache.druid.client.indexing.IndexingServiceClient;
import org.apache.druid.common.config.JacksonConfigManager;
import org.apache.druid.curator.discovery.ServiceAnnouncer;
import org.apache.druid.discovery.DruidLeaderSelector;
import org.apache.druid.guice.ManageLifecycle;
import org.apache.druid.guice.annotations.CoordinatorIndexingServiceDuty;
import org.apache.druid.guice.annotations.Self;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.Pair;
import org.apache.druid.java.util.common.concurrent.Execs;
import org.apache.druid.java.util.common.concurrent.ScheduledExecutorFactory;
import org.apache.druid.java.util.common.concurrent.ScheduledExecutors;
import org.apache.druid.java.util.common.guava.Comparators;
import org.apache.druid.java.util.common.lifecycle.LifecycleStart;
import org.apache.druid.java.util.common.lifecycle.LifecycleStop;
import org.apache.druid.java.util.emitter.EmittingLogger;
import org.apache.druid.java.util.emitter.service.ServiceEmitter;
import org.apache.druid.metadata.MetadataRuleManager;
import org.apache.druid.metadata.SegmentsMetadataManager;
import org.apache.druid.server.DruidNode;
import org.apache.druid.server.coordinator.BalancerStrategy;
import org.apache.druid.server.coordinator.BalancerStrategyFactory;
import org.apache.druid.server.coordinator.CoordinatorCompactionConfig;
import org.apache.druid.server.coordinator.CoordinatorDynamicConfig;
import org.apache.druid.server.coordinator.DruidCluster;
import org.apache.druid.server.coordinator.DruidCoordinatorConfig;
import org.apache.druid.server.coordinator.DruidCoordinatorRuntimeParams;
import org.apache.druid.server.coordinator.LoadPeonCallback;
import org.apache.druid.server.coordinator.LoadQueuePeon;
import org.apache.druid.server.coordinator.LoadQueueTaskMaster;
import org.apache.druid.server.coordinator.SegmentReplicantLookup;
import org.apache.druid.server.coordinator.ServerHolder;
import org.apache.druid.server.coordinator.duty.BalanceSegments;
import org.apache.druid.server.coordinator.duty.CompactSegments;
import org.apache.druid.server.coordinator.duty.CoordinatorDuty;
import org.apache.druid.server.coordinator.duty.EmitClusterStatsAndMetrics;
import org.apache.druid.server.coordinator.duty.LogUsedSegments;
import org.apache.druid.server.coordinator.duty.MarkAsUnusedOvershadowedSegments;
import org.apache.druid.server.coordinator.duty.RunRules;
import org.apache.druid.server.coordinator.duty.UnloadUnusedSegments;
import org.apache.druid.server.coordinator.rules.Rule;
import org.apache.druid.server.initialization.ZkPathsConfig;
import org.apache.druid.server.lookup.cache.LookupCoordinatorManager;
import org.apache.druid.timeline.DataSegment;
import org.apache.druid.timeline.SegmentId;
import org.joda.time.DateTime;
import org.joda.time.Duration;

@ManageLifecycle
public class DruidCoordinator {
    static final Comparator<DataSegment> SEGMENT_COMPARATOR_RECENT_FIRST = Ordering.from((Comparator)Comparators.intervalsByEndThenStart()).onResultOf(DataSegment::getInterval).compound((Comparator)Ordering.natural()).reverse();
    private static final EmittingLogger log = new EmittingLogger(DruidCoordinator.class);
    private final Object lock = new Object();
    private final DruidCoordinatorConfig config;
    private final ZkPathsConfig zkPaths;
    private final JacksonConfigManager configManager;
    private final SegmentsMetadataManager segmentsMetadataManager;
    private final ServerInventoryView serverInventoryView;
    private final MetadataRuleManager metadataRuleManager;
    private final CuratorFramework curator;
    private final ServiceEmitter emitter;
    private final IndexingServiceClient indexingServiceClient;
    private final ScheduledExecutorService exec;
    private final LoadQueueTaskMaster taskMaster;
    private final Map<String, LoadQueuePeon> loadManagementPeons;
    private final ServiceAnnouncer serviceAnnouncer;
    private final DruidNode self;
    private final Set<CoordinatorDuty> indexingServiceDuties;
    private final BalancerStrategyFactory factory;
    private final LookupCoordinatorManager lookupCoordinatorManager;
    private final DruidLeaderSelector coordLeaderSelector;
    private final CompactSegments compactSegments;
    private volatile boolean started = false;
    private volatile SegmentReplicantLookup segmentReplicantLookup = null;

    @Inject
    public DruidCoordinator(DruidCoordinatorConfig config, ZkPathsConfig zkPaths, JacksonConfigManager configManager, SegmentsMetadataManager segmentsMetadataManager, ServerInventoryView serverInventoryView, MetadataRuleManager metadataRuleManager, CuratorFramework curator, ServiceEmitter emitter, ScheduledExecutorFactory scheduledExecutorFactory, IndexingServiceClient indexingServiceClient, LoadQueueTaskMaster taskMaster, ServiceAnnouncer serviceAnnouncer, @Self DruidNode self, @CoordinatorIndexingServiceDuty Set<CoordinatorDuty> indexingServiceDuties, BalancerStrategyFactory factory, LookupCoordinatorManager lookupCoordinatorManager, @Coordinator DruidLeaderSelector coordLeaderSelector, CompactSegments compactSegments) {
        this(config, zkPaths, configManager, segmentsMetadataManager, serverInventoryView, metadataRuleManager, curator, emitter, scheduledExecutorFactory, indexingServiceClient, taskMaster, serviceAnnouncer, self, new ConcurrentHashMap<String, LoadQueuePeon>(), indexingServiceDuties, factory, lookupCoordinatorManager, coordLeaderSelector, compactSegments);
    }

    DruidCoordinator(DruidCoordinatorConfig config, ZkPathsConfig zkPaths, JacksonConfigManager configManager, SegmentsMetadataManager segmentsMetadataManager, ServerInventoryView serverInventoryView, MetadataRuleManager metadataRuleManager, CuratorFramework curator, ServiceEmitter emitter, ScheduledExecutorFactory scheduledExecutorFactory, IndexingServiceClient indexingServiceClient, LoadQueueTaskMaster taskMaster, ServiceAnnouncer serviceAnnouncer, DruidNode self, ConcurrentMap<String, LoadQueuePeon> loadQueuePeonMap, Set<CoordinatorDuty> indexingServiceDuties, BalancerStrategyFactory factory, LookupCoordinatorManager lookupCoordinatorManager, DruidLeaderSelector coordLeaderSelector, CompactSegments compactSegments) {
        this.config = config;
        this.zkPaths = zkPaths;
        this.configManager = configManager;
        this.segmentsMetadataManager = segmentsMetadataManager;
        this.serverInventoryView = serverInventoryView;
        this.metadataRuleManager = metadataRuleManager;
        this.curator = curator;
        this.emitter = emitter;
        this.indexingServiceClient = indexingServiceClient;
        this.taskMaster = taskMaster;
        this.serviceAnnouncer = serviceAnnouncer;
        this.self = self;
        this.indexingServiceDuties = indexingServiceDuties;
        this.exec = scheduledExecutorFactory.create(1, "Coordinator-Exec--%d");
        this.loadManagementPeons = loadQueuePeonMap;
        this.factory = factory;
        this.lookupCoordinatorManager = lookupCoordinatorManager;
        this.coordLeaderSelector = coordLeaderSelector;
        this.compactSegments = compactSegments;
    }

    public boolean isLeader() {
        return this.coordLeaderSelector.isLeader();
    }

    public Map<String, LoadQueuePeon> getLoadManagementPeons() {
        return this.loadManagementPeons;
    }

    public Map<String, Object2LongMap<String>> computeUnderReplicationCountsPerDataSourcePerTier() {
        Iterable<DataSegment> dataSegments = this.segmentsMetadataManager.iterateAllUsedSegments();
        return this.computeUnderReplicationCountsPerDataSourcePerTierForSegments(dataSegments);
    }

    public Map<String, Object2LongMap<String>> computeUnderReplicationCountsPerDataSourcePerTierForSegments(Iterable<DataSegment> dataSegments) {
        HashMap<String, Object2LongMap<String>> underReplicationCountsPerDataSourcePerTier = new HashMap<String, Object2LongMap<String>>();
        if (this.segmentReplicantLookup == null) {
            return underReplicationCountsPerDataSourcePerTier;
        }
        DateTime now = DateTimes.nowUtc();
        block0: for (DataSegment segment : dataSegments) {
            List<Rule> rules = this.metadataRuleManager.getRulesWithDefault(segment.getDataSource());
            for (Rule rule : rules) {
                if (!rule.appliesTo(segment, now)) continue;
                if (!rule.canLoadSegments()) continue block0;
                rule.updateUnderReplicated(underReplicationCountsPerDataSourcePerTier, this.segmentReplicantLookup, segment);
                continue block0;
            }
        }
        return underReplicationCountsPerDataSourcePerTier;
    }

    public Object2IntMap<String> computeNumsUnavailableUsedSegmentsPerDataSource() {
        if (this.segmentReplicantLookup == null) {
            return Object2IntMaps.emptyMap();
        }
        Object2IntOpenHashMap numsUnavailableUsedSegmentsPerDataSource = new Object2IntOpenHashMap();
        Iterable<DataSegment> dataSegments = this.segmentsMetadataManager.iterateAllUsedSegments();
        for (DataSegment segment : dataSegments) {
            if (this.segmentReplicantLookup.getLoadedReplicants(segment.getId()) == 0) {
                numsUnavailableUsedSegmentsPerDataSource.addTo((Object)segment.getDataSource(), 1);
                continue;
            }
            numsUnavailableUsedSegmentsPerDataSource.addTo((Object)segment.getDataSource(), 0);
        }
        return numsUnavailableUsedSegmentsPerDataSource;
    }

    public Map<String, Double> getLoadStatus() {
        HashMap<String, Double> loadStatus = new HashMap<String, Double>();
        Collection<ImmutableDruidDataSource> dataSources = this.segmentsMetadataManager.getImmutableDataSourcesWithAllUsedSegments();
        for (ImmutableDruidDataSource dataSource : dataSources) {
            HashSet segments = Sets.newHashSet(dataSource.getSegments());
            int numPublishedSegments = segments.size();
            for (DruidServer druidServer : this.serverInventoryView.getInventory()) {
                DruidDataSource loadedView = druidServer.getDataSource(dataSource.getName());
                if (loadedView == null) continue;
                for (DataSegment serverSegment : loadedView.getSegments()) {
                    segments.remove(serverSegment);
                }
            }
            int numUnavailableSegments = segments.size();
            loadStatus.put(dataSource.getName(), 100.0 * ((double)(numPublishedSegments - numUnavailableSegments) / (double)numPublishedSegments));
        }
        return loadStatus;
    }

    @Nullable
    public Long getTotalSizeOfSegmentsAwaitingCompaction(String dataSource) {
        return this.compactSegments.getTotalSizeOfSegmentsAwaitingCompaction(dataSource);
    }

    public CoordinatorDynamicConfig getDynamicConfigs() {
        return CoordinatorDynamicConfig.current(this.configManager);
    }

    public CoordinatorCompactionConfig getCompactionConfig() {
        return CoordinatorCompactionConfig.current(this.configManager);
    }

    public void markSegmentAsUnused(DataSegment segment) {
        log.debug("Marking segment[%s] as unused", new Object[]{segment.getId()});
        this.segmentsMetadataManager.markSegmentAsUnused(segment.getId().toString());
    }

    public String getCurrentLeader() {
        return this.coordLeaderSelector.getCurrentLeader();
    }

    public void moveSegment(DruidCoordinatorRuntimeParams params, ImmutableDruidServer fromServer, ImmutableDruidServer toServer, DataSegment segment, LoadPeonCallback callback) {
        block12: {
            if (segment == null) {
                log.makeAlert((Throwable)new IAE("Can not move null DataSegment", new Object[0]), "Exception moving null segment", new Object[0]).emit();
                if (callback != null) {
                    callback.execute();
                }
                throw new ISE("Cannot move null DataSegment", new Object[0]);
            }
            SegmentId segmentId = segment.getId();
            try {
                if (fromServer.getMetadata().equals(toServer.getMetadata())) {
                    throw new IAE("Cannot move [%s] to and from the same server [%s]", new Object[]{segmentId, fromServer.getName()});
                }
                ImmutableDruidDataSource dataSource = params.getDataSourcesSnapshot().getDataSource(segment.getDataSource());
                if (dataSource == null) {
                    throw new IAE("Unable to find dataSource for segment [%s] in metadata", new Object[]{segmentId});
                }
                DataSegment segmentToLoad = dataSource.getSegment(segment.getId());
                if (segmentToLoad == null) {
                    throw new IAE("No segment metadata found for segment Id [%s]", new Object[]{segment.getId()});
                }
                LoadQueuePeon loadPeon = this.loadManagementPeons.get(toServer.getName());
                if (loadPeon == null) {
                    throw new IAE("LoadQueuePeon hasn't been created yet for path [%s]", new Object[]{toServer.getName()});
                }
                LoadQueuePeon dropPeon = this.loadManagementPeons.get(fromServer.getName());
                if (dropPeon == null) {
                    throw new IAE("LoadQueuePeon hasn't been created yet for path [%s]", new Object[]{fromServer.getName()});
                }
                ServerHolder toHolder = new ServerHolder(toServer, loadPeon);
                if (toHolder.getAvailableSize() < segmentToLoad.getSize()) {
                    throw new IAE("Not enough capacity on server [%s] for segment [%s]. Required: %,d, available: %,d.", new Object[]{toServer.getName(), segmentToLoad, segmentToLoad.getSize(), toHolder.getAvailableSize()});
                }
                String toLoadQueueSegPath = ZKPaths.makePath((String)this.zkPaths.getLoadQueuePath(), (String)toServer.getName(), (String[])new String[]{segmentId.toString()});
                LoadPeonCallback loadPeonCallback = () -> {
                    dropPeon.unmarkSegmentToDrop(segmentToLoad);
                    if (callback != null) {
                        callback.execute();
                    }
                };
                dropPeon.markSegmentToDrop(segmentToLoad);
                try {
                    loadPeon.loadSegment(segmentToLoad, () -> {
                        try {
                            if (this.serverInventoryView.isSegmentLoadedByServer(toServer.getName(), segment) && this.curator.checkExists().forPath(toLoadQueueSegPath) == null && !dropPeon.getSegmentsToDrop().contains(segment)) {
                                dropPeon.dropSegment(segment, loadPeonCallback);
                            } else {
                                loadPeonCallback.execute();
                            }
                        }
                        catch (Exception e) {
                            throw new RuntimeException(e);
                        }
                    });
                }
                catch (Exception e) {
                    dropPeon.unmarkSegmentToDrop(segmentToLoad);
                    throw new RuntimeException(e);
                }
            }
            catch (Exception e) {
                log.makeAlert((Throwable)e, "Exception moving segment %s", new Object[]{segmentId}).emit();
                if (callback == null) break block12;
                callback.execute();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @LifecycleStart
    public void start() {
        Object object = this.lock;
        synchronized (object) {
            if (this.started) {
                return;
            }
            this.started = true;
            this.coordLeaderSelector.registerListener(new DruidLeaderSelector.Listener(){

                @Override
                public void becomeLeader() {
                    DruidCoordinator.this.becomeLeader();
                }

                @Override
                public void stopBeingLeader() {
                    DruidCoordinator.this.stopBeingLeader();
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @LifecycleStop
    public void stop() {
        Object object = this.lock;
        synchronized (object) {
            if (!this.started) {
                return;
            }
            this.coordLeaderSelector.unregisterListener();
            this.started = false;
            this.exec.shutdownNow();
        }
    }

    public void runCompactSegmentsDuty() {
        int startingLeaderCounter = this.coordLeaderSelector.localTerm();
        DutiesRunnable compactSegmentsDuty = new DutiesRunnable(this.makeCompactSegmentsDuty(), startingLeaderCounter);
        compactSegmentsDuty.run();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void becomeLeader() {
        Object object = this.lock;
        synchronized (object) {
            if (!this.started) {
                return;
            }
            log.info("I am the leader of the coordinators, all must bow! Starting coordination in [%s].", new Object[]{this.config.getCoordinatorStartDelay()});
            this.segmentsMetadataManager.startPollingDatabasePeriodically();
            this.metadataRuleManager.start();
            this.lookupCoordinatorManager.start();
            this.serviceAnnouncer.announce(this.self);
            final int startingLeaderCounter = this.coordLeaderSelector.localTerm();
            ArrayList<Pair> dutiesRunnables = new ArrayList<Pair>();
            dutiesRunnables.add(Pair.of((Object)new DutiesRunnable(this.makeHistoricalManagementDuties(), startingLeaderCounter), (Object)this.config.getCoordinatorPeriod()));
            if (this.indexingServiceClient != null) {
                dutiesRunnables.add(Pair.of((Object)new DutiesRunnable(this.makeIndexingServiceDuties(), startingLeaderCounter), (Object)this.config.getCoordinatorIndexingPeriod()));
            }
            for (final Pair dutiesRunnable : dutiesRunnables) {
                ScheduledExecutors.scheduleWithFixedDelay((ScheduledExecutorService)this.exec, (Duration)this.config.getCoordinatorStartDelay(), (Duration)((Duration)dutiesRunnable.rhs), (Callable)new Callable<ScheduledExecutors.Signal>(){
                    private final DutiesRunnable theRunnable;
                    {
                        this.theRunnable = (DutiesRunnable)dutiesRunnable.lhs;
                    }

                    @Override
                    public ScheduledExecutors.Signal call() {
                        if (DruidCoordinator.this.coordLeaderSelector.isLeader() && startingLeaderCounter == DruidCoordinator.this.coordLeaderSelector.localTerm()) {
                            this.theRunnable.run();
                        }
                        if (DruidCoordinator.this.coordLeaderSelector.isLeader() && startingLeaderCounter == DruidCoordinator.this.coordLeaderSelector.localTerm()) {
                            return ScheduledExecutors.Signal.REPEAT;
                        }
                        return ScheduledExecutors.Signal.STOP;
                    }
                });
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopBeingLeader() {
        Object object = this.lock;
        synchronized (object) {
            log.info("I am no longer the leader...", new Object[0]);
            for (String server : this.loadManagementPeons.keySet()) {
                LoadQueuePeon peon = this.loadManagementPeons.remove(server);
                peon.stop();
            }
            this.loadManagementPeons.clear();
            this.serviceAnnouncer.unannounce(this.self);
            this.lookupCoordinatorManager.stop();
            this.metadataRuleManager.stop();
            this.segmentsMetadataManager.stopPollingDatabasePeriodically();
        }
    }

    private List<CoordinatorDuty> makeHistoricalManagementDuties() {
        return ImmutableList.of((Object)new LogUsedSegments(), (Object)new UpdateCoordinatorStateAndPrepareCluster(), (Object)new RunRules(this), (Object)new UnloadUnusedSegments(), (Object)new MarkAsUnusedOvershadowedSegments(this), (Object)new BalanceSegments(this), (Object)new EmitClusterStatsAndMetrics(this));
    }

    private List<CoordinatorDuty> makeIndexingServiceDuties() {
        ArrayList<CoordinatorDuty> duties = new ArrayList<CoordinatorDuty>();
        duties.add(new LogUsedSegments());
        duties.addAll(this.makeCompactSegmentsDuty());
        duties.addAll(this.indexingServiceDuties);
        log.debug("Done making indexing service duties %s", new Object[]{duties.stream().map(duty -> duty.getClass().getName()).collect(Collectors.toList())});
        return ImmutableList.copyOf(duties);
    }

    private List<CoordinatorDuty> makeCompactSegmentsDuty() {
        return ImmutableList.of((Object)this.compactSegments);
    }

    private class UpdateCoordinatorStateAndPrepareCluster
    implements CoordinatorDuty {
        private UpdateCoordinatorStateAndPrepareCluster() {
        }

        @Override
        @Nullable
        public DruidCoordinatorRuntimeParams run(DruidCoordinatorRuntimeParams params) {
            List<ImmutableDruidServer> currentServers = this.prepareCurrentServers();
            this.startPeonsForNewServers(currentServers);
            DruidCluster cluster = this.prepareCluster(params, currentServers);
            DruidCoordinator.this.segmentReplicantLookup = SegmentReplicantLookup.make(cluster);
            this.stopPeonsForDisappearedServers(currentServers);
            return params.buildFromExisting().withDruidCluster(cluster).withLoadManagementPeons(DruidCoordinator.this.loadManagementPeons).withSegmentReplicantLookup(DruidCoordinator.this.segmentReplicantLookup).build();
        }

        List<ImmutableDruidServer> prepareCurrentServers() {
            List<ImmutableDruidServer> currentServers = DruidCoordinator.this.serverInventoryView.getInventory().stream().filter(DruidServer::isSegmentReplicationOrBroadcastTarget).map(DruidServer::toImmutableDruidServer).collect(Collectors.toList());
            if (log.isDebugEnabled()) {
                log.debug("Servers", new Object[0]);
                for (ImmutableDruidServer druidServer : currentServers) {
                    log.debug("  %s", new Object[]{druidServer});
                    log.debug("    -- DataSources", new Object[0]);
                    for (ImmutableDruidDataSource druidDataSource : druidServer.getDataSources()) {
                        log.debug("    %s", new Object[]{druidDataSource});
                    }
                }
            }
            return currentServers;
        }

        void startPeonsForNewServers(List<ImmutableDruidServer> currentServers) {
            for (ImmutableDruidServer server : currentServers) {
                DruidCoordinator.this.loadManagementPeons.computeIfAbsent(server.getName(), serverName -> {
                    LoadQueuePeon loadQueuePeon = DruidCoordinator.this.taskMaster.giveMePeon(server);
                    loadQueuePeon.start();
                    log.debug("Created LoadQueuePeon for server[%s].", new Object[]{server.getName()});
                    return loadQueuePeon;
                });
            }
        }

        DruidCluster prepareCluster(DruidCoordinatorRuntimeParams params, List<ImmutableDruidServer> currentServers) {
            Set<String> decommissioningServers = params.getCoordinatorDynamicConfig().getDecommissioningNodes();
            DruidCluster cluster = new DruidCluster();
            for (ImmutableDruidServer server : currentServers) {
                cluster.add(new ServerHolder(server, (LoadQueuePeon)DruidCoordinator.this.loadManagementPeons.get(server.getName()), decommissioningServers.contains(server.getHost())));
            }
            return cluster;
        }

        void stopPeonsForDisappearedServers(List<ImmutableDruidServer> servers) {
            HashSet disappeared = Sets.newHashSet(DruidCoordinator.this.loadManagementPeons.keySet());
            for (ImmutableDruidServer server : servers) {
                disappeared.remove(server.getName());
            }
            for (String name : disappeared) {
                log.debug("Removing listener for server[%s] which is no longer there.", new Object[]{name});
                LoadQueuePeon peon = (LoadQueuePeon)DruidCoordinator.this.loadManagementPeons.remove(name);
                peon.stop();
            }
        }
    }

    private class DutiesRunnable
    implements Runnable {
        private final long startTimeNanos = System.nanoTime();
        private final List<CoordinatorDuty> duties;
        private final int startingLeaderCounter;

        private DutiesRunnable(List<CoordinatorDuty> duties, int startingLeaderCounter) {
            this.duties = duties;
            this.startingLeaderCounter = startingLeaderCounter;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            ListeningExecutorService balancerExec = null;
            try {
                CoordinatorDuty duty;
                Object object = DruidCoordinator.this.lock;
                synchronized (object) {
                    if (!DruidCoordinator.this.coordLeaderSelector.isLeader()) {
                        log.info("LEGGO MY EGGO. [%s] is leader.", new Object[]{DruidCoordinator.this.coordLeaderSelector.getCurrentLeader()});
                        DruidCoordinator.this.stopBeingLeader();
                        return;
                    }
                }
                List<Boolean> allStarted = Arrays.asList(DruidCoordinator.this.segmentsMetadataManager.isPollingDatabasePeriodically(), DruidCoordinator.this.serverInventoryView.isStarted());
                for (Boolean aBoolean : allStarted) {
                    if (aBoolean.booleanValue()) continue;
                    log.error("InventoryManagers not started[%s]", new Object[]{allStarted});
                    DruidCoordinator.this.stopBeingLeader();
                    return;
                }
                balancerExec = MoreExecutors.listeningDecorator((ExecutorService)Execs.multiThreaded((int)DruidCoordinator.this.getDynamicConfigs().getBalancerComputeThreads(), (String)"coordinator-cost-balancer-%s"));
                BalancerStrategy balancerStrategy = DruidCoordinator.this.factory.createBalancerStrategy(balancerExec);
                DataSourcesSnapshot dataSourcesSnapshot = DruidCoordinator.this.segmentsMetadataManager.getSnapshotOfDataSourcesWithAllUsedSegments();
                DruidCoordinatorRuntimeParams params = DruidCoordinatorRuntimeParams.newBuilder().withDatabaseRuleManager(DruidCoordinator.this.metadataRuleManager).withStartTimeNanos(this.startTimeNanos).withSnapshotOfDataSourcesWithAllUsedSegments(dataSourcesSnapshot).withDynamicConfigs(DruidCoordinator.this.getDynamicConfigs()).withCompactionConfig(DruidCoordinator.this.getCompactionConfig()).withEmitter(DruidCoordinator.this.emitter).withBalancerStrategy(balancerStrategy).build();
                boolean coordinationPaused = DruidCoordinator.this.getDynamicConfigs().getPauseCoordination();
                if (coordinationPaused && DruidCoordinator.this.coordLeaderSelector.isLeader() && this.startingLeaderCounter == DruidCoordinator.this.coordLeaderSelector.localTerm()) {
                    log.debug("Coordination is paused via dynamic configs! I will not be running Coordination Duties at this time", new Object[0]);
                }
                Iterator<CoordinatorDuty> iterator = this.duties.iterator();
                do {
                    if (!iterator.hasNext()) return;
                    duty = iterator.next();
                } while (coordinationPaused || !DruidCoordinator.this.coordLeaderSelector.isLeader() || this.startingLeaderCounter != DruidCoordinator.this.coordLeaderSelector.localTerm() || (params = duty.run(params)) != null);
                return;
            }
            catch (Exception e) {
                log.makeAlert((Throwable)e, "Caught exception, ignoring so that schedule keeps going.", new Object[0]).emit();
                return;
            }
            finally {
                if (balancerExec != null) {
                    balancerExec.shutdownNow();
                }
            }
        }
    }
}

