/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.coordinator.duty;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.Maps;
import it.unimi.dsi.fastutil.objects.Object2LongOpenHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.PriorityQueue;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.druid.indexer.partitions.DynamicPartitionsSpec;
import org.apache.druid.indexer.partitions.PartitionsSpec;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.JodaUtils;
import org.apache.druid.java.util.common.guava.Comparators;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.segment.IndexSpec;
import org.apache.druid.segment.SegmentUtils;
import org.apache.druid.server.coordinator.DataSourceCompactionConfig;
import org.apache.druid.server.coordinator.duty.CompactionSegmentIterator;
import org.apache.druid.timeline.CompactionState;
import org.apache.druid.timeline.DataSegment;
import org.apache.druid.timeline.Partitions;
import org.apache.druid.timeline.TimelineObjectHolder;
import org.apache.druid.timeline.VersionedIntervalTimeline;
import org.apache.druid.timeline.partition.PartitionChunk;
import org.apache.druid.utils.Streams;
import org.joda.time.DateTime;
import org.joda.time.Interval;
import org.joda.time.Period;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadableInterval;
import org.joda.time.ReadablePeriod;

public class NewestSegmentFirstIterator
implements CompactionSegmentIterator {
    private static final Logger log = new Logger(NewestSegmentFirstIterator.class);
    private final ObjectMapper objectMapper;
    private final Map<String, DataSourceCompactionConfig> compactionConfigs;
    private final Map<String, VersionedIntervalTimeline<String, DataSegment>> dataSources;
    private final Map<String, CompactibleTimelineObjectHolderCursor> timelineIterators;
    private final PriorityQueue<QueueEntry> queue = new PriorityQueue((o1, o2) -> Comparators.intervalsByStartThenEnd().compare(((QueueEntry)o2).interval, ((QueueEntry)o1).interval));

    NewestSegmentFirstIterator(ObjectMapper objectMapper, Map<String, DataSourceCompactionConfig> compactionConfigs, Map<String, VersionedIntervalTimeline<String, DataSegment>> dataSources, Map<String, List<Interval>> skipIntervals) {
        this.objectMapper = objectMapper;
        this.compactionConfigs = compactionConfigs;
        this.dataSources = dataSources;
        this.timelineIterators = Maps.newHashMapWithExpectedSize((int)dataSources.size());
        dataSources.forEach((dataSource, timeline) -> {
            List<Interval> searchIntervals;
            DataSourceCompactionConfig config = (DataSourceCompactionConfig)compactionConfigs.get(dataSource);
            if (config != null && !timeline.isEmpty() && !(searchIntervals = NewestSegmentFirstIterator.findInitialSearchInterval((VersionedIntervalTimeline<String, DataSegment>)timeline, config.getSkipOffsetFromLatest(), (List)skipIntervals.get(dataSource))).isEmpty()) {
                this.timelineIterators.put((String)dataSource, new CompactibleTimelineObjectHolderCursor((VersionedIntervalTimeline<String, DataSegment>)timeline, searchIntervals));
            }
        });
        compactionConfigs.forEach((dataSourceName, config) -> {
            if (config == null) {
                throw new ISE("Unknown dataSource[%s]", new Object[]{dataSourceName});
            }
            this.updateQueue((String)dataSourceName, (DataSourceCompactionConfig)config);
        });
    }

    @Override
    public Object2LongOpenHashMap<String> totalRemainingSegmentsSizeBytes() {
        Object2LongOpenHashMap resultMap = new Object2LongOpenHashMap();
        resultMap.defaultReturnValue(-1L);
        for (QueueEntry entry : this.queue) {
            VersionedIntervalTimeline<String, DataSegment> timeline = this.dataSources.get(entry.getDataSource());
            Interval interval = new Interval((ReadableInstant)timeline.first().getInterval().getStart(), (ReadableInstant)entry.interval.getEnd());
            List holders = timeline.lookup(interval);
            long size = 0L;
            for (DataSegment segment : FluentIterable.from((Iterable)holders).transformAndConcat(TimelineObjectHolder::getObject).transform(PartitionChunk::getObject)) {
                size += segment.getSize();
            }
            resultMap.put((Object)entry.getDataSource(), size);
        }
        return resultMap;
    }

    @Override
    public boolean hasNext() {
        return !this.queue.isEmpty();
    }

    @Override
    public List<DataSegment> next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        QueueEntry entry = this.queue.poll();
        if (entry == null) {
            throw new NoSuchElementException();
        }
        List resultSegments = entry.segments;
        Preconditions.checkState((!resultSegments.isEmpty() ? 1 : 0) != 0, (Object)"Queue entry must not be empty");
        String dataSource = ((DataSegment)resultSegments.get(0)).getDataSource();
        this.updateQueue(dataSource, this.compactionConfigs.get(dataSource));
        return resultSegments;
    }

    private void updateQueue(String dataSourceName, DataSourceCompactionConfig config) {
        CompactibleTimelineObjectHolderCursor compactibleTimelineObjectHolderCursor = this.timelineIterators.get(dataSourceName);
        if (compactibleTimelineObjectHolderCursor == null) {
            log.warn("Cannot find timeline for dataSource[%s]. Skip this dataSource", new Object[]{dataSourceName});
            return;
        }
        SegmentsToCompact segmentsToCompact = this.findSegmentsToCompact(compactibleTimelineObjectHolderCursor, config);
        if (!segmentsToCompact.isEmpty()) {
            this.queue.add(new QueueEntry(segmentsToCompact.segments));
        }
    }

    private boolean needsCompaction(DataSourceCompactionConfig config, SegmentsToCompact candidates) {
        Preconditions.checkState((!candidates.isEmpty() ? 1 : 0) != 0, (Object)"Empty candidates");
        int maxRowsPerSegment = config.getMaxRowsPerSegment() == null ? 5000000 : config.getMaxRowsPerSegment();
        Long maxTotalRows = config.getTuningConfig() == null ? null : config.getTuningConfig().getMaxTotalRows();
        maxTotalRows = maxTotalRows == null ? Long.MAX_VALUE : maxTotalRows;
        CompactionState lastCompactionState = ((DataSegment)candidates.segments.get(0)).getLastCompactionState();
        if (lastCompactionState == null) {
            log.info("Candidate segment[%s] is not compacted yet. Needs compaction.", new Object[]{((DataSegment)candidates.segments.get(0)).getId()});
            return true;
        }
        boolean allCandidatesHaveSameLastCompactionState = candidates.segments.stream().allMatch(segment -> lastCompactionState.equals((Object)segment.getLastCompactionState()));
        if (!allCandidatesHaveSameLastCompactionState) {
            log.info("[%s] Candidate segments were compacted with different partitions spec. Needs compaction.", new Object[]{candidates.segments.size()});
            log.debugSegments((Collection)candidates.segments, "Candidate segments compacted with different partiton spec");
            return true;
        }
        PartitionsSpec segmentPartitionsSpec = lastCompactionState.getPartitionsSpec();
        if (!(segmentPartitionsSpec instanceof DynamicPartitionsSpec)) {
            log.info("Candidate segment[%s] was compacted with a non dynamic partitions spec. Needs compaction.", new Object[]{((DataSegment)candidates.segments.get(0)).getId()});
            return true;
        }
        DynamicPartitionsSpec dynamicPartitionsSpec = (DynamicPartitionsSpec)segmentPartitionsSpec;
        IndexSpec segmentIndexSpec = (IndexSpec)this.objectMapper.convertValue((Object)lastCompactionState.getIndexSpec(), IndexSpec.class);
        IndexSpec configuredIndexSpec = config.getTuningConfig() == null || config.getTuningConfig().getIndexSpec() == null ? new IndexSpec() : config.getTuningConfig().getIndexSpec();
        boolean needsCompaction = false;
        if (!Objects.equals(maxRowsPerSegment, dynamicPartitionsSpec.getMaxRowsPerSegment()) || !Objects.equals(maxTotalRows, dynamicPartitionsSpec.getMaxTotalRows())) {
            log.info("Configured maxRowsPerSegment[%s] and maxTotalRows[%s] are differenet from the partitionsSpec[%s] of segments. Needs compaction.", new Object[]{maxRowsPerSegment, maxTotalRows, dynamicPartitionsSpec});
            needsCompaction = true;
        }
        if (!segmentIndexSpec.equals((Object)configuredIndexSpec)) {
            log.info("Configured indexSpec[%s] is different from the one[%s] of segments. Needs compaction", new Object[]{configuredIndexSpec, segmentIndexSpec});
            needsCompaction = true;
        }
        return needsCompaction;
    }

    private SegmentsToCompact findSegmentsToCompact(CompactibleTimelineObjectHolderCursor compactibleTimelineObjectHolderCursor, DataSourceCompactionConfig config) {
        long inputSegmentSize = config.getInputSegmentSizeBytes();
        while (compactibleTimelineObjectHolderCursor.hasNext()) {
            SegmentsToCompact candidates = new SegmentsToCompact((List)compactibleTimelineObjectHolderCursor.next());
            if (!candidates.isEmpty()) {
                boolean isCompactibleSize = candidates.getTotalSize() <= inputSegmentSize;
                boolean needsCompaction = this.needsCompaction(config, candidates);
                if (isCompactibleSize && needsCompaction) {
                    return candidates;
                }
                if (isCompactibleSize) continue;
                log.warn("total segment size[%d] for datasource[%s] and interval[%s] is larger than inputSegmentSize[%d]. Continue to the next interval.", new Object[]{candidates.getTotalSize(), ((DataSegment)candidates.segments.get(0)).getDataSource(), ((DataSegment)candidates.segments.get(0)).getInterval(), inputSegmentSize});
                continue;
            }
            throw new ISE("No segment is found?", new Object[0]);
        }
        log.info("All segments look good! Nothing to compact", new Object[0]);
        return new SegmentsToCompact();
    }

    private static List<Interval> findInitialSearchInterval(VersionedIntervalTimeline<String, DataSegment> timeline, Period skipOffset, @Nullable List<Interval> skipIntervals) {
        Preconditions.checkArgument((timeline != null && !timeline.isEmpty() ? 1 : 0) != 0, (Object)"timeline should not be null or empty");
        Preconditions.checkNotNull((Object)skipOffset, (Object)"skipOffset");
        TimelineObjectHolder first = (TimelineObjectHolder)Preconditions.checkNotNull((Object)timeline.first(), (Object)"first");
        TimelineObjectHolder last = (TimelineObjectHolder)Preconditions.checkNotNull((Object)timeline.last(), (Object)"last");
        List<Interval> fullSkipIntervals = NewestSegmentFirstIterator.sortAndAddSkipIntervalFromLatest(last.getInterval().getEnd(), skipOffset, skipIntervals);
        Interval totalInterval = new Interval((ReadableInstant)first.getInterval().getStart(), (ReadableInstant)last.getInterval().getEnd());
        List<Interval> filteredInterval = NewestSegmentFirstIterator.filterSkipIntervals(totalInterval, fullSkipIntervals);
        ArrayList<Interval> searchIntervals = new ArrayList<Interval>();
        for (Interval lookupInterval : filteredInterval) {
            List segments = timeline.findNonOvershadowedObjectsInInterval(lookupInterval, Partitions.ONLY_COMPLETE).stream().filter(segment -> lookupInterval.contains((ReadableInterval)segment.getInterval())).collect(Collectors.toList());
            if (segments.isEmpty()) continue;
            DateTime searchStart = segments.stream().map(segment -> segment.getId().getIntervalStart()).min(Comparator.naturalOrder()).orElseThrow(AssertionError::new);
            DateTime searchEnd = segments.stream().map(segment -> segment.getId().getIntervalEnd()).max(Comparator.naturalOrder()).orElseThrow(AssertionError::new);
            searchIntervals.add(new Interval((ReadableInstant)searchStart, (ReadableInstant)searchEnd));
        }
        return searchIntervals;
    }

    @VisibleForTesting
    static List<Interval> sortAndAddSkipIntervalFromLatest(DateTime latest, Period skipOffset, @Nullable List<Interval> skipIntervals) {
        ArrayList<Interval> nonNullSkipIntervals;
        ArrayList<Object> arrayList = nonNullSkipIntervals = skipIntervals == null ? new ArrayList<Interval>(1) : new ArrayList(skipIntervals.size());
        if (skipIntervals != null) {
            ArrayList<Interval> sortedSkipIntervals = new ArrayList<Interval>(skipIntervals);
            sortedSkipIntervals.sort(Comparators.intervalsByStartThenEnd());
            ArrayList<Interval> overlapIntervals = new ArrayList<Interval>();
            Interval skipFromLatest = new Interval((ReadablePeriod)skipOffset, (ReadableInstant)latest);
            for (Interval interval : sortedSkipIntervals) {
                if (interval.overlaps((ReadableInterval)skipFromLatest)) {
                    overlapIntervals.add(interval);
                    continue;
                }
                nonNullSkipIntervals.add(interval);
            }
            if (!overlapIntervals.isEmpty()) {
                overlapIntervals.add(skipFromLatest);
                nonNullSkipIntervals.add(JodaUtils.umbrellaInterval(overlapIntervals));
            } else {
                nonNullSkipIntervals.add(skipFromLatest);
            }
        } else {
            Interval skipFromLatest = new Interval((ReadablePeriod)skipOffset, (ReadableInstant)latest);
            nonNullSkipIntervals.add(skipFromLatest);
        }
        return nonNullSkipIntervals;
    }

    @VisibleForTesting
    static List<Interval> filterSkipIntervals(Interval totalInterval, List<Interval> skipIntervals) {
        ArrayList<Interval> filteredIntervals = new ArrayList<Interval>(skipIntervals.size() + 1);
        DateTime remainingStart = totalInterval.getStart();
        DateTime remainingEnd = totalInterval.getEnd();
        for (Interval skipInterval : skipIntervals) {
            if (skipInterval.getStart().isBefore((ReadableInstant)remainingStart) && skipInterval.getEnd().isAfter((ReadableInstant)remainingStart)) {
                remainingStart = skipInterval.getEnd();
                continue;
            }
            if (skipInterval.getStart().isBefore((ReadableInstant)remainingEnd) && skipInterval.getEnd().isAfter((ReadableInstant)remainingEnd)) {
                remainingEnd = skipInterval.getStart();
                continue;
            }
            if (!remainingStart.isAfter((ReadableInstant)skipInterval.getStart()) && !remainingEnd.isBefore((ReadableInstant)skipInterval.getEnd())) {
                filteredIntervals.add(new Interval((ReadableInstant)remainingStart, (ReadableInstant)skipInterval.getStart()));
                remainingStart = skipInterval.getEnd();
                continue;
            }
            log.warn("skipInterval[%s] is not contained in remainingInterval[%s]", new Object[]{skipInterval, new Interval((ReadableInstant)remainingStart, (ReadableInstant)remainingEnd)});
        }
        if (!remainingStart.equals((Object)remainingEnd)) {
            filteredIntervals.add(new Interval((ReadableInstant)remainingStart, (ReadableInstant)remainingEnd));
        }
        return filteredIntervals;
    }

    private static class SegmentsToCompact {
        private final List<DataSegment> segments;
        private final long totalSize;

        private SegmentsToCompact() {
            this(Collections.emptyList());
        }

        private SegmentsToCompact(List<DataSegment> segments) {
            this.segments = segments;
            this.totalSize = segments.stream().mapToLong(DataSegment::getSize).sum();
        }

        private boolean isEmpty() {
            return this.segments.isEmpty();
        }

        private long getTotalSize() {
            return this.totalSize;
        }

        public String toString() {
            return "SegmentsToCompact{segments=" + SegmentUtils.commaSeparatedIdentifiers(this.segments) + ", totalSize=" + this.totalSize + '}';
        }
    }

    private static class QueueEntry {
        private final Interval interval;
        private final List<DataSegment> segments;

        private QueueEntry(List<DataSegment> segments) {
            Preconditions.checkArgument((segments != null && !segments.isEmpty() ? 1 : 0) != 0);
            DateTime minStart = DateTimes.MAX;
            DateTime maxEnd = DateTimes.MIN;
            for (DataSegment segment : segments) {
                if (segment.getInterval().getStart().compareTo((ReadableInstant)minStart) < 0) {
                    minStart = segment.getInterval().getStart();
                }
                if (segment.getInterval().getEnd().compareTo((ReadableInstant)maxEnd) <= 0) continue;
                maxEnd = segment.getInterval().getEnd();
            }
            this.interval = new Interval((ReadableInstant)minStart, (ReadableInstant)maxEnd);
            this.segments = segments;
        }

        private String getDataSource() {
            return this.segments.get(0).getDataSource();
        }
    }

    private static class CompactibleTimelineObjectHolderCursor
    implements Iterator<List<DataSegment>> {
        private final List<TimelineObjectHolder<String, DataSegment>> holders;

        CompactibleTimelineObjectHolderCursor(VersionedIntervalTimeline<String, DataSegment> timeline, List<Interval> totalIntervalsToSearch) {
            this.holders = totalIntervalsToSearch.stream().flatMap(interval -> timeline.lookup(interval).stream().filter(holder -> this.isCompactibleHolder((Interval)interval, (TimelineObjectHolder<String, DataSegment>)holder))).collect(Collectors.toList());
        }

        private boolean isCompactibleHolder(Interval interval, TimelineObjectHolder<String, DataSegment> holder) {
            long partitionBytes;
            Iterator chunks = holder.getObject().iterator();
            if (!chunks.hasNext()) {
                return false;
            }
            PartitionChunk firstChunk = (PartitionChunk)chunks.next();
            if (!interval.contains((ReadableInterval)((DataSegment)firstChunk.getObject()).getInterval())) {
                return false;
            }
            for (partitionBytes = ((DataSegment)firstChunk.getObject()).getSize(); partitionBytes == 0L && chunks.hasNext(); partitionBytes += ((DataSegment)((PartitionChunk)chunks.next()).getObject()).getSize()) {
            }
            return partitionBytes > 0L;
        }

        @Override
        public boolean hasNext() {
            return !this.holders.isEmpty();
        }

        @Override
        public List<DataSegment> next() {
            if (this.holders.isEmpty()) {
                throw new NoSuchElementException();
            }
            return Streams.sequentialStreamFrom((Iterable)this.holders.remove(this.holders.size() - 1).getObject()).map(PartitionChunk::getObject).collect(Collectors.toList());
        }
    }
}

