/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.initialization.jetty;

import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.TypeLiteral;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import javax.servlet.Filter;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.server.initialization.jetty.JettyRequestLog;
import org.apache.druid.server.initialization.jetty.ServletFilterHolder;
import org.apache.druid.server.security.AllowHttpMethodsResourceFilter;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.RequestLog;
import org.eclipse.jetty.server.handler.RequestLogHandler;
import org.eclipse.jetty.server.handler.gzip.GzipHandler;
import org.eclipse.jetty.servlet.FilterHolder;
import org.eclipse.jetty.servlet.FilterMapping;
import org.eclipse.jetty.servlet.ServletContextHandler;

public class JettyServerInitUtils {
    private static final String[] GZIP_METHODS = new String[]{"GET", "POST"};

    public static GzipHandler wrapWithDefaultGzipHandler(Handler handler, int inflateBufferSize, int compressionLevel) {
        GzipHandler gzipHandler = new GzipHandler();
        gzipHandler.setMinGzipSize(0);
        gzipHandler.setIncludedMethods(GZIP_METHODS);
        gzipHandler.setInflateBufferSize(inflateBufferSize);
        gzipHandler.setCompressionLevel(compressionLevel);
        gzipHandler.setCheckGzExists(false);
        gzipHandler.setHandler(handler);
        return gzipHandler;
    }

    public static void addExtensionFilters(ServletContextHandler handler, Injector injector) {
        Set extensionFilters = (Set)injector.getInstance(Key.get((TypeLiteral)new TypeLiteral<Set<ServletFilterHolder>>(){}));
        for (ServletFilterHolder servletFilterHolder : extensionFilters) {
            FilterHolder holder;
            if (servletFilterHolder.getFilter() != null) {
                holder = new FilterHolder(servletFilterHolder.getFilter());
            } else if (servletFilterHolder.getFilterClass() != null) {
                holder = new FilterHolder(servletFilterHolder.getFilterClass());
            } else {
                throw new ISE("Filter[%s] for paths[%s] didn't have a Filter!?", new Object[]{servletFilterHolder, Arrays.toString(servletFilterHolder.getPaths())});
            }
            if (servletFilterHolder.getInitParameters() != null) {
                holder.setInitParameters(servletFilterHolder.getInitParameters());
            }
            FilterMapping filterMapping = new FilterMapping();
            filterMapping.setFilterName(holder.getName());
            filterMapping.setPathSpecs(servletFilterHolder.getPaths());
            filterMapping.setDispatcherTypes(servletFilterHolder.getDispatcherType());
            handler.getServletHandler().addFilter(holder, filterMapping);
        }
    }

    public static Handler getJettyRequestLogHandler() {
        RequestLogHandler requestLogHandler = new RequestLogHandler();
        requestLogHandler.setRequestLog((RequestLog)new JettyRequestLog());
        return requestLogHandler;
    }

    public static void addAllowHttpMethodsFilter(ServletContextHandler root, List<String> allowedHttpMethods) {
        FilterHolder holder = new FilterHolder((Filter)new AllowHttpMethodsResourceFilter(allowedHttpMethods));
        root.addFilter(holder, "/*", null);
    }
}

