/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.initialization.jetty;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.jaxrs.json.JacksonJsonProvider;
import com.fasterxml.jackson.jaxrs.smile.JacksonSmileProvider;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.primitives.Ints;
import com.google.inject.Binder;
import com.google.inject.Binding;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Provides;
import com.google.inject.Scopes;
import com.google.inject.Singleton;
import com.google.inject.multibindings.Multibinder;
import com.sun.jersey.api.core.DefaultResourceConfig;
import com.sun.jersey.api.core.ResourceConfig;
import com.sun.jersey.guice.JerseyServletModule;
import com.sun.jersey.guice.spi.container.servlet.GuiceContainer;
import com.sun.jersey.spi.container.servlet.WebConfig;
import java.security.KeyStore;
import java.security.cert.CRL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicInteger;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509ExtendedTrustManager;
import org.apache.druid.guice.Jerseys;
import org.apache.druid.guice.JsonConfigProvider;
import org.apache.druid.guice.LazySingleton;
import org.apache.druid.guice.annotations.JSR311Resource;
import org.apache.druid.guice.annotations.Json;
import org.apache.druid.guice.annotations.Self;
import org.apache.druid.guice.annotations.Smile;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.RE;
import org.apache.druid.java.util.common.lifecycle.Lifecycle;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.java.util.emitter.service.ServiceEmitter;
import org.apache.druid.java.util.emitter.service.ServiceMetricEvent;
import org.apache.druid.java.util.metrics.AbstractMonitor;
import org.apache.druid.java.util.metrics.MonitorUtils;
import org.apache.druid.server.DruidNode;
import org.apache.druid.server.StatusResource;
import org.apache.druid.server.initialization.ServerConfig;
import org.apache.druid.server.initialization.TLSServerConfig;
import org.apache.druid.server.initialization.jetty.BadRequestExceptionMapper;
import org.apache.druid.server.initialization.jetty.CustomExceptionMapper;
import org.apache.druid.server.initialization.jetty.ForbiddenExceptionMapper;
import org.apache.druid.server.initialization.jetty.JettyMonitoringConnectionFactory;
import org.apache.druid.server.initialization.jetty.JettyServerInitializer;
import org.apache.druid.server.initialization.jetty.ServletFilterHolder;
import org.apache.druid.server.metrics.DataSourceTaskIdHolder;
import org.apache.druid.server.metrics.MetricsModule;
import org.apache.druid.server.metrics.MonitorsConfig;
import org.apache.druid.server.security.CustomCheckX509TrustManager;
import org.apache.druid.server.security.TLSCertificateChecker;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.ForwardedRequestCustomizer;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.SecureRequestCustomizer;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.SslConnectionFactory;
import org.eclipse.jetty.util.component.LifeCycle;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.eclipse.jetty.util.thread.QueuedThreadPool;
import org.eclipse.jetty.util.thread.ScheduledExecutorScheduler;
import org.eclipse.jetty.util.thread.ThreadPool;

public class JettyServerModule
extends JerseyServletModule {
    private static final Logger log = new Logger(JettyServerModule.class);
    private static final AtomicInteger ACTIVE_CONNECTIONS = new AtomicInteger();
    private static final String HTTP_1_1_STRING = "HTTP/1.1";

    protected void configureServlets() {
        Binder binder = this.binder();
        JsonConfigProvider.bind((Binder)binder, (String)"druid.server.http", ServerConfig.class);
        JsonConfigProvider.bind((Binder)binder, (String)"druid.server.https", TLSServerConfig.class);
        binder.bind(GuiceContainer.class).to(DruidGuiceContainer.class);
        binder.bind(DruidGuiceContainer.class).in(Scopes.SINGLETON);
        binder.bind(CustomExceptionMapper.class).in(Singleton.class);
        binder.bind(ForbiddenExceptionMapper.class).in(Singleton.class);
        binder.bind(BadRequestExceptionMapper.class).in(Singleton.class);
        this.serve("/*", new String[0]).with(DruidGuiceContainer.class);
        Jerseys.addResource((Binder)binder, StatusResource.class);
        binder.bind(StatusResource.class).in(LazySingleton.class);
        Multibinder.newSetBinder((Binder)binder, Handler.class);
        Multibinder.newSetBinder((Binder)binder, ServletFilterHolder.class);
        MetricsModule.register(binder, JettyMonitor.class);
    }

    @Provides
    @LazySingleton
    public Server getServer(Injector injector, Lifecycle lifecycle, @Self DruidNode node, ServerConfig config, TLSServerConfig TLSServerConfig2) {
        return JettyServerModule.makeAndInitializeServer(injector, lifecycle, node, config, TLSServerConfig2, (Binding<SslContextFactory>)injector.getExistingBinding(Key.get(SslContextFactory.class)), (TLSCertificateChecker)injector.getInstance(TLSCertificateChecker.class));
    }

    @Provides
    @Singleton
    public JacksonJsonProvider getJacksonJsonProvider(@Json ObjectMapper objectMapper) {
        JacksonJsonProvider provider = new JacksonJsonProvider();
        provider.setMapper(objectMapper);
        return provider;
    }

    @Provides
    @Singleton
    public JacksonSmileProvider getJacksonSmileProvider(@Smile ObjectMapper objectMapper) {
        JacksonSmileProvider provider = new JacksonSmileProvider();
        provider.setMapper(objectMapper);
        return provider;
    }

    static Server makeAndInitializeServer(Injector injector, Lifecycle lifecycle, final DruidNode node, final ServerConfig config, final TLSServerConfig tlsServerConfig, Binding<SslContextFactory> sslContextFactoryBinding, TLSCertificateChecker certificateChecker) {
        SslContextFactory sslContextFactory;
        QueuedThreadPool threadPool;
        int numServerThreads = config.getNumThreads() + JettyServerModule.getMaxJettyAcceptorsSelectorsNum(node);
        if (config.getQueueSize() == Integer.MAX_VALUE) {
            threadPool = new QueuedThreadPool();
            threadPool.setMinThreads(numServerThreads);
            threadPool.setMaxThreads(numServerThreads);
        } else {
            threadPool = new QueuedThreadPool(numServerThreads, numServerThreads, 60000, new LinkedBlockingQueue(config.getQueueSize()));
        }
        threadPool.setDaemon(true);
        final Server server = new Server((ThreadPool)threadPool);
        server.addBean((Object)new ScheduledExecutorScheduler("JettyScheduler", true), true);
        ArrayList<ServerConnector> serverConnectors = new ArrayList<ServerConnector>();
        if (node.isEnablePlaintextPort()) {
            log.info("Creating http connector with port [%d]", new Object[]{node.getPlaintextPort()});
            HttpConfiguration httpConfiguration = new HttpConfiguration();
            if (config.isEnableForwardedRequestCustomizer()) {
                httpConfiguration.addCustomizer((HttpConfiguration.Customizer)new ForwardedRequestCustomizer());
            }
            httpConfiguration.setRequestHeaderSize(config.getMaxRequestHeaderSize());
            ServerConnector connector = new ServerConnector(server, new ConnectionFactory[]{new HttpConnectionFactory(httpConfiguration)});
            if (node.isBindOnHost()) {
                connector.setHost(node.getHost());
            }
            connector.setPort(node.getPlaintextPort());
            serverConnectors.add(connector);
        }
        if (node.isEnableTlsPort()) {
            log.info("Creating https connector with port [%d]", new Object[]{node.getTlsPort()});
            if (sslContextFactoryBinding == null) {
                sslContextFactory = new IdentityCheckOverrideSslContextFactory(tlsServerConfig, certificateChecker);
                sslContextFactory.setKeyStorePath(tlsServerConfig.getKeyStorePath());
                sslContextFactory.setKeyStoreType(tlsServerConfig.getKeyStoreType());
                sslContextFactory.setKeyStorePassword(tlsServerConfig.getKeyStorePasswordProvider().getPassword());
                sslContextFactory.setCertAlias(tlsServerConfig.getCertAlias());
                sslContextFactory.setKeyManagerFactoryAlgorithm(tlsServerConfig.getKeyManagerFactoryAlgorithm() == null ? KeyManagerFactory.getDefaultAlgorithm() : tlsServerConfig.getKeyManagerFactoryAlgorithm());
                sslContextFactory.setKeyManagerPassword(tlsServerConfig.getKeyManagerPasswordProvider() == null ? null : tlsServerConfig.getKeyManagerPasswordProvider().getPassword());
                if (tlsServerConfig.getIncludeCipherSuites() != null) {
                    sslContextFactory.setIncludeCipherSuites(tlsServerConfig.getIncludeCipherSuites().toArray(new String[0]));
                }
                if (tlsServerConfig.getExcludeCipherSuites() != null) {
                    sslContextFactory.setExcludeCipherSuites(tlsServerConfig.getExcludeCipherSuites().toArray(new String[0]));
                }
                if (tlsServerConfig.getIncludeProtocols() != null) {
                    sslContextFactory.setIncludeProtocols(tlsServerConfig.getIncludeProtocols().toArray(new String[0]));
                }
                if (tlsServerConfig.getExcludeProtocols() != null) {
                    sslContextFactory.setExcludeProtocols(tlsServerConfig.getExcludeProtocols().toArray(new String[0]));
                }
                sslContextFactory.setNeedClientAuth(tlsServerConfig.isRequireClientCertificate());
                sslContextFactory.setWantClientAuth(tlsServerConfig.isRequestClientCertificate());
                if (tlsServerConfig.isRequireClientCertificate() || tlsServerConfig.isRequestClientCertificate()) {
                    if (tlsServerConfig.getCrlPath() != null) {
                        sslContextFactory.setValidatePeerCerts(true);
                        sslContextFactory.setCrlPath(tlsServerConfig.getCrlPath());
                    }
                    if (tlsServerConfig.isValidateHostnames()) {
                        sslContextFactory.setEndpointIdentificationAlgorithm("HTTPS");
                    }
                    if (tlsServerConfig.getTrustStorePath() != null) {
                        sslContextFactory.setTrustStorePath(tlsServerConfig.getTrustStorePath());
                        sslContextFactory.setTrustStoreType(tlsServerConfig.getTrustStoreType() == null ? KeyStore.getDefaultType() : tlsServerConfig.getTrustStoreType());
                        sslContextFactory.setTrustManagerFactoryAlgorithm(tlsServerConfig.getTrustStoreAlgorithm() == null ? TrustManagerFactory.getDefaultAlgorithm() : tlsServerConfig.getTrustStoreAlgorithm());
                        sslContextFactory.setTrustStorePassword(tlsServerConfig.getTrustStorePasswordProvider() == null ? null : tlsServerConfig.getTrustStorePasswordProvider().getPassword());
                    }
                }
            } else {
                sslContextFactory = (SslContextFactory)sslContextFactoryBinding.getProvider().get();
            }
            HttpConfiguration httpsConfiguration = new HttpConfiguration();
            if (config.isEnableForwardedRequestCustomizer()) {
                httpsConfiguration.addCustomizer((HttpConfiguration.Customizer)new ForwardedRequestCustomizer());
            }
            httpsConfiguration.setSecureScheme("https");
            httpsConfiguration.setSecurePort(node.getTlsPort());
            httpsConfiguration.addCustomizer((HttpConfiguration.Customizer)new SecureRequestCustomizer());
            httpsConfiguration.setRequestHeaderSize(config.getMaxRequestHeaderSize());
            ServerConnector connector = new ServerConnector(server, new ConnectionFactory[]{new SslConnectionFactory(sslContextFactory, HTTP_1_1_STRING), new HttpConnectionFactory(httpsConfiguration)});
            if (node.isBindOnHost()) {
                connector.setHost(node.getHost());
            }
            connector.setPort(node.getTlsPort());
            serverConnectors.add(connector);
        } else {
            sslContextFactory = null;
        }
        ServerConnector[] connectors = new ServerConnector[serverConnectors.size()];
        int index = 0;
        for (ServerConnector connector : serverConnectors) {
            connectors[index++] = connector;
            connector.setIdleTimeout((long)Ints.checkedCast((long)config.getMaxIdleTime().toStandardDuration().getMillis()));
            connector.setAcceptorPriorityDelta(-1);
            ArrayList<ConnectionFactory> monitoredConnFactories = new ArrayList<ConnectionFactory>();
            for (ConnectionFactory cf : connector.getConnectionFactories()) {
                if (cf.getProtocol().equals(connector.getDefaultProtocol())) {
                    monitoredConnFactories.add(new JettyMonitoringConnectionFactory(cf, ACTIVE_CONNECTIONS));
                    continue;
                }
                monitoredConnFactories.add(cf);
            }
            connector.setConnectionFactories(monitoredConnFactories);
        }
        server.setConnectors((Connector[])connectors);
        long gracefulStop = config.getGracefulShutdownTimeout().toStandardDuration().getMillis();
        if (gracefulStop > 0L) {
            server.setStopTimeout(gracefulStop);
        }
        server.addLifeCycleListener(new LifeCycle.Listener(){

            public void lifeCycleStarting(LifeCycle event) {
                log.debug("Jetty lifecycle starting [%s]", new Object[]{event.getClass()});
            }

            public void lifeCycleStarted(LifeCycle event) {
                log.debug("Jetty lifeycle started [%s]", new Object[]{event.getClass()});
            }

            public void lifeCycleFailure(LifeCycle event, Throwable cause) {
                log.error(cause, "Jetty lifecycle event failed [%s]", new Object[]{event.getClass()});
            }

            public void lifeCycleStopping(LifeCycle event) {
                log.debug("Jetty lifecycle stopping [%s]", new Object[]{event.getClass()});
            }

            public void lifeCycleStopped(LifeCycle event) {
                log.debug("Jetty lifecycle stopped [%s]", new Object[]{event.getClass()});
            }
        });
        JettyServerInitializer initializer = (JettyServerInitializer)injector.getInstance(JettyServerInitializer.class);
        try {
            initializer.initialize(server, injector);
        }
        catch (Exception e) {
            throw new RE((Throwable)e, "server initialization exception", new Object[0]);
        }
        lifecycle.addHandler(new Lifecycle.Handler(){

            public void start() throws Exception {
                log.debug("Starting Jetty Server...", new Object[0]);
                server.start();
                if (node.isEnableTlsPort()) {
                    Preconditions.checkNotNull((Object)sslContextFactory);
                    SSLEngine sslEngine = sslContextFactory.newSSLEngine();
                    if (sslEngine.getEnabledCipherSuites() == null || sslEngine.getEnabledCipherSuites().length == 0) {
                        throw new ISE("No supported cipher suites found, supported suites [%s], configured suites include list: [%s] exclude list: [%s]", new Object[]{Arrays.toString(sslEngine.getSupportedCipherSuites()), tlsServerConfig.getIncludeCipherSuites(), tlsServerConfig.getExcludeCipherSuites()});
                    }
                    if (sslEngine.getEnabledProtocols() == null || sslEngine.getEnabledProtocols().length == 0) {
                        throw new ISE("No supported protocols found, supported protocols [%s], configured protocols include list: [%s] exclude list: [%s]", new Object[]{Arrays.toString(sslEngine.getSupportedProtocols()), tlsServerConfig.getIncludeProtocols(), tlsServerConfig.getExcludeProtocols()});
                    }
                }
            }

            public void stop() {
                try {
                    long unannounceDelay = config.getUnannouncePropagationDelay().toStandardDuration().getMillis();
                    if (unannounceDelay > 0L) {
                        log.info("Sleeping %s ms for unannouncement to propagate.", new Object[]{unannounceDelay});
                        Thread.sleep(unannounceDelay);
                    } else {
                        log.debug("Skipping unannounce wait.", new Object[0]);
                    }
                    log.debug("Stopping Jetty Server...", new Object[0]);
                    server.stop();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw new RE((Throwable)e, "Interrupted waiting for jetty shutdown.", new Object[0]);
                }
                catch (Exception e) {
                    log.warn((Throwable)e, "Unable to stop Jetty server.", new Object[0]);
                }
            }
        }, Lifecycle.Stage.SERVER);
        return server;
    }

    private static int getMaxJettyAcceptorsSelectorsNum(DruidNode druidNode) {
        int numServerConnector = (druidNode.isEnablePlaintextPort() ? 1 : 0) + (druidNode.isEnableTlsPort() ? 1 : 0);
        return numServerConnector * 8;
    }

    @Provides
    @Singleton
    public JettyMonitor getJettyMonitor(DataSourceTaskIdHolder dataSourceTaskIdHolder) {
        return new JettyMonitor(dataSourceTaskIdHolder.getDataSource(), dataSourceTaskIdHolder.getTaskId());
    }

    @VisibleForTesting
    public int getActiveConnections() {
        return ACTIVE_CONNECTIONS.get();
    }

    private static class IdentityCheckOverrideSslContextFactory
    extends SslContextFactory {
        private final TLSServerConfig tlsServerConfig;
        private final TLSCertificateChecker certificateChecker;

        public IdentityCheckOverrideSslContextFactory(TLSServerConfig tlsServerConfig, TLSCertificateChecker certificateChecker) {
            super(false);
            this.tlsServerConfig = tlsServerConfig;
            this.certificateChecker = certificateChecker;
        }

        protected TrustManager[] getTrustManagers(KeyStore trustStore, Collection<? extends CRL> crls) throws Exception {
            TrustManager[] trustManagers = super.getTrustManagers(trustStore, crls);
            TrustManager[] newTrustManagers = new TrustManager[trustManagers.length];
            for (int i = 0; i < trustManagers.length; ++i) {
                if (trustManagers[i] instanceof X509ExtendedTrustManager) {
                    newTrustManagers[i] = new CustomCheckX509TrustManager((X509ExtendedTrustManager)trustManagers[i], this.certificateChecker, this.tlsServerConfig.isValidateHostnames());
                    continue;
                }
                newTrustManagers[i] = trustManagers[i];
                log.info("Encountered non-X509ExtendedTrustManager: " + trustManagers[i].getClass(), new Object[0]);
            }
            return newTrustManagers;
        }
    }

    public static class JettyMonitor
    extends AbstractMonitor {
        private final Map<String, String[]> dimensions;

        public JettyMonitor(String dataSource, String taskId) {
            this.dimensions = MonitorsConfig.mapOfDatasourceAndTaskID(dataSource, taskId);
        }

        public boolean doMonitor(ServiceEmitter emitter) {
            ServiceMetricEvent.Builder builder = new ServiceMetricEvent.Builder();
            MonitorUtils.addDimensionsToBuilder((ServiceMetricEvent.Builder)builder, this.dimensions);
            emitter.emit(builder.build("jetty/numOpenConnections", (Number)ACTIVE_CONNECTIONS.get()));
            return true;
        }
    }

    public static class DruidGuiceContainer
    extends GuiceContainer {
        private final Set<Class<?>> resources;

        @Inject
        public DruidGuiceContainer(Injector injector, @JSR311Resource Set<Class<?>> resources) {
            super(injector);
            this.resources = resources;
        }

        protected ResourceConfig getDefaultResourceConfig(Map<String, Object> props, WebConfig webConfig) {
            return new DefaultResourceConfig(this.resources);
        }
    }
}

