/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.router;

import com.google.inject.Inject;
import java.util.Collection;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.apache.druid.client.selector.Server;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.Pair;
import org.apache.druid.java.util.emitter.EmittingLogger;
import org.apache.druid.query.Query;
import org.apache.druid.server.router.AvaticaConnectionBalancer;
import org.apache.druid.server.router.TieredBrokerHostSelector;

public class QueryHostFinder {
    private static EmittingLogger log = new EmittingLogger(QueryHostFinder.class);
    private final TieredBrokerHostSelector hostSelector;
    private final AvaticaConnectionBalancer avaticaConnectionBalancer;
    private final ConcurrentHashMap<String, Server> serverBackup = new ConcurrentHashMap();

    @Inject
    public QueryHostFinder(TieredBrokerHostSelector hostSelector, AvaticaConnectionBalancer avaticaConnectionBalancer) {
        this.hostSelector = hostSelector;
        this.avaticaConnectionBalancer = avaticaConnectionBalancer;
    }

    public <T> Server findServer(Query<T> query) {
        Pair<String, Server> selected = this.hostSelector.select(query);
        return this.findServerInner(selected);
    }

    public Server findDefaultServer() {
        Pair<String, Server> selected = this.hostSelector.getDefaultLookup();
        return this.findServerInner(selected);
    }

    public Collection<Server> getAllServers() {
        return this.hostSelector.getAllBrokers().values().stream().flatMap(Collection::stream).collect(Collectors.toList());
    }

    public Server findServerAvatica(String connectionId) {
        Server chosenServer = this.avaticaConnectionBalancer.pickServer(this.getAllServers(), connectionId);
        if (chosenServer == null) {
            log.makeAlert("Catastrophic failure! No servers found at all! Failing request!", new Object[0]).emit();
            throw new ISE("No server found for Avatica request with connectionId[%s]", new Object[]{connectionId});
        }
        log.debug("Balancer class [%s] sending request with connectionId[%s] to server: %s", new Object[]{this.avaticaConnectionBalancer.getClass(), connectionId, chosenServer.getHost()});
        return chosenServer;
    }

    public <T> Server pickServer(Query<T> query) {
        Server server = this.findServer(query);
        if (server == null) {
            log.makeAlert("Catastrophic failure! No servers found at all! Failing request!", new Object[0]).emit();
            throw new ISE("No server found for query[%s]", new Object[]{query});
        }
        log.debug("Selected [%s]", new Object[]{server.getHost()});
        return server;
    }

    public Server pickDefaultServer() {
        Server server = this.findDefaultServer();
        if (server == null) {
            log.makeAlert("Catastrophic failure! No servers found at all! Failing request!", new Object[0]).emit();
            throw new ISE("No default server found!", new Object[0]);
        }
        return server;
    }

    private Server findServerInner(Pair<String, Server> selected) {
        Server server;
        if (selected == null) {
            log.error("Unable to find any brokers!", new Object[0]);
        }
        String serviceName = selected == null ? this.hostSelector.getDefaultServiceName() : (String)selected.lhs;
        Server server2 = server = selected == null ? null : (Server)selected.rhs;
        if (server == null) {
            log.error("No server found for serviceName[%s]. Using backup", new Object[]{serviceName});
            server = this.serverBackup.get(serviceName);
            if (server == null) {
                log.error("No backup found for serviceName[%s]. Using default[%s]", new Object[]{serviceName, this.hostSelector.getDefaultServiceName()});
                server = this.serverBackup.get(this.hostSelector.getDefaultServiceName());
            }
        }
        if (server != null) {
            this.serverBackup.put(serviceName, server);
        }
        return server;
    }
}

