/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.scheduling;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import it.unimi.dsi.fastutil.objects.Object2IntArrayMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.Optional;
import java.util.Set;
import org.apache.druid.client.SegmentServerSelector;
import org.apache.druid.query.Query;
import org.apache.druid.query.QueryPlus;
import org.apache.druid.server.QueryLaningStrategy;

public class HiLoQueryLaningStrategy
implements QueryLaningStrategy {
    public static final String LOW = "low";
    @JsonProperty
    private final int maxLowPercent;

    @JsonCreator
    public HiLoQueryLaningStrategy(@JsonProperty(value="maxLowPercent") Integer maxLowPercent) {
        this.maxLowPercent = (Integer)Preconditions.checkNotNull((Object)maxLowPercent, (Object)"maxLowPercent must be set");
        Preconditions.checkArgument((0 < maxLowPercent && maxLowPercent <= 100 ? 1 : 0) != 0, (Object)"maxLowPercent must be in the range 1 to 100");
    }

    @Override
    public Object2IntMap<String> getLaneLimits(int totalLimit) {
        Object2IntArrayMap onlyLow = new Object2IntArrayMap(1);
        onlyLow.put((Object)LOW, this.computeLimitFromPercent(totalLimit, this.maxLowPercent));
        return onlyLow;
    }

    @Override
    public <T> Optional<String> computeLane(QueryPlus<T> query, Set<SegmentServerSelector> segments) {
        Query theQuery = query.getQuery();
        Integer priority = (Integer)theQuery.getContextValue("priority");
        String lane = (String)theQuery.getContextValue("lane");
        if (lane == null && priority != null && priority < 0) {
            return Optional.of(LOW);
        }
        return Optional.ofNullable(lane);
    }
}

