/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.scheduling;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import it.unimi.dsi.fastutil.objects.Object2IntArrayMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.druid.client.SegmentServerSelector;
import org.apache.druid.query.Query;
import org.apache.druid.query.QueryContexts;
import org.apache.druid.query.QueryPlus;
import org.apache.druid.server.QueryLaningStrategy;

public class ManualQueryLaningStrategy
implements QueryLaningStrategy {
    @JsonProperty
    private Map<String, Integer> lanes;
    @JsonProperty
    private boolean isLimitPercent;

    @JsonCreator
    public ManualQueryLaningStrategy(@JsonProperty(value="lanes") Map<String, Integer> lanes, @JsonProperty(value="isLimitPercent") @Nullable Boolean isLimitPercent) {
        this.lanes = (Map)Preconditions.checkNotNull(lanes, (Object)"lanes must be set");
        this.isLimitPercent = isLimitPercent != null ? isLimitPercent : false;
        Preconditions.checkArgument((lanes.size() > 0 ? 1 : 0) != 0, (Object)"lanes must define at least one lane");
        Preconditions.checkArgument((boolean)lanes.values().stream().allMatch(x -> this.isLimitPercent ? 0 < x && x <= 100 : x > 0), (Object)(this.isLimitPercent ? "All lane limits must be in the range 1 to 100" : "All lane limits must be greater than 0"));
        Preconditions.checkArgument((boolean)lanes.keySet().stream().noneMatch("total"::equals), (Object)"Lane cannot be named 'total'");
        Preconditions.checkArgument((boolean)lanes.keySet().stream().noneMatch("default"::equals), (Object)"Lane cannot be named 'default'");
    }

    @Override
    public Object2IntMap<String> getLaneLimits(int totalLimit) {
        if (this.isLimitPercent) {
            Object2IntArrayMap laneLimits = new Object2IntArrayMap(this.lanes.size());
            this.lanes.forEach((arg_0, arg_1) -> this.lambda$getLaneLimits$1((Object2IntMap)laneLimits, totalLimit, arg_0, arg_1));
            return laneLimits;
        }
        return new Object2IntArrayMap(this.lanes);
    }

    @Override
    public <T> Optional<String> computeLane(QueryPlus<T> query, Set<SegmentServerSelector> segments) {
        return Optional.ofNullable(QueryContexts.getLane((Query)query.getQuery()));
    }

    private /* synthetic */ void lambda$getLaneLimits$1(Object2IntMap laneLimits, int totalLimit, String key, Integer value) {
        laneLimits.put((Object)key, this.computeLimitFromPercent(totalLimit, value));
    }
}

