/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.join;

import java.util.Optional;
import java.util.Set;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.query.DataSource;
import org.apache.druid.query.InlineDataSource;
import org.apache.druid.segment.join.JoinConditionAnalysis;
import org.apache.druid.segment.join.Joinable;
import org.apache.druid.segment.join.JoinableFactory;
import org.apache.druid.segment.join.table.IndexedTable;
import org.apache.druid.segment.join.table.IndexedTableJoinable;
import org.apache.druid.segment.join.table.RowBasedIndexedTable;

public class InlineJoinableFactory
implements JoinableFactory {
    public boolean isDirectlyJoinable(DataSource dataSource) {
        return dataSource instanceof InlineDataSource;
    }

    public Optional<Joinable> build(DataSource dataSource, JoinConditionAnalysis condition) {
        InlineDataSource inlineDataSource = (InlineDataSource)dataSource;
        if (condition.canHashJoin()) {
            Set rightKeyColumns = condition.getRightEquiConditionKeys();
            return Optional.of(new IndexedTableJoinable((IndexedTable)new RowBasedIndexedTable(inlineDataSource.getRowsAsList(), inlineDataSource.rowAdapter(), inlineDataSource.getRowSignature(), rightKeyColumns, DateTimes.nowUtc().toString())));
        }
        return Optional.empty();
    }
}

