/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.loading;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.IOException;
import javax.inject.Inject;
import org.apache.druid.guice.annotations.Json;
import org.apache.druid.segment.IndexIO;
import org.apache.druid.segment.ReferenceCountingSegment;
import org.apache.druid.segment.Segment;
import org.apache.druid.segment.SegmentLazyLoadFailCallback;
import org.apache.druid.segment.loading.MMappedQueryableSegmentizerFactory;
import org.apache.druid.segment.loading.SegmentCacheManager;
import org.apache.druid.segment.loading.SegmentLoader;
import org.apache.druid.segment.loading.SegmentLoadingException;
import org.apache.druid.segment.loading.SegmentizerFactory;
import org.apache.druid.timeline.DataSegment;
import org.apache.druid.timeline.partition.ShardSpec;

public class SegmentLocalCacheLoader
implements SegmentLoader {
    private final SegmentCacheManager cacheManager;
    private final IndexIO indexIO;
    private final ObjectMapper jsonMapper;

    @Inject
    public SegmentLocalCacheLoader(SegmentCacheManager cacheManager, IndexIO indexIO, @Json ObjectMapper mapper) {
        this.cacheManager = cacheManager;
        this.indexIO = indexIO;
        this.jsonMapper = mapper;
    }

    @Override
    public ReferenceCountingSegment getSegment(DataSegment segment, boolean lazy, SegmentLazyLoadFailCallback loadFailed) throws SegmentLoadingException {
        MMappedQueryableSegmentizerFactory factory;
        File segmentFiles = this.cacheManager.getSegmentFiles(segment);
        File factoryJson = new File(segmentFiles, "factory.json");
        if (factoryJson.exists()) {
            try {
                factory = (SegmentizerFactory)this.jsonMapper.readValue(factoryJson, SegmentizerFactory.class);
            }
            catch (IOException e) {
                throw new SegmentLoadingException((Throwable)e, "%s", new Object[]{e.getMessage()});
            }
        } else {
            factory = new MMappedQueryableSegmentizerFactory(this.indexIO);
        }
        Segment segmentObject = factory.factorize(segment, segmentFiles, lazy, loadFailed);
        return ReferenceCountingSegment.wrapSegment((Segment)segmentObject, (ShardSpec)segment.getShardSpec());
    }

    @Override
    public void cleanup(DataSegment segment) {
        this.cacheManager.cleanup(segment);
    }
}

