/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.security;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class AuthConfig {
    public static final String DRUID_AUTHENTICATION_RESULT = "Druid-Authentication-Result";
    public static final String DRUID_AUTHORIZATION_CHECKED = "Druid-Authorization-Checked";
    public static final String DRUID_ALLOW_UNSECURED_PATH = "Druid-Allow-Unsecured-Path";
    public static final String ALLOW_ALL_NAME = "allowAll";
    public static final String ANONYMOUS_NAME = "anonymous";
    public static final String TRUSTED_DOMAIN_NAME = "trustedDomain";
    @JsonProperty
    private final List<String> authenticatorChain;
    @JsonProperty
    private List<String> authorizers;
    @JsonProperty
    private final List<String> unsecuredPaths;
    @JsonProperty
    private final boolean allowUnauthenticatedHttpOptions;

    public AuthConfig() {
        this(null, null, null, false);
    }

    @JsonCreator
    public AuthConfig(@JsonProperty(value="authenticatorChain") List<String> authenticatorChain, @JsonProperty(value="authorizers") List<String> authorizers, @JsonProperty(value="unsecuredPaths") List<String> unsecuredPaths, @JsonProperty(value="allowUnauthenticatedHttpOptions") boolean allowUnauthenticatedHttpOptions) {
        this.authenticatorChain = authenticatorChain;
        this.authorizers = authorizers;
        this.unsecuredPaths = unsecuredPaths == null ? Collections.emptyList() : unsecuredPaths;
        this.allowUnauthenticatedHttpOptions = allowUnauthenticatedHttpOptions;
    }

    public List<String> getAuthenticatorChain() {
        return this.authenticatorChain;
    }

    public List<String> getAuthorizers() {
        return this.authorizers;
    }

    public List<String> getUnsecuredPaths() {
        return this.unsecuredPaths;
    }

    public boolean isAllowUnauthenticatedHttpOptions() {
        return this.allowUnauthenticatedHttpOptions;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AuthConfig that = (AuthConfig)o;
        return this.isAllowUnauthenticatedHttpOptions() == that.isAllowUnauthenticatedHttpOptions() && Objects.equals(this.getAuthenticatorChain(), that.getAuthenticatorChain()) && Objects.equals(this.getAuthorizers(), that.getAuthorizers()) && Objects.equals(this.getUnsecuredPaths(), that.getUnsecuredPaths());
    }

    public int hashCode() {
        return Objects.hash(this.getAuthenticatorChain(), this.getAuthorizers(), this.getUnsecuredPaths(), this.isAllowUnauthenticatedHttpOptions());
    }

    public String toString() {
        return "AuthConfig{authenticatorChain=" + this.authenticatorChain + ", authorizers=" + this.authorizers + ", unsecuredPaths=" + this.unsecuredPaths + ", allowUnauthenticatedHttpOptions=" + this.allowUnauthenticatedHttpOptions + '}';
    }
}

