/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.client;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Ordering;
import it.unimi.dsi.fastutil.ints.Int2ObjectRBTreeMap;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.ForkJoinPool;
import javax.annotation.Nullable;
import org.apache.druid.client.CachingClusteredClient;
import org.apache.druid.client.CachingClusteredClientTestUtils;
import org.apache.druid.client.DirectDruidClient;
import org.apache.druid.client.DruidServer;
import org.apache.druid.client.ImmutableDruidServer;
import org.apache.druid.client.ServerView;
import org.apache.druid.client.TimelineServerView;
import org.apache.druid.client.cache.Cache;
import org.apache.druid.client.cache.CacheConfig;
import org.apache.druid.client.cache.CachePopulator;
import org.apache.druid.client.cache.CachePopulatorStats;
import org.apache.druid.client.cache.ForegroundCachePopulator;
import org.apache.druid.client.cache.MapCache;
import org.apache.druid.client.selector.QueryableDruidServer;
import org.apache.druid.client.selector.ServerSelector;
import org.apache.druid.client.selector.TierSelectorStrategy;
import org.apache.druid.guice.http.DruidHttpClientConfig;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.java.util.common.Pair;
import org.apache.druid.java.util.common.guava.Sequence;
import org.apache.druid.java.util.common.io.Closer;
import org.apache.druid.java.util.emitter.service.ServiceEmitter;
import org.apache.druid.query.DruidProcessingConfig;
import org.apache.druid.query.Druids;
import org.apache.druid.query.Query;
import org.apache.druid.query.QueryPlus;
import org.apache.druid.query.QueryRunner;
import org.apache.druid.query.QueryToolChestWarehouse;
import org.apache.druid.query.aggregation.CountAggregatorFactory;
import org.apache.druid.query.context.ResponseContext;
import org.apache.druid.query.planning.DataSourceAnalysis;
import org.apache.druid.segment.join.JoinableFactory;
import org.apache.druid.segment.join.MapJoinableFactory;
import org.apache.druid.server.QueryStackTests;
import org.apache.druid.server.coordination.ServerType;
import org.apache.druid.server.metrics.NoopServiceEmitter;
import org.apache.druid.timeline.DataSegment;
import org.apache.druid.timeline.TimelineLookup;
import org.apache.druid.timeline.VersionedIntervalTimeline;
import org.apache.druid.timeline.partition.NoneShardSpec;
import org.apache.druid.timeline.partition.PartitionChunk;
import org.apache.druid.timeline.partition.ShardSpec;
import org.apache.druid.timeline.partition.SingleElementPartitionChunk;
import org.easymock.EasyMock;
import org.joda.time.Interval;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class CachingClusteredClientFunctionalityTest {
    private static final ObjectMapper OBJECT_MAPPER = CachingClusteredClientTestUtils.createObjectMapper();
    private static final Pair<QueryToolChestWarehouse, Closer> WAREHOUSE_AND_CLOSER = CachingClusteredClientTestUtils.createWarehouse(OBJECT_MAPPER);
    private static final QueryToolChestWarehouse WAREHOUSE = (QueryToolChestWarehouse)CachingClusteredClientFunctionalityTest.WAREHOUSE_AND_CLOSER.lhs;
    private static final Closer RESOURCE_CLOSER = (Closer)CachingClusteredClientFunctionalityTest.WAREHOUSE_AND_CLOSER.rhs;
    private CachingClusteredClient client;
    private VersionedIntervalTimeline<String, ServerSelector> timeline;
    private TimelineServerView serverView;
    private Cache cache;

    @AfterClass
    public static void tearDownClass() throws IOException {
        RESOURCE_CLOSER.close();
    }

    @Before
    public void setUp() {
        this.timeline = new VersionedIntervalTimeline((Comparator)Ordering.natural());
        this.serverView = (TimelineServerView)EasyMock.createNiceMock(TimelineServerView.class);
        this.cache = MapCache.create((long)100000L);
        this.client = this.makeClient((CachePopulator)new ForegroundCachePopulator(OBJECT_MAPPER, new CachePopulatorStats(), -1L));
    }

    @Test
    public void testUncoveredInterval() {
        this.addToTimeline(Intervals.of((String)"2015-01-02/2015-01-03"), "1");
        this.addToTimeline(Intervals.of((String)"2015-01-04/2015-01-05"), "1");
        this.addToTimeline(Intervals.of((String)"2015-02-04/2015-02-05"), "1");
        Druids.TimeseriesQueryBuilder builder = Druids.newTimeseriesQueryBuilder().dataSource("test").intervals("2015-01-02/2015-01-03").granularity("day").aggregators(Collections.singletonList(new CountAggregatorFactory("rows"))).context((Map)ImmutableMap.of((Object)"uncoveredIntervalsLimit", (Object)3));
        ResponseContext responseContext = ResponseContext.createEmpty();
        CachingClusteredClientFunctionalityTest.runQuery(this.client, builder.build(), responseContext);
        Assert.assertNull((Object)responseContext.get((ResponseContext.BaseKey)ResponseContext.Key.UNCOVERED_INTERVALS));
        builder.intervals("2015-01-01/2015-01-03");
        responseContext = ResponseContext.createEmpty();
        CachingClusteredClientFunctionalityTest.runQuery(this.client, builder.build(), responseContext);
        this.assertUncovered(responseContext, false, "2015-01-01/2015-01-02");
        builder.intervals("2015-01-01/2015-01-04");
        responseContext = ResponseContext.createEmpty();
        CachingClusteredClientFunctionalityTest.runQuery(this.client, builder.build(), responseContext);
        this.assertUncovered(responseContext, false, "2015-01-01/2015-01-02", "2015-01-03/2015-01-04");
        builder.intervals("2015-01-02/2015-01-04");
        responseContext = ResponseContext.createEmpty();
        CachingClusteredClientFunctionalityTest.runQuery(this.client, builder.build(), responseContext);
        this.assertUncovered(responseContext, false, "2015-01-03/2015-01-04");
        builder.intervals("2015-01-01/2015-01-30");
        responseContext = ResponseContext.createEmpty();
        CachingClusteredClientFunctionalityTest.runQuery(this.client, builder.build(), responseContext);
        this.assertUncovered(responseContext, false, "2015-01-01/2015-01-02", "2015-01-03/2015-01-04", "2015-01-05/2015-01-30");
        builder.intervals("2015-01-02/2015-01-30");
        responseContext = ResponseContext.createEmpty();
        CachingClusteredClientFunctionalityTest.runQuery(this.client, builder.build(), responseContext);
        this.assertUncovered(responseContext, false, "2015-01-03/2015-01-04", "2015-01-05/2015-01-30");
        builder.intervals("2015-01-04/2015-01-30");
        responseContext = ResponseContext.createEmpty();
        CachingClusteredClientFunctionalityTest.runQuery(this.client, builder.build(), responseContext);
        this.assertUncovered(responseContext, false, "2015-01-05/2015-01-30");
        builder.intervals("2015-01-10/2015-01-30");
        responseContext = ResponseContext.createEmpty();
        CachingClusteredClientFunctionalityTest.runQuery(this.client, builder.build(), responseContext);
        this.assertUncovered(responseContext, false, "2015-01-10/2015-01-30");
        builder.intervals("2015-01-01/2015-02-25");
        responseContext = ResponseContext.createEmpty();
        CachingClusteredClientFunctionalityTest.runQuery(this.client, builder.build(), responseContext);
        this.assertUncovered(responseContext, true, "2015-01-01/2015-01-02", "2015-01-03/2015-01-04", "2015-01-05/2015-02-04");
    }

    private void assertUncovered(ResponseContext context, boolean uncoveredIntervalsOverflowed, String ... intervals) {
        ArrayList expectedList = Lists.newArrayListWithExpectedSize((int)intervals.length);
        for (String interval : intervals) {
            expectedList.add(Intervals.of((String)interval));
        }
        Assert.assertEquals((Object)expectedList, (Object)context.get((ResponseContext.BaseKey)ResponseContext.Key.UNCOVERED_INTERVALS));
        Assert.assertEquals((Object)uncoveredIntervalsOverflowed, (Object)context.get((ResponseContext.BaseKey)ResponseContext.Key.UNCOVERED_INTERVALS_OVERFLOWED));
    }

    private void addToTimeline(Interval interval, String version) {
        this.timeline.add(interval, (Object)version, (PartitionChunk)new SingleElementPartitionChunk((Object)new ServerSelector(DataSegment.builder().dataSource("test").interval(interval).version(version).shardSpec((ShardSpec)NoneShardSpec.instance()).size(0L).build(), new TierSelectorStrategy(){

            public Comparator<Integer> getComparator() {
                return Ordering.natural();
            }

            public QueryableDruidServer pick(Int2ObjectRBTreeMap<Set<QueryableDruidServer>> prioritizedServers, DataSegment segment) {
                return new QueryableDruidServer(new DruidServer("localhost", "localhost", null, 100L, ServerType.HISTORICAL, "a", 10), (QueryRunner)EasyMock.createNiceMock(DirectDruidClient.class));
            }

            public List<QueryableDruidServer> pick(Int2ObjectRBTreeMap<Set<QueryableDruidServer>> prioritizedServers, DataSegment segment, int numServersToPick) {
                return Collections.singletonList(new QueryableDruidServer(new DruidServer("localhost", "localhost", null, 100L, ServerType.HISTORICAL, "a", 10), (QueryRunner)EasyMock.createNiceMock(DirectDruidClient.class)));
            }
        })));
    }

    protected CachingClusteredClient makeClient(CachePopulator cachePopulator) {
        return this.makeClient(cachePopulator, this.cache, 10);
    }

    protected CachingClusteredClient makeClient(CachePopulator cachePopulator, Cache cache, final int mergeLimit) {
        return new CachingClusteredClient(WAREHOUSE, new TimelineServerView(){

            public void registerSegmentCallback(Executor exec, ServerView.SegmentCallback callback) {
            }

            public Optional<? extends TimelineLookup<String, ServerSelector>> getTimeline(DataSourceAnalysis analysis) {
                return Optional.of(CachingClusteredClientFunctionalityTest.this.timeline);
            }

            @Nullable
            public List<ImmutableDruidServer> getDruidServers() {
                throw new UnsupportedOperationException();
            }

            public void registerTimelineCallback(Executor exec, TimelineServerView.TimelineCallback callback) {
                throw new UnsupportedOperationException();
            }

            public <T> QueryRunner<T> getQueryRunner(DruidServer server) {
                return CachingClusteredClientFunctionalityTest.this.serverView.getQueryRunner(server);
            }

            public void registerServerRemovedCallback(Executor exec, ServerView.ServerRemovedCallback callback) {
            }
        }, cache, OBJECT_MAPPER, cachePopulator, new CacheConfig(){

            public boolean isPopulateCache() {
                return true;
            }

            public boolean isUseCache() {
                return true;
            }

            public boolean isQueryCacheable(Query query) {
                return true;
            }

            public int getCacheBulkMergeLimit() {
                return mergeLimit;
            }
        }, new DruidHttpClientConfig(){

            public long getMaxQueuedBytes() {
                return 0L;
            }
        }, new DruidProcessingConfig(){

            public String getFormatString() {
                return null;
            }

            public int getMergePoolParallelism() {
                return 4;
            }
        }, ForkJoinPool.commonPool(), QueryStackTests.DEFAULT_NOOP_SCHEDULER, (JoinableFactory)new MapJoinableFactory((Set)ImmutableSet.of(), (Map)ImmutableMap.of()), (ServiceEmitter)new NoopServiceEmitter());
    }

    private static <T> Sequence<T> runQuery(CachingClusteredClient client, Query<T> query, ResponseContext responseContext) {
        Query theQuery = query.withId("queryId");
        return client.getQueryRunnerForIntervals(theQuery, (Iterable)theQuery.getIntervals()).run(QueryPlus.wrap((Query)theQuery), responseContext);
    }
}

