/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.client.indexing;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import org.apache.druid.client.indexing.HttpIndexingServiceClient;
import org.apache.druid.client.indexing.SamplerResponse;
import org.apache.druid.client.indexing.SamplerSpec;
import org.apache.druid.discovery.DruidLeaderClient;
import org.apache.druid.jackson.DefaultObjectMapper;
import org.apache.druid.java.util.http.client.Request;
import org.apache.druid.java.util.http.client.response.StringFullResponseHolder;
import org.easymock.EasyMock;
import org.jboss.netty.buffer.BigEndianHeapChannelBuffer;
import org.jboss.netty.handler.codec.http.HttpMethod;
import org.jboss.netty.handler.codec.http.HttpResponse;
import org.jboss.netty.handler.codec.http.HttpResponseStatus;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class HttpIndexingServiceClientTest {
    private HttpIndexingServiceClient httpIndexingServiceClient;
    private ObjectMapper jsonMapper;
    private DruidLeaderClient druidLeaderClient;
    @Rule
    public ExpectedException expectedException = ExpectedException.none();

    @Before
    public void setup() {
        this.jsonMapper = new DefaultObjectMapper();
        this.druidLeaderClient = (DruidLeaderClient)EasyMock.createMock(DruidLeaderClient.class);
        this.httpIndexingServiceClient = new HttpIndexingServiceClient(this.jsonMapper, this.druidLeaderClient);
    }

    @Test
    public void testSample() throws Exception {
        final SamplerResponse samplerResponse = new SamplerResponse(2, 2, (List)ImmutableList.of((Object)new SamplerResponse.SamplerResponseRow((Map)ImmutableMap.of((Object)"time", (Object)"2020-01-01", (Object)"x", (Object)"123", (Object)"y", (Object)"456"), (Map)ImmutableMap.of((Object)"time", (Object)"2020-01-01", (Object)"x", (Object)"123", (Object)"y", (Object)"456"), Boolean.valueOf(false), null)));
        SamplerSpec samplerSpec = new SamplerSpec(){

            public SamplerResponse sample() {
                return samplerResponse;
            }
        };
        HttpResponse response = (HttpResponse)EasyMock.createMock(HttpResponse.class);
        EasyMock.expect((Object)response.getContent()).andReturn((Object)new BigEndianHeapChannelBuffer(0));
        EasyMock.replay((Object[])new Object[]{response});
        StringFullResponseHolder responseHolder = new StringFullResponseHolder(HttpResponseStatus.OK, response, StandardCharsets.UTF_8).addChunk(this.jsonMapper.writeValueAsString((Object)samplerResponse));
        EasyMock.expect((Object)this.druidLeaderClient.go((Request)EasyMock.anyObject(Request.class))).andReturn((Object)responseHolder).anyTimes();
        EasyMock.expect((Object)this.druidLeaderClient.makeRequest(HttpMethod.POST, "/druid/indexer/v1/sampler")).andReturn((Object)new Request(HttpMethod.POST, new URL("http://localhost:8090/druid/indexer/v1/sampler"))).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.druidLeaderClient});
        SamplerResponse actualResponse = this.httpIndexingServiceClient.sample(samplerSpec);
        Assert.assertEquals((Object)samplerResponse, (Object)actualResponse);
        EasyMock.verify((Object[])new Object[]{this.druidLeaderClient, response});
    }

    @Test
    public void testSampleError() throws Exception {
        this.expectedException.expect(RuntimeException.class);
        this.expectedException.expectMessage("Failed to sample with sampler spec");
        this.expectedException.expectMessage("Please check overlord log");
        final SamplerResponse samplerResponse = new SamplerResponse(2, 2, (List)ImmutableList.of((Object)new SamplerResponse.SamplerResponseRow((Map)ImmutableMap.of((Object)"time", (Object)"2020-01-01", (Object)"x", (Object)"123", (Object)"y", (Object)"456"), (Map)ImmutableMap.of((Object)"time", (Object)"2020-01-01", (Object)"x", (Object)"123", (Object)"y", (Object)"456"), Boolean.valueOf(false), null)));
        SamplerSpec samplerSpec = new SamplerSpec(){

            public SamplerResponse sample() {
                return samplerResponse;
            }
        };
        HttpResponse response = (HttpResponse)EasyMock.createMock(HttpResponse.class);
        EasyMock.expect((Object)response.getContent()).andReturn((Object)new BigEndianHeapChannelBuffer(0));
        EasyMock.replay((Object[])new Object[]{response});
        StringFullResponseHolder responseHolder = new StringFullResponseHolder(HttpResponseStatus.INTERNAL_SERVER_ERROR, response, StandardCharsets.UTF_8).addChunk("");
        EasyMock.expect((Object)this.druidLeaderClient.go((Request)EasyMock.anyObject(Request.class))).andReturn((Object)responseHolder).anyTimes();
        EasyMock.expect((Object)this.druidLeaderClient.makeRequest(HttpMethod.POST, "/druid/indexer/v1/sampler")).andReturn((Object)new Request(HttpMethod.POST, new URL("http://localhost:8090/druid/indexer/v1/sampler"))).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.druidLeaderClient});
        this.httpIndexingServiceClient.sample(samplerSpec);
        EasyMock.verify((Object[])new Object[]{this.druidLeaderClient, response});
    }
}

