/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.metadata;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.stream.Collectors;
import org.apache.druid.client.ImmutableDruidDataSource;
import org.apache.druid.metadata.SQLMetadataConnector;
import org.apache.druid.metadata.SegmentsMetadataManagerConfig;
import org.apache.druid.metadata.SqlSegmentsMetadataManager;
import org.apache.druid.metadata.TestDerbyConnector;
import org.apache.druid.segment.TestHelper;
import org.joda.time.Period;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

public class SqlSegmentsMetadataManagerEmptyTest {
    @Rule
    public final TestDerbyConnector.DerbyConnectorRule derbyConnectorRule = new TestDerbyConnector.DerbyConnectorRule();
    private SqlSegmentsMetadataManager sqlSegmentsMetadataManager;
    private final ObjectMapper jsonMapper = TestHelper.makeJsonMapper();

    @Before
    public void setUp() {
        TestDerbyConnector connector = this.derbyConnectorRule.getConnector();
        SegmentsMetadataManagerConfig config = new SegmentsMetadataManagerConfig();
        config.setPollDuration(Period.seconds((int)1));
        this.sqlSegmentsMetadataManager = new SqlSegmentsMetadataManager(this.jsonMapper, Suppliers.ofInstance((Object)config), this.derbyConnectorRule.metadataTablesConfigSupplier(), (SQLMetadataConnector)connector);
        this.sqlSegmentsMetadataManager.start();
        connector.createSegmentTable();
    }

    @After
    public void teardown() {
        if (this.sqlSegmentsMetadataManager.isPollingDatabasePeriodically()) {
            this.sqlSegmentsMetadataManager.stopPollingDatabasePeriodically();
        }
        this.sqlSegmentsMetadataManager.stop();
    }

    @Test
    public void testPollEmpty() {
        this.sqlSegmentsMetadataManager.startPollingDatabasePeriodically();
        this.sqlSegmentsMetadataManager.poll();
        Assert.assertTrue((boolean)this.sqlSegmentsMetadataManager.isPollingDatabasePeriodically());
        Assert.assertEquals((Object)ImmutableSet.of(), (Object)this.sqlSegmentsMetadataManager.retrieveAllDataSourceNames());
        Assert.assertEquals((Object)ImmutableList.of(), this.sqlSegmentsMetadataManager.getImmutableDataSourcesWithAllUsedSegments().stream().map(ImmutableDruidDataSource::getName).collect(Collectors.toList()));
        Assert.assertEquals(null, (Object)this.sqlSegmentsMetadataManager.getImmutableDataSourceWithUsedSegments("wikipedia"));
        Assert.assertEquals((Object)ImmutableSet.of(), (Object)ImmutableSet.copyOf((Iterable)this.sqlSegmentsMetadataManager.iterateAllUsedSegments()));
    }

    @Test
    public void testStopAndStart() {
        this.sqlSegmentsMetadataManager.startPollingDatabasePeriodically();
        this.sqlSegmentsMetadataManager.stopPollingDatabasePeriodically();
        this.sqlSegmentsMetadataManager.startPollingDatabasePeriodically();
        this.sqlSegmentsMetadataManager.stopPollingDatabasePeriodically();
    }
}

