/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.metadata.input;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.sql.DataSource;
import nl.jqno.equalsverifier.EqualsVerifier;
import org.apache.commons.dbcp2.BasicDataSource;
import org.apache.commons.io.FileUtils;
import org.apache.druid.data.input.ColumnsFilter;
import org.apache.druid.data.input.InputFormat;
import org.apache.druid.data.input.InputRowListPlusRawValues;
import org.apache.druid.data.input.InputRowSchema;
import org.apache.druid.data.input.InputSourceReader;
import org.apache.druid.data.input.InputSplit;
import org.apache.druid.data.input.Row;
import org.apache.druid.data.input.impl.DimensionsSpec;
import org.apache.druid.data.input.impl.TimestampSpec;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.parsers.CloseableIterator;
import org.apache.druid.metadata.MetadataStorageConnectorConfig;
import org.apache.druid.metadata.SQLFirehoseDatabaseConnector;
import org.apache.druid.metadata.TestDerbyConnector;
import org.apache.druid.metadata.input.InputSourceModule;
import org.apache.druid.metadata.input.SqlInputSource;
import org.apache.druid.metadata.input.SqlTestUtils;
import org.apache.druid.segment.TestHelper;
import org.apache.druid.server.initialization.JdbcAccessSecurityConfig;
import org.easymock.EasyMock;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.skife.jdbi.v2.DBI;

public class SqlInputSourceTest {
    private static final List<File> FIREHOSE_TMP_DIRS = new ArrayList<File>();
    private final String TABLE_NAME_1 = "FOOS_TABLE_1";
    private final String TABLE_NAME_2 = "FOOS_TABLE_2";
    private final List<String> SQLLIST1 = ImmutableList.of((Object)"SELECT timestamp,a,b FROM FOOS_TABLE_1");
    private final List<String> SQLLIST2 = ImmutableList.of((Object)"SELECT timestamp,a,b FROM FOOS_TABLE_1", (Object)"SELECT timestamp,a,b FROM FOOS_TABLE_2");
    private static final InputRowSchema INPUT_ROW_SCHEMA = new InputRowSchema(new TimestampSpec("timestamp", "auto", null), new DimensionsSpec(DimensionsSpec.getDefaultSchemas(Arrays.asList("timestamp", "a", "b")), new ArrayList(), new ArrayList()), ColumnsFilter.all());
    @Rule
    public final TestDerbyConnector.DerbyConnectorRule derbyConnectorRule = new TestDerbyConnector.DerbyConnectorRule();
    private final ObjectMapper mapper = TestHelper.makeSmileMapper();
    private TestDerbyConnector derbyConnector;

    @Before
    public void setUp() {
        for (Module jacksonModule : new InputSourceModule().getJacksonModules()) {
            this.mapper.registerModule(jacksonModule);
        }
    }

    @AfterClass
    public static void teardown() throws IOException {
        for (File dir : FIREHOSE_TMP_DIRS) {
            FileUtils.forceDelete((File)dir);
        }
    }

    private void assertResult(List<Row> rows, List<String> sqls) {
        Assert.assertEquals((long)(10 * sqls.size()), (long)rows.size());
        rows.sort(Comparator.comparing(Row::getTimestamp).thenComparingInt(r -> Integer.valueOf((String)r.getDimension("a").get(0))).thenComparingInt(r -> Integer.valueOf((String)r.getDimension("b").get(0))));
        int rowCount = 0;
        for (int i = 0; i < 10; ++i) {
            for (int j = 0; j < sqls.size(); ++j) {
                Row row = rows.get(rowCount);
                String timestampSt = StringUtils.format((String)"2011-01-12T00:0%s:00.000Z", (Object[])new Object[]{i});
                Assert.assertEquals((Object)timestampSt, (Object)row.getTimestamp().toString());
                Assert.assertEquals((long)i, (long)Integer.valueOf((String)row.getDimension("a").get(0)).intValue());
                Assert.assertEquals((long)i, (long)Integer.valueOf((String)row.getDimension("b").get(0)).intValue());
                ++rowCount;
            }
        }
    }

    private File createFirehoseTmpDir(String dirSuffix) throws IOException {
        File firehoseTempDir = File.createTempFile(SqlInputSourceTest.class.getSimpleName(), dirSuffix);
        FileUtils.forceDelete((File)firehoseTempDir);
        FileUtils.forceMkdir((File)firehoseTempDir);
        FIREHOSE_TMP_DIRS.add(firehoseTempDir);
        return firehoseTempDir;
    }

    @Test
    public void testSerde() throws IOException {
        this.mapper.registerSubtypes(new Class[]{TestSerdeFirehoseConnector.class});
        TestSerdeFirehoseConnector testSerdeFirehoseConnector = new TestSerdeFirehoseConnector(new MetadataStorageConnectorConfig());
        SqlInputSource sqlInputSource = new SqlInputSource(this.SQLLIST1, true, (SQLFirehoseDatabaseConnector)testSerdeFirehoseConnector, this.mapper);
        String valueString = this.mapper.writeValueAsString((Object)sqlInputSource);
        SqlInputSource inputSourceFromJson = (SqlInputSource)this.mapper.readValue(valueString, SqlInputSource.class);
        Assert.assertEquals((Object)sqlInputSource, (Object)inputSourceFromJson);
    }

    @Test
    public void testSingleSplit() throws Exception {
        this.derbyConnector = this.derbyConnectorRule.getConnector();
        SqlTestUtils testUtils = new SqlTestUtils(this.derbyConnector);
        testUtils.createAndUpdateTable("FOOS_TABLE_1", 10);
        File tempDir = this.createFirehoseTmpDir("testSingleSplit");
        SqlInputSource sqlInputSource = new SqlInputSource(this.SQLLIST1, true, (SQLFirehoseDatabaseConnector)testUtils.getDerbyFirehoseConnector(), this.mapper);
        InputSourceReader sqlReader = sqlInputSource.fixedFormatReader(INPUT_ROW_SCHEMA, tempDir);
        CloseableIterator resultIterator = sqlReader.read();
        ArrayList<Row> rows = new ArrayList<Row>();
        while (resultIterator.hasNext()) {
            rows.add((Row)resultIterator.next());
        }
        this.assertResult(rows, this.SQLLIST1);
        testUtils.dropTable("FOOS_TABLE_1");
    }

    @Test
    public void testMultipleSplits() throws Exception {
        this.derbyConnector = this.derbyConnectorRule.getConnector();
        SqlTestUtils testUtils = new SqlTestUtils(this.derbyConnector);
        testUtils.createAndUpdateTable("FOOS_TABLE_1", 10);
        testUtils.createAndUpdateTable("FOOS_TABLE_2", 10);
        File tempDir = this.createFirehoseTmpDir("testMultipleSplit");
        SqlInputSource sqlInputSource = new SqlInputSource(this.SQLLIST2, true, (SQLFirehoseDatabaseConnector)testUtils.getDerbyFirehoseConnector(), this.mapper);
        InputSourceReader sqlReader = sqlInputSource.fixedFormatReader(INPUT_ROW_SCHEMA, tempDir);
        CloseableIterator resultIterator = sqlReader.read();
        ArrayList<Row> rows = new ArrayList<Row>();
        while (resultIterator.hasNext()) {
            rows.add((Row)resultIterator.next());
        }
        this.assertResult(rows, this.SQLLIST2);
        testUtils.dropTable("FOOS_TABLE_1");
        testUtils.dropTable("FOOS_TABLE_2");
    }

    @Test
    public void testNumSplits() {
        this.derbyConnector = this.derbyConnectorRule.getConnector();
        SqlTestUtils testUtils = new SqlTestUtils(this.derbyConnector);
        SqlInputSource sqlInputSource = new SqlInputSource(this.SQLLIST2, true, (SQLFirehoseDatabaseConnector)testUtils.getDerbyFirehoseConnector(), this.mapper);
        InputFormat inputFormat = (InputFormat)EasyMock.createMock(InputFormat.class);
        Stream sqlSplits = sqlInputSource.createSplits(inputFormat, null);
        Assert.assertEquals(this.SQLLIST2, sqlSplits.map(InputSplit::get).collect(Collectors.toList()));
        Assert.assertEquals((long)2L, (long)sqlInputSource.estimateNumSplits(inputFormat, null));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSample() throws Exception {
        this.derbyConnector = this.derbyConnectorRule.getConnector();
        SqlTestUtils testUtils = new SqlTestUtils(this.derbyConnector);
        testUtils.createAndUpdateTable("FOOS_TABLE_1", 10);
        try {
            File tempDir = this.createFirehoseTmpDir("testSingleSplit");
            SqlInputSource sqlInputSource = new SqlInputSource(this.SQLLIST1, true, (SQLFirehoseDatabaseConnector)testUtils.getDerbyFirehoseConnector(), this.mapper);
            InputSourceReader sqlReader = sqlInputSource.fixedFormatReader(INPUT_ROW_SCHEMA, tempDir);
            CloseableIterator resultIterator = sqlReader.sample();
            ArrayList<InputRowListPlusRawValues> rows = new ArrayList<InputRowListPlusRawValues>();
            while (resultIterator.hasNext()) {
                InputRowListPlusRawValues row = (InputRowListPlusRawValues)resultIterator.next();
                Assert.assertNull((Object)row.getParseException());
                rows.add(row);
            }
            this.assertResult(rows.stream().flatMap(r -> r.getInputRows().stream()).collect(Collectors.toList()), this.SQLLIST1);
        }
        finally {
            testUtils.dropTable("FOOS_TABLE_1");
        }
    }

    @Test
    public void testEquals() {
        EqualsVerifier.forClass(SqlInputSource.class).withPrefabValues(ObjectMapper.class, (Object)new ObjectMapper(), (Object)new ObjectMapper()).withIgnoredFields(new String[]{"objectMapper"}).withNonnullFields(new String[]{"sqls", "sqlFirehoseDatabaseConnector"}).usingGetClass().verify();
    }

    @JsonTypeName(value="test")
    private static class TestSerdeFirehoseConnector
    extends SQLFirehoseDatabaseConnector {
        private final DBI dbi;
        private final MetadataStorageConnectorConfig metadataStorageConnectorConfig;

        private TestSerdeFirehoseConnector(@JsonProperty(value="connectorConfig") MetadataStorageConnectorConfig metadataStorageConnectorConfig) {
            BasicDataSource datasource = this.getDatasource(metadataStorageConnectorConfig, new JdbcAccessSecurityConfig(){

                public Set<String> getAllowedProperties() {
                    return ImmutableSet.of((Object)"user", (Object)"create");
                }
            });
            datasource.setDriverClassLoader(((Object)((Object)this)).getClass().getClassLoader());
            datasource.setDriverClassName("org.apache.derby.jdbc.ClientDriver");
            this.dbi = new DBI((DataSource)datasource);
            this.metadataStorageConnectorConfig = metadataStorageConnectorConfig;
        }

        @JsonProperty(value="connectorConfig")
        public MetadataStorageConnectorConfig getConnectorConfig() {
            return this.metadataStorageConnectorConfig;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            TestSerdeFirehoseConnector that = (TestSerdeFirehoseConnector)((Object)o);
            return this.metadataStorageConnectorConfig.equals((Object)that.metadataStorageConnectorConfig);
        }

        public int hashCode() {
            return Objects.hash(this.metadataStorageConnectorConfig);
        }

        public DBI getDBI() {
            return this.dbi;
        }

        public Set<String> findPropertyKeysFromConnectURL(String connectUri, boolean allowUnknown) {
            return ImmutableSet.of((Object)"user", (Object)"create");
        }
    }
}

