/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.lookup;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.apache.druid.discovery.DruidLeaderClient;
import org.apache.druid.jackson.DefaultObjectMapper;
import org.apache.druid.java.util.emitter.EmittingLogger;
import org.apache.druid.java.util.emitter.service.ServiceEmitter;
import org.apache.druid.java.util.http.client.Request;
import org.apache.druid.java.util.http.client.response.StringFullResponseHolder;
import org.apache.druid.query.lookup.LookupConfig;
import org.apache.druid.query.lookup.LookupExtractorFactory;
import org.apache.druid.query.lookup.LookupExtractorFactoryContainer;
import org.apache.druid.query.lookup.LookupListeningAnnouncerConfig;
import org.apache.druid.query.lookup.LookupReferencesManager;
import org.apache.druid.query.lookup.LookupsState;
import org.apache.druid.query.lookup.MapLookupExtractorFactory;
import org.apache.druid.server.metrics.NoopServiceEmitter;
import org.easymock.EasyMock;
import org.jboss.netty.buffer.BigEndianHeapChannelBuffer;
import org.jboss.netty.handler.codec.http.HttpMethod;
import org.jboss.netty.handler.codec.http.HttpResponse;
import org.jboss.netty.handler.codec.http.HttpResponseStatus;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class LookupReferencesManagerTest {
    private static final String LOOKUP_TIER = "lookupTier";
    @Rule
    public TemporaryFolder temporaryFolder = new TemporaryFolder();
    LookupReferencesManager lookupReferencesManager;
    LookupExtractorFactory lookupExtractorFactory;
    LookupExtractorFactoryContainer container;
    ObjectMapper mapper = new DefaultObjectMapper();
    private DruidLeaderClient druidLeaderClient;
    private LookupListeningAnnouncerConfig config;

    @Before
    public void setUp() throws IOException {
        EmittingLogger.registerEmitter((ServiceEmitter)new NoopServiceEmitter());
        this.druidLeaderClient = (DruidLeaderClient)EasyMock.createMock(DruidLeaderClient.class);
        this.config = (LookupListeningAnnouncerConfig)EasyMock.createMock(LookupListeningAnnouncerConfig.class);
        this.lookupExtractorFactory = new MapLookupExtractorFactory((Map)ImmutableMap.of((Object)"key", (Object)"value"), true);
        this.container = new LookupExtractorFactoryContainer("v0", this.lookupExtractorFactory);
        this.mapper.registerSubtypes(new Class[]{MapLookupExtractorFactory.class});
        String temporaryPath = this.temporaryFolder.newFolder().getAbsolutePath();
        this.lookupReferencesManager = new LookupReferencesManager(new LookupConfig(this.temporaryFolder.newFolder().getAbsolutePath()), this.mapper, this.druidLeaderClient, this.config, true);
    }

    private static HttpResponse newEmptyResponse() {
        HttpResponse response = (HttpResponse)EasyMock.createNiceMock(HttpResponse.class);
        EasyMock.expect((Object)response.getContent()).andReturn((Object)new BigEndianHeapChannelBuffer(0));
        EasyMock.replay((Object[])new Object[]{response});
        return response;
    }

    @Test
    public void testStartStop() throws InterruptedException, IOException {
        this.lookupReferencesManager = new LookupReferencesManager(new LookupConfig(null), this.mapper, this.druidLeaderClient, this.config);
        HashMap<String, LookupExtractorFactoryContainer> lookupMap = new HashMap<String, LookupExtractorFactoryContainer>();
        lookupMap.put("testMockForStartStop", this.container);
        String strResult = this.mapper.writeValueAsString(lookupMap);
        Request request = new Request(HttpMethod.GET, new URL("http://localhost:1234/xx"));
        EasyMock.expect((Object)this.config.getLookupTier()).andReturn((Object)LOOKUP_TIER).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.config});
        EasyMock.expect((Object)this.druidLeaderClient.makeRequest(HttpMethod.GET, "/druid/coordinator/v1/lookups/config/lookupTier?detailed=true")).andReturn((Object)request);
        StringFullResponseHolder responseHolder = new StringFullResponseHolder(HttpResponseStatus.OK, LookupReferencesManagerTest.newEmptyResponse(), StandardCharsets.UTF_8).addChunk(strResult);
        EasyMock.expect((Object)this.druidLeaderClient.go(request)).andReturn((Object)responseHolder);
        EasyMock.replay((Object[])new Object[]{this.druidLeaderClient});
        Assert.assertFalse((boolean)this.lookupReferencesManager.lifecycleLock.awaitStarted(1L, TimeUnit.MICROSECONDS));
        Assert.assertNull((Object)this.lookupReferencesManager.mainThread);
        Assert.assertNull(this.lookupReferencesManager.stateRef.get());
        this.lookupReferencesManager.start();
        Assert.assertTrue((boolean)this.lookupReferencesManager.lifecycleLock.awaitStarted(1L, TimeUnit.MICROSECONDS));
        Assert.assertTrue((boolean)this.lookupReferencesManager.mainThread.isAlive());
        Assert.assertNotNull(this.lookupReferencesManager.stateRef.get());
        this.lookupReferencesManager.stop();
        Assert.assertFalse((boolean)this.lookupReferencesManager.lifecycleLock.awaitStarted(1L, TimeUnit.MICROSECONDS));
        Assert.assertFalse((boolean)this.lookupReferencesManager.mainThread.isAlive());
    }

    @Test(expected=IllegalStateException.class)
    public void testGetExceptionWhenClosed() {
        this.lookupReferencesManager.get("test");
    }

    @Test(expected=IllegalStateException.class)
    public void testAddExceptionWhenClosed() {
        this.lookupReferencesManager.add("test", (LookupExtractorFactoryContainer)EasyMock.createMock(LookupExtractorFactoryContainer.class));
    }

    @Test(expected=IllegalStateException.class)
    public void testRemoveExceptionWhenClosed() {
        this.lookupReferencesManager.remove("test");
    }

    @Test(expected=IllegalStateException.class)
    public void testGetAllLookupsStateExceptionWhenClosed() {
        this.lookupReferencesManager.getAllLookupsState();
    }

    @Test
    public void testAddGetRemove() throws Exception {
        LookupExtractorFactory lookupExtractorFactory = (LookupExtractorFactory)EasyMock.createMock(LookupExtractorFactory.class);
        EasyMock.expect((Object)lookupExtractorFactory.start()).andReturn((Object)true).once();
        EasyMock.expect((Object)lookupExtractorFactory.destroy()).andReturn((Object)true).once();
        EasyMock.replay((Object[])new Object[]{lookupExtractorFactory});
        HashMap<String, LookupExtractorFactoryContainer> lookupMap = new HashMap<String, LookupExtractorFactoryContainer>();
        lookupMap.put("testMockForAddGetRemove", this.container);
        String strResult = this.mapper.writeValueAsString(lookupMap);
        Request request = new Request(HttpMethod.GET, new URL("http://localhost:1234/xx"));
        EasyMock.expect((Object)this.config.getLookupTier()).andReturn((Object)LOOKUP_TIER).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.config});
        EasyMock.expect((Object)this.druidLeaderClient.makeRequest(HttpMethod.GET, "/druid/coordinator/v1/lookups/config/lookupTier?detailed=true")).andReturn((Object)request);
        StringFullResponseHolder responseHolder = new StringFullResponseHolder(HttpResponseStatus.OK, LookupReferencesManagerTest.newEmptyResponse(), StandardCharsets.UTF_8).addChunk(strResult);
        EasyMock.expect((Object)this.druidLeaderClient.go(request)).andReturn((Object)responseHolder);
        EasyMock.replay((Object[])new Object[]{this.druidLeaderClient});
        this.lookupReferencesManager.start();
        Assert.assertEquals(Optional.empty(), (Object)this.lookupReferencesManager.get("test"));
        LookupExtractorFactoryContainer testContainer = new LookupExtractorFactoryContainer("0", lookupExtractorFactory);
        this.lookupReferencesManager.add("test", testContainer);
        this.lookupReferencesManager.handlePendingNotices();
        Assert.assertEquals(Optional.of(testContainer), (Object)this.lookupReferencesManager.get("test"));
        this.lookupReferencesManager.remove("test");
        this.lookupReferencesManager.handlePendingNotices();
        Assert.assertEquals(Optional.empty(), (Object)this.lookupReferencesManager.get("test"));
    }

    @Test
    public void testCloseIsCalledAfterStopping() throws Exception {
        LookupExtractorFactory lookupExtractorFactory = (LookupExtractorFactory)EasyMock.createStrictMock(LookupExtractorFactory.class);
        EasyMock.expect((Object)lookupExtractorFactory.start()).andReturn((Object)true).once();
        EasyMock.expect((Object)lookupExtractorFactory.close()).andReturn((Object)true).once();
        EasyMock.replay((Object[])new Object[]{lookupExtractorFactory});
        HashMap<String, LookupExtractorFactoryContainer> lookupMap = new HashMap<String, LookupExtractorFactoryContainer>();
        lookupMap.put("testMockForCloseIsCalledAfterStopping", this.container);
        String strResult = this.mapper.writeValueAsString(lookupMap);
        Request request = new Request(HttpMethod.GET, new URL("http://localhost:1234/xx"));
        EasyMock.expect((Object)this.config.getLookupTier()).andReturn((Object)LOOKUP_TIER).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.config});
        EasyMock.expect((Object)this.druidLeaderClient.makeRequest(HttpMethod.GET, "/druid/coordinator/v1/lookups/config/lookupTier?detailed=true")).andReturn((Object)request);
        StringFullResponseHolder responseHolder = new StringFullResponseHolder(HttpResponseStatus.OK, LookupReferencesManagerTest.newEmptyResponse(), StandardCharsets.UTF_8).addChunk(strResult);
        EasyMock.expect((Object)this.druidLeaderClient.go(request)).andReturn((Object)responseHolder);
        EasyMock.replay((Object[])new Object[]{this.druidLeaderClient});
        this.lookupReferencesManager.start();
        this.lookupReferencesManager.add("testMock", new LookupExtractorFactoryContainer("0", lookupExtractorFactory));
        this.lookupReferencesManager.handlePendingNotices();
        this.lookupReferencesManager.stop();
        EasyMock.verify((Object[])new Object[]{lookupExtractorFactory});
    }

    @Test
    public void testDestroyIsCalledAfterRemove() throws Exception {
        LookupExtractorFactory lookupExtractorFactory = (LookupExtractorFactory)EasyMock.createStrictMock(LookupExtractorFactory.class);
        EasyMock.expect((Object)lookupExtractorFactory.start()).andReturn((Object)true).once();
        EasyMock.expect((Object)lookupExtractorFactory.destroy()).andReturn((Object)true).once();
        EasyMock.replay((Object[])new Object[]{lookupExtractorFactory});
        HashMap<String, LookupExtractorFactoryContainer> lookupMap = new HashMap<String, LookupExtractorFactoryContainer>();
        lookupMap.put("testMockForDestroyIsCalledAfterRemove", this.container);
        String strResult = this.mapper.writeValueAsString(lookupMap);
        Request request = new Request(HttpMethod.GET, new URL("http://localhost:1234/xx"));
        EasyMock.expect((Object)this.config.getLookupTier()).andReturn((Object)LOOKUP_TIER).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.config});
        EasyMock.expect((Object)this.druidLeaderClient.makeRequest(HttpMethod.GET, "/druid/coordinator/v1/lookups/config/lookupTier?detailed=true")).andReturn((Object)request);
        StringFullResponseHolder responseHolder = new StringFullResponseHolder(HttpResponseStatus.OK, LookupReferencesManagerTest.newEmptyResponse(), StandardCharsets.UTF_8).addChunk(strResult);
        EasyMock.expect((Object)this.druidLeaderClient.go(request)).andReturn((Object)responseHolder);
        EasyMock.replay((Object[])new Object[]{this.druidLeaderClient});
        this.lookupReferencesManager.start();
        this.lookupReferencesManager.add("testMock", new LookupExtractorFactoryContainer("0", lookupExtractorFactory));
        this.lookupReferencesManager.handlePendingNotices();
        this.lookupReferencesManager.remove("testMock");
        this.lookupReferencesManager.handlePendingNotices();
        EasyMock.verify((Object[])new Object[]{lookupExtractorFactory});
    }

    @Test
    public void testGetNotThere() throws Exception {
        HashMap<String, LookupExtractorFactoryContainer> lookupMap = new HashMap<String, LookupExtractorFactoryContainer>();
        lookupMap.put("testMockForGetNotThere", this.container);
        String strResult = this.mapper.writeValueAsString(lookupMap);
        Request request = new Request(HttpMethod.GET, new URL("http://localhost:1234/xx"));
        EasyMock.expect((Object)this.config.getLookupTier()).andReturn((Object)LOOKUP_TIER).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.config});
        EasyMock.expect((Object)this.druidLeaderClient.makeRequest(HttpMethod.GET, "/druid/coordinator/v1/lookups/config/lookupTier?detailed=true")).andReturn((Object)request);
        StringFullResponseHolder responseHolder = new StringFullResponseHolder(HttpResponseStatus.OK, LookupReferencesManagerTest.newEmptyResponse(), StandardCharsets.UTF_8).addChunk(strResult);
        EasyMock.expect((Object)this.druidLeaderClient.go(request)).andReturn((Object)responseHolder);
        EasyMock.replay((Object[])new Object[]{this.druidLeaderClient});
        this.lookupReferencesManager.start();
        Assert.assertEquals(Optional.empty(), (Object)this.lookupReferencesManager.get("notThere"));
    }

    @Test
    public void testUpdateWithHigherVersion() throws Exception {
        LookupExtractorFactory lookupExtractorFactory1 = (LookupExtractorFactory)EasyMock.createNiceMock(LookupExtractorFactory.class);
        EasyMock.expect((Object)lookupExtractorFactory1.start()).andReturn((Object)true).once();
        EasyMock.expect((Object)lookupExtractorFactory1.destroy()).andReturn((Object)true).once();
        LookupExtractorFactory lookupExtractorFactory2 = (LookupExtractorFactory)EasyMock.createNiceMock(LookupExtractorFactory.class);
        EasyMock.expect((Object)lookupExtractorFactory2.start()).andReturn((Object)true).once();
        EasyMock.replay((Object[])new Object[]{lookupExtractorFactory1, lookupExtractorFactory2});
        HashMap<String, LookupExtractorFactoryContainer> lookupMap = new HashMap<String, LookupExtractorFactoryContainer>();
        lookupMap.put("testMockForUpdateWithHigherVersion", this.container);
        String strResult = this.mapper.writeValueAsString(lookupMap);
        Request request = new Request(HttpMethod.GET, new URL("http://localhost:1234/xx"));
        EasyMock.expect((Object)this.config.getLookupTier()).andReturn((Object)LOOKUP_TIER).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.config});
        EasyMock.expect((Object)this.druidLeaderClient.makeRequest(HttpMethod.GET, "/druid/coordinator/v1/lookups/config/lookupTier?detailed=true")).andReturn((Object)request);
        StringFullResponseHolder responseHolder = new StringFullResponseHolder(HttpResponseStatus.OK, LookupReferencesManagerTest.newEmptyResponse(), StandardCharsets.UTF_8).addChunk(strResult);
        EasyMock.expect((Object)this.druidLeaderClient.go(request)).andReturn((Object)responseHolder);
        EasyMock.replay((Object[])new Object[]{this.druidLeaderClient});
        this.lookupReferencesManager.start();
        this.lookupReferencesManager.add("testName", new LookupExtractorFactoryContainer("1", lookupExtractorFactory1));
        this.lookupReferencesManager.handlePendingNotices();
        this.lookupReferencesManager.add("testName", new LookupExtractorFactoryContainer("2", lookupExtractorFactory2));
        this.lookupReferencesManager.handlePendingNotices();
        EasyMock.verify((Object[])new Object[]{lookupExtractorFactory1, lookupExtractorFactory2});
    }

    @Test
    public void testUpdateWithLowerVersion() throws Exception {
        LookupExtractorFactory lookupExtractorFactory1 = (LookupExtractorFactory)EasyMock.createNiceMock(LookupExtractorFactory.class);
        EasyMock.expect((Object)lookupExtractorFactory1.start()).andReturn((Object)true).once();
        LookupExtractorFactory lookupExtractorFactory2 = (LookupExtractorFactory)EasyMock.createNiceMock(LookupExtractorFactory.class);
        EasyMock.replay((Object[])new Object[]{lookupExtractorFactory1, lookupExtractorFactory2});
        HashMap<String, LookupExtractorFactoryContainer> lookupMap = new HashMap<String, LookupExtractorFactoryContainer>();
        lookupMap.put("testMockForUpdateWithLowerVersion", this.container);
        String strResult = this.mapper.writeValueAsString(lookupMap);
        Request request = new Request(HttpMethod.GET, new URL("http://localhost:1234/xx"));
        EasyMock.expect((Object)this.config.getLookupTier()).andReturn((Object)LOOKUP_TIER).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.config});
        EasyMock.expect((Object)this.druidLeaderClient.makeRequest(HttpMethod.GET, "/druid/coordinator/v1/lookups/config/lookupTier?detailed=true")).andReturn((Object)request);
        StringFullResponseHolder responseHolder = new StringFullResponseHolder(HttpResponseStatus.OK, LookupReferencesManagerTest.newEmptyResponse(), StandardCharsets.UTF_8).addChunk(strResult);
        EasyMock.expect((Object)this.druidLeaderClient.go(request)).andReturn((Object)responseHolder);
        EasyMock.replay((Object[])new Object[]{this.druidLeaderClient});
        this.lookupReferencesManager.start();
        this.lookupReferencesManager.add("testName", new LookupExtractorFactoryContainer("1", lookupExtractorFactory1));
        this.lookupReferencesManager.handlePendingNotices();
        this.lookupReferencesManager.add("testName", new LookupExtractorFactoryContainer("0", lookupExtractorFactory2));
        this.lookupReferencesManager.handlePendingNotices();
        EasyMock.verify((Object[])new Object[]{lookupExtractorFactory1, lookupExtractorFactory2});
    }

    @Test
    public void testRemoveNonExisting() throws Exception {
        HashMap<String, LookupExtractorFactoryContainer> lookupMap = new HashMap<String, LookupExtractorFactoryContainer>();
        lookupMap.put("testMockForRemoveNonExisting", this.container);
        String strResult = this.mapper.writeValueAsString(lookupMap);
        Request request = new Request(HttpMethod.GET, new URL("http://localhost:1234/xx"));
        EasyMock.expect((Object)this.config.getLookupTier()).andReturn((Object)LOOKUP_TIER).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.config});
        EasyMock.expect((Object)this.druidLeaderClient.makeRequest(HttpMethod.GET, "/druid/coordinator/v1/lookups/config/lookupTier?detailed=true")).andReturn((Object)request);
        StringFullResponseHolder responseHolder = new StringFullResponseHolder(HttpResponseStatus.OK, LookupReferencesManagerTest.newEmptyResponse(), StandardCharsets.UTF_8).addChunk(strResult);
        EasyMock.expect((Object)this.druidLeaderClient.go(request)).andReturn((Object)responseHolder);
        EasyMock.replay((Object[])new Object[]{this.druidLeaderClient});
        this.lookupReferencesManager.start();
        this.lookupReferencesManager.remove("test");
        this.lookupReferencesManager.handlePendingNotices();
    }

    @Test
    public void testGetAllLookupNames() throws Exception {
        LookupExtractorFactoryContainer container1 = new LookupExtractorFactoryContainer("0", (LookupExtractorFactory)new MapLookupExtractorFactory((Map)ImmutableMap.of((Object)"key1", (Object)"value1"), true));
        LookupExtractorFactoryContainer container2 = new LookupExtractorFactoryContainer("0", (LookupExtractorFactory)new MapLookupExtractorFactory((Map)ImmutableMap.of((Object)"key2", (Object)"value2"), true));
        HashMap lookupMap = new HashMap();
        String strResult = this.mapper.writeValueAsString(lookupMap);
        Request request = new Request(HttpMethod.GET, new URL("http://localhost:1234/xx"));
        EasyMock.expect((Object)this.config.getLookupTier()).andReturn((Object)LOOKUP_TIER).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.config});
        EasyMock.expect((Object)this.druidLeaderClient.makeRequest(HttpMethod.GET, "/druid/coordinator/v1/lookups/config/lookupTier?detailed=true")).andReturn((Object)request);
        StringFullResponseHolder responseHolder = new StringFullResponseHolder(HttpResponseStatus.OK, LookupReferencesManagerTest.newEmptyResponse(), StandardCharsets.UTF_8).addChunk(strResult);
        EasyMock.expect((Object)this.druidLeaderClient.go(request)).andReturn((Object)responseHolder);
        EasyMock.replay((Object[])new Object[]{this.druidLeaderClient});
        this.lookupReferencesManager.start();
        this.lookupReferencesManager.add("one", container1);
        this.lookupReferencesManager.add("two", container2);
        this.lookupReferencesManager.handlePendingNotices();
        Assert.assertEquals((Object)ImmutableSet.of((Object)"one", (Object)"two"), (Object)this.lookupReferencesManager.getAllLookupNames());
        Assert.assertEquals((Object)ImmutableSet.of((Object)"one", (Object)"two"), (Object)this.lookupReferencesManager.getAllLookupNames());
    }

    @Test
    public void testGetAllLookupsState() throws Exception {
        LookupExtractorFactoryContainer container1 = new LookupExtractorFactoryContainer("0", (LookupExtractorFactory)new MapLookupExtractorFactory((Map)ImmutableMap.of((Object)"key1", (Object)"value1"), true));
        LookupExtractorFactoryContainer container2 = new LookupExtractorFactoryContainer("0", (LookupExtractorFactory)new MapLookupExtractorFactory((Map)ImmutableMap.of((Object)"key2", (Object)"value2"), true));
        LookupExtractorFactoryContainer container3 = new LookupExtractorFactoryContainer("0", (LookupExtractorFactory)new MapLookupExtractorFactory((Map)ImmutableMap.of((Object)"key3", (Object)"value3"), true));
        HashMap lookupMap = new HashMap();
        String strResult = this.mapper.writeValueAsString(lookupMap);
        Request request = new Request(HttpMethod.GET, new URL("http://localhost:1234/xx"));
        EasyMock.expect((Object)this.config.getLookupTier()).andReturn((Object)LOOKUP_TIER).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.config});
        EasyMock.expect((Object)this.druidLeaderClient.makeRequest(HttpMethod.GET, "/druid/coordinator/v1/lookups/config/lookupTier?detailed=true")).andReturn((Object)request);
        StringFullResponseHolder responseHolder = new StringFullResponseHolder(HttpResponseStatus.OK, LookupReferencesManagerTest.newEmptyResponse(), StandardCharsets.UTF_8).addChunk(strResult);
        EasyMock.expect((Object)this.druidLeaderClient.go(request)).andReturn((Object)responseHolder);
        EasyMock.replay((Object[])new Object[]{this.druidLeaderClient});
        this.lookupReferencesManager.start();
        this.lookupReferencesManager.add("one", container1);
        this.lookupReferencesManager.add("two", container2);
        this.lookupReferencesManager.handlePendingNotices();
        this.lookupReferencesManager.remove("one");
        this.lookupReferencesManager.add("three", container3);
        LookupsState state = this.lookupReferencesManager.getAllLookupsState();
        Assert.assertEquals((long)2L, (long)state.getCurrent().size());
        Assert.assertEquals((Object)container1, state.getCurrent().get("one"));
        Assert.assertEquals((Object)container2, state.getCurrent().get("two"));
        Assert.assertEquals((long)1L, (long)state.getToLoad().size());
        Assert.assertEquals((Object)container3, state.getToLoad().get("three"));
        Assert.assertEquals((long)1L, (long)state.getToDrop().size());
        Assert.assertTrue((boolean)state.getToDrop().contains("one"));
    }

    @Test(timeout=60000L)
    public void testRealModeWithMainThread() throws Exception {
        LookupReferencesManager lookupReferencesManager = new LookupReferencesManager(new LookupConfig(this.temporaryFolder.newFolder().getAbsolutePath()), this.mapper, this.druidLeaderClient, this.config);
        HashMap<String, LookupExtractorFactoryContainer> lookupMap = new HashMap<String, LookupExtractorFactoryContainer>();
        lookupMap.put("testMockForRealModeWithMainThread", this.container);
        String strResult = this.mapper.writeValueAsString(lookupMap);
        Request request = new Request(HttpMethod.GET, new URL("http://localhost:1234/xx"));
        EasyMock.expect((Object)this.config.getLookupTier()).andReturn((Object)LOOKUP_TIER).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.config});
        EasyMock.expect((Object)this.druidLeaderClient.makeRequest(HttpMethod.GET, "/druid/coordinator/v1/lookups/config/lookupTier?detailed=true")).andReturn((Object)request);
        StringFullResponseHolder responseHolder = new StringFullResponseHolder(HttpResponseStatus.OK, LookupReferencesManagerTest.newEmptyResponse(), StandardCharsets.UTF_8).addChunk(strResult);
        EasyMock.expect((Object)this.druidLeaderClient.go(request)).andReturn((Object)responseHolder);
        EasyMock.replay((Object[])new Object[]{this.druidLeaderClient});
        lookupReferencesManager.start();
        Assert.assertTrue((boolean)lookupReferencesManager.mainThread.isAlive());
        LookupExtractorFactory lookupExtractorFactory = (LookupExtractorFactory)EasyMock.createMock(LookupExtractorFactory.class);
        EasyMock.expect((Object)lookupExtractorFactory.start()).andReturn((Object)true).once();
        EasyMock.expect((Object)lookupExtractorFactory.destroy()).andReturn((Object)true).once();
        EasyMock.replay((Object[])new Object[]{lookupExtractorFactory});
        Assert.assertEquals(Optional.empty(), (Object)lookupReferencesManager.get("test"));
        LookupExtractorFactoryContainer testContainer = new LookupExtractorFactoryContainer("0", lookupExtractorFactory);
        lookupReferencesManager.add("test", testContainer);
        while (!Optional.of(testContainer).equals(lookupReferencesManager.get("test"))) {
            Thread.sleep(100L);
        }
        Assert.assertEquals((Object)ImmutableSet.of((Object)"test", (Object)"testMockForRealModeWithMainThread"), (Object)lookupReferencesManager.getAllLookupNames());
        lookupReferencesManager.remove("test");
        while (lookupReferencesManager.get("test").isPresent()) {
            Thread.sleep(100L);
        }
        Assert.assertEquals((Object)ImmutableSet.of((Object)"testMockForRealModeWithMainThread"), (Object)lookupReferencesManager.getAllLookupNames());
        lookupReferencesManager.stop();
        Assert.assertFalse((boolean)lookupReferencesManager.mainThread.isAlive());
    }

    @Test
    public void testCoordinatorLookupSync() throws Exception {
        LookupExtractorFactoryContainer container1 = new LookupExtractorFactoryContainer("0", (LookupExtractorFactory)new MapLookupExtractorFactory((Map)ImmutableMap.of((Object)"key1", (Object)"value1"), true));
        LookupExtractorFactoryContainer container2 = new LookupExtractorFactoryContainer("0", (LookupExtractorFactory)new MapLookupExtractorFactory((Map)ImmutableMap.of((Object)"key2", (Object)"value2"), true));
        LookupExtractorFactoryContainer container3 = new LookupExtractorFactoryContainer("0", (LookupExtractorFactory)new MapLookupExtractorFactory((Map)ImmutableMap.of((Object)"key3", (Object)"value3"), true));
        HashMap<String, LookupExtractorFactoryContainer> lookupMap = new HashMap<String, LookupExtractorFactoryContainer>();
        lookupMap.put("testLookup1", container1);
        lookupMap.put("testLookup2", container2);
        lookupMap.put("testLookup3", container3);
        String strResult = this.mapper.writeValueAsString(lookupMap);
        Request request = new Request(HttpMethod.GET, new URL("http://localhost:1234/xx"));
        EasyMock.expect((Object)this.config.getLookupTier()).andReturn((Object)LOOKUP_TIER).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.config});
        EasyMock.expect((Object)this.druidLeaderClient.makeRequest(HttpMethod.GET, "/druid/coordinator/v1/lookups/config/lookupTier?detailed=true")).andReturn((Object)request);
        StringFullResponseHolder responseHolder = new StringFullResponseHolder(HttpResponseStatus.OK, LookupReferencesManagerTest.newEmptyResponse(), StandardCharsets.UTF_8).addChunk(strResult);
        EasyMock.expect((Object)this.druidLeaderClient.go(request)).andReturn((Object)responseHolder);
        EasyMock.replay((Object[])new Object[]{this.druidLeaderClient});
        this.lookupReferencesManager.start();
        Assert.assertEquals(Optional.of(container1), (Object)this.lookupReferencesManager.get("testLookup1"));
        Assert.assertEquals(Optional.of(container2), (Object)this.lookupReferencesManager.get("testLookup2"));
        Assert.assertEquals(Optional.of(container3), (Object)this.lookupReferencesManager.get("testLookup3"));
    }

    @Test
    public void testLoadLookupOnCoordinatorFailure() throws Exception {
        LookupConfig lookupConfig = new LookupConfig(this.temporaryFolder.newFolder().getAbsolutePath()){

            public int getCoordinatorRetryDelay() {
                return 10;
            }
        };
        this.lookupReferencesManager = new LookupReferencesManager(lookupConfig, this.mapper, this.druidLeaderClient, this.config);
        Request request = new Request(HttpMethod.GET, new URL("http://localhost:1234/xx"));
        EasyMock.expect((Object)this.config.getLookupTier()).andReturn((Object)LOOKUP_TIER).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.config});
        EasyMock.expect((Object)this.druidLeaderClient.makeRequest(HttpMethod.GET, "/druid/coordinator/v1/lookups/config/lookupTier?detailed=true")).andReturn((Object)request).anyTimes();
        EasyMock.expect((Object)this.druidLeaderClient.go(request)).andThrow((Throwable)new IllegalStateException()).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.druidLeaderClient});
        this.lookupReferencesManager.start();
        this.lookupReferencesManager.add("testMockForLoadLookupOnCoordinatorFailure", this.container);
        this.lookupReferencesManager.handlePendingNotices();
        this.lookupReferencesManager.stop();
        lookupConfig = new LookupConfig(this.lookupReferencesManager.lookupSnapshotTaker.getPersistFile(LOOKUP_TIER).getParent()){

            public int getCoordinatorRetryDelay() {
                return 10;
            }
        };
        this.lookupReferencesManager = new LookupReferencesManager(lookupConfig, this.mapper, this.druidLeaderClient, this.config, true);
        EasyMock.reset((Object[])new Object[]{this.config});
        EasyMock.reset((Object[])new Object[]{this.druidLeaderClient});
        EasyMock.expect((Object)this.config.getLookupTier()).andReturn((Object)LOOKUP_TIER).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.config});
        EasyMock.expect((Object)this.druidLeaderClient.makeRequest(HttpMethod.GET, "/druid/coordinator/v1/lookups/config/lookupTier?detailed=true")).andReturn((Object)request).anyTimes();
        EasyMock.expect((Object)this.druidLeaderClient.go(request)).andThrow((Throwable)new IllegalStateException()).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.druidLeaderClient});
        this.lookupReferencesManager.start();
        Assert.assertEquals(Optional.of(this.container), (Object)this.lookupReferencesManager.get("testMockForLoadLookupOnCoordinatorFailure"));
    }

    @Test
    public void testDisableLookupSync() throws Exception {
        LookupConfig lookupConfig = new LookupConfig(null){

            public boolean getEnableLookupSyncOnStartup() {
                return false;
            }
        };
        LookupReferencesManager lookupReferencesManager = new LookupReferencesManager(lookupConfig, this.mapper, this.druidLeaderClient, this.config);
        HashMap<String, LookupExtractorFactoryContainer> lookupMap = new HashMap<String, LookupExtractorFactoryContainer>();
        lookupMap.put("testMockForDisableLookupSync", this.container);
        String strResult = this.mapper.writeValueAsString(lookupMap);
        Request request = new Request(HttpMethod.GET, new URL("http://localhost:1234/xx"));
        EasyMock.expect((Object)this.config.getLookupTier()).andReturn((Object)LOOKUP_TIER).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.config});
        EasyMock.expect((Object)this.druidLeaderClient.makeRequest(HttpMethod.GET, "/druid/coordinator/v1/lookups/config/lookupTier?detailed=true")).andReturn((Object)request);
        StringFullResponseHolder responseHolder = new StringFullResponseHolder(HttpResponseStatus.OK, LookupReferencesManagerTest.newEmptyResponse(), StandardCharsets.UTF_8).addChunk(strResult);
        EasyMock.expect((Object)this.druidLeaderClient.go(request)).andReturn((Object)responseHolder);
        lookupReferencesManager.start();
        Assert.assertEquals(Optional.empty(), (Object)lookupReferencesManager.get("testMockForDisableLookupSync"));
    }
}

