/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.lookup;

import com.fasterxml.jackson.databind.InjectableValues;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableList;
import com.google.inject.Injector;
import com.google.inject.Key;
import org.apache.druid.guice.ExpressionModule;
import org.apache.druid.guice.GuiceInjectors;
import org.apache.druid.guice.annotations.Json;
import org.apache.druid.math.expr.ExprMacroTable;
import org.apache.druid.query.dimension.DimensionSpec;
import org.apache.druid.query.dimension.ExtractionDimensionSpec;
import org.apache.druid.query.extraction.ExtractionFn;
import org.apache.druid.query.filter.DimFilter;
import org.apache.druid.query.filter.SelectorDimFilter;
import org.apache.druid.query.lookup.LookupExtractorFactoryContainerProvider;
import org.apache.druid.query.lookup.LookupSerdeModule;
import org.apache.druid.query.lookup.RegisteredLookupExtractionFn;
import org.apache.druid.segment.VirtualColumn;
import org.apache.druid.segment.column.ValueType;
import org.apache.druid.segment.transform.ExpressionTransform;
import org.apache.druid.segment.virtual.ExpressionVirtualColumn;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class LookupSerdeModuleTest {
    private Injector injector;
    private ObjectMapper objectMapper;

    @Before
    public void setUp() {
        ImmutableList modules = ImmutableList.of((Object)new ExpressionModule(), (Object)new LookupSerdeModule());
        this.injector = GuiceInjectors.makeStartupInjectorWithModules((Iterable)modules);
        this.objectMapper = (ObjectMapper)this.injector.getInstance(Key.get(ObjectMapper.class, Json.class));
        this.objectMapper.setInjectableValues((InjectableValues)new InjectableValues.Std().addValue(ExprMacroTable.class, this.injector.getInstance(ExprMacroTable.class)).addValue(LookupExtractorFactoryContainerProvider.class, this.injector.getInstance(LookupExtractorFactoryContainerProvider.class)));
        modules.stream().flatMap(module -> module.getJacksonModules().stream()).forEach(arg_0 -> ((ObjectMapper)this.objectMapper).registerModule(arg_0));
    }

    @Test
    public void testExpressionVirtualColumnSerde() throws Exception {
        ExpressionVirtualColumn virtualColumn = new ExpressionVirtualColumn("v", "lookup(xxx, 'beep')", ValueType.STRING, (ExprMacroTable)this.injector.getInstance(ExprMacroTable.class));
        Assert.assertEquals((Object)virtualColumn, (Object)this.objectMapper.readValue(this.objectMapper.writeValueAsBytes((Object)virtualColumn), VirtualColumn.class));
    }

    @Test
    public void testExtractionDimensionSerde() throws Exception {
        ExtractionDimensionSpec dimensionSpec = new ExtractionDimensionSpec("xxx", "d", (ExtractionFn)new RegisteredLookupExtractionFn(null, "beep", false, null, null, null));
        Assert.assertEquals((Object)dimensionSpec, (Object)this.objectMapper.readValue(this.objectMapper.writeValueAsBytes((Object)dimensionSpec), DimensionSpec.class));
    }

    @Test
    public void testExtractionFilterSere() throws Exception {
        SelectorDimFilter filter = new SelectorDimFilter("xxx", "d", (ExtractionFn)new RegisteredLookupExtractionFn(null, "beep", false, null, null, null));
        Assert.assertEquals((Object)filter, (Object)this.objectMapper.readValue(this.objectMapper.writeValueAsBytes((Object)filter), DimFilter.class));
    }

    @Test
    public void testExpressionTransformSerde() throws Exception {
        ExpressionTransform transform = new ExpressionTransform("xxx", "lookup(xxx, 'beep')", (ExprMacroTable)this.injector.getInstance(ExprMacroTable.class));
        Assert.assertEquals((Object)transform, (Object)this.objectMapper.readValue(this.objectMapper.writeValueAsBytes((Object)transform), ExpressionTransform.class));
    }
}

