/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.loading;

import com.google.common.collect.ImmutableList;
import com.google.common.io.FileWriteMode;
import com.google.common.io.Files;
import com.google.common.primitives.Ints;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.segment.loading.LocalDataSegmentPusher;
import org.apache.druid.segment.loading.LocalDataSegmentPusherConfig;
import org.apache.druid.timeline.DataSegment;
import org.apache.druid.timeline.partition.NoneShardSpec;
import org.apache.druid.timeline.partition.ShardSpec;
import org.apache.druid.utils.CompressionUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.rules.TemporaryFolder;

public class LocalDataSegmentPusherTest {
    @Rule
    public final TemporaryFolder temporaryFolder = new TemporaryFolder();
    @Rule
    public ExpectedException exception = ExpectedException.none();
    LocalDataSegmentPusher localDataSegmentPusher;
    LocalDataSegmentPusherConfig config;
    File dataSegmentFiles;
    DataSegment dataSegment = new DataSegment("ds", Intervals.utc((long)0L, (long)1L), "v1", null, (List)ImmutableList.of((Object)"dim1"), null, (ShardSpec)NoneShardSpec.instance(), null, 0L);
    DataSegment dataSegment2 = new DataSegment("ds", Intervals.utc((long)0L, (long)1L), "v1", null, (List)ImmutableList.of((Object)"dim2"), null, (ShardSpec)NoneShardSpec.instance(), null, 0L);

    @Before
    public void setUp() throws IOException {
        this.config = new LocalDataSegmentPusherConfig();
        this.config.storageDirectory = this.temporaryFolder.newFolder();
        this.localDataSegmentPusher = new LocalDataSegmentPusher(this.config);
        this.dataSegmentFiles = this.temporaryFolder.newFolder();
        Files.asByteSink((File)new File(this.dataSegmentFiles, "version.bin"), (FileWriteMode[])new FileWriteMode[0]).write(Ints.toByteArray((int)9));
    }

    @Test
    public void testPush() throws IOException {
        DataSegment dataSegment2 = this.dataSegment.withVersion("v2");
        DataSegment returnSegment1 = this.localDataSegmentPusher.push(this.dataSegmentFiles, this.dataSegment, false);
        DataSegment returnSegment2 = this.localDataSegmentPusher.push(this.dataSegmentFiles, dataSegment2, false);
        Assert.assertNotNull((Object)returnSegment1);
        Assert.assertEquals((Object)this.dataSegment, (Object)returnSegment1);
        Assert.assertNotNull((Object)returnSegment2);
        Assert.assertEquals((Object)dataSegment2, (Object)returnSegment2);
        Assert.assertNotEquals((Object)this.localDataSegmentPusher.getStorageDir(this.dataSegment, false), (Object)this.localDataSegmentPusher.getStorageDir(dataSegment2, false));
        for (DataSegment returnSegment : ImmutableList.of((Object)returnSegment1, (Object)returnSegment2)) {
            File outDir = new File(this.config.getStorageDirectory(), this.localDataSegmentPusher.getStorageDir(returnSegment, false));
            File versionFile = new File(outDir, "index.zip");
            Assert.assertTrue((boolean)versionFile.exists());
        }
    }

    @Test
    public void testPushUseUniquePath() throws IOException {
        DataSegment segment = this.localDataSegmentPusher.push(this.dataSegmentFiles, this.dataSegment, true);
        String path = segment.getLoadSpec().get("path").toString();
        Pattern pattern = Pattern.compile(".*/ds/1970-01-01T00:00:00\\.000Z_1970-01-01T00:00:00\\.001Z/v1/0/[A-Za-z0-9-]{36}/index\\.zip");
        Assert.assertTrue((String)path, (boolean)pattern.matcher(path).matches());
        Assert.assertTrue((boolean)new File(path).exists());
    }

    @Test
    public void testLastPushWinsForConcurrentPushes() throws IOException {
        File replicatedDataSegmentFiles = this.temporaryFolder.newFolder();
        Files.asByteSink((File)new File(replicatedDataSegmentFiles, "version.bin"), (FileWriteMode[])new FileWriteMode[0]).write(Ints.toByteArray((int)8));
        DataSegment returnSegment1 = this.localDataSegmentPusher.push(this.dataSegmentFiles, this.dataSegment, false);
        DataSegment returnSegment2 = this.localDataSegmentPusher.push(replicatedDataSegmentFiles, this.dataSegment2, false);
        Assert.assertEquals((Object)this.dataSegment.getDimensions(), (Object)returnSegment1.getDimensions());
        Assert.assertEquals((Object)this.dataSegment2.getDimensions(), (Object)returnSegment2.getDimensions());
        File unzipDir = new File(this.config.storageDirectory, "unzip");
        FileUtils.forceMkdir((File)unzipDir);
        CompressionUtils.unzip((File)new File(this.config.storageDirectory, "/ds/1970-01-01T00:00:00.000Z_1970-01-01T00:00:00.001Z/v1/0/index.zip"), (File)unzipDir);
        Assert.assertEquals((long)8L, (long)Ints.fromByteArray((byte[])Files.toByteArray((File)new File(unzipDir, "version.bin"))));
    }

    @Test
    public void testPushCannotCreateDirectory() throws IOException {
        this.exception.expect(IOException.class);
        this.exception.expectMessage("Cannot create directory");
        this.config.storageDirectory = new File(this.config.storageDirectory, "xxx");
        Assert.assertTrue((boolean)this.config.storageDirectory.mkdir());
        this.config.storageDirectory.setWritable(false);
        this.localDataSegmentPusher.push(this.dataSegmentFiles, this.dataSegment, false);
    }

    @Test
    public void testPathForHadoopAbsolute() {
        this.config.storageDirectory = new File("/druid");
        Assert.assertEquals((Object)"file:/druid", (Object)new LocalDataSegmentPusher(this.config).getPathForHadoop());
    }

    @Test
    public void testPathForHadoopRelative() {
        this.config.storageDirectory = new File("druid");
        Assert.assertEquals((Object)StringUtils.format((String)"file:%s/druid", (Object[])new Object[]{System.getProperty("user.dir")}), (Object)new LocalDataSegmentPusher(this.config).getPathForHadoop());
    }
}

