/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.realtime.appenderator;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Set;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.segment.realtime.appenderator.SegmentPublisherHelper;
import org.apache.druid.timeline.DataSegment;
import org.apache.druid.timeline.partition.BuildingHashBasedNumberedShardSpec;
import org.apache.druid.timeline.partition.BuildingNumberedShardSpec;
import org.apache.druid.timeline.partition.BuildingSingleDimensionShardSpec;
import org.apache.druid.timeline.partition.HashBasedNumberedShardSpec;
import org.apache.druid.timeline.partition.HashBucketShardSpec;
import org.apache.druid.timeline.partition.HashPartitionFunction;
import org.apache.druid.timeline.partition.NumberedOverwriteShardSpec;
import org.apache.druid.timeline.partition.NumberedShardSpec;
import org.apache.druid.timeline.partition.ShardSpec;
import org.apache.druid.timeline.partition.SingleDimensionShardSpec;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class SegmentPublisherHelperTest {
    @Rule
    public ExpectedException expectedException = ExpectedException.none();

    @Test
    public void testAnnotateAtomicUpdateGroupSize() {
        ImmutableSet segments = ImmutableSet.of((Object)SegmentPublisherHelperTest.newSegment((ShardSpec)new NumberedOverwriteShardSpec(32768, 0, 3, 1)), (Object)SegmentPublisherHelperTest.newSegment((ShardSpec)new NumberedOverwriteShardSpec(32769, 0, 3, 1)), (Object)SegmentPublisherHelperTest.newSegment((ShardSpec)new NumberedOverwriteShardSpec(32770, 0, 3, 1)));
        Set annotated = SegmentPublisherHelper.annotateShardSpec((Set)segments);
        for (DataSegment segment : annotated) {
            Assert.assertSame(NumberedOverwriteShardSpec.class, segment.getShardSpec().getClass());
            NumberedOverwriteShardSpec shardSpec = (NumberedOverwriteShardSpec)segment.getShardSpec();
            Assert.assertEquals((long)3L, (long)shardSpec.getAtomicUpdateGroupSize());
        }
    }

    @Test
    public void testAnnotateCorePartitionSetSizeForNumberedShardSpec() {
        ImmutableSet segments = ImmutableSet.of((Object)SegmentPublisherHelperTest.newSegment((ShardSpec)new BuildingNumberedShardSpec(0)), (Object)SegmentPublisherHelperTest.newSegment((ShardSpec)new BuildingNumberedShardSpec(1)), (Object)SegmentPublisherHelperTest.newSegment((ShardSpec)new BuildingNumberedShardSpec(2)));
        Set annotated = SegmentPublisherHelper.annotateShardSpec((Set)segments);
        for (DataSegment segment : annotated) {
            Assert.assertSame(NumberedShardSpec.class, segment.getShardSpec().getClass());
            NumberedShardSpec shardSpec = (NumberedShardSpec)segment.getShardSpec();
            Assert.assertEquals((long)3L, (long)shardSpec.getNumCorePartitions());
        }
    }

    @Test
    public void testAnnotateCorePartitionSetSizeForHashNumberedShardSpec() {
        ImmutableSet segments = ImmutableSet.of((Object)SegmentPublisherHelperTest.newSegment((ShardSpec)new BuildingHashBasedNumberedShardSpec(0, 0, 3, null, HashPartitionFunction.MURMUR3_32_ABS, new ObjectMapper())), (Object)SegmentPublisherHelperTest.newSegment((ShardSpec)new BuildingHashBasedNumberedShardSpec(1, 1, 3, null, HashPartitionFunction.MURMUR3_32_ABS, new ObjectMapper())), (Object)SegmentPublisherHelperTest.newSegment((ShardSpec)new BuildingHashBasedNumberedShardSpec(2, 2, 3, null, HashPartitionFunction.MURMUR3_32_ABS, new ObjectMapper())));
        Set annotated = SegmentPublisherHelper.annotateShardSpec((Set)segments);
        for (DataSegment segment : annotated) {
            Assert.assertSame(HashBasedNumberedShardSpec.class, segment.getShardSpec().getClass());
            HashBasedNumberedShardSpec shardSpec = (HashBasedNumberedShardSpec)segment.getShardSpec();
            Assert.assertEquals((long)3L, (long)shardSpec.getNumCorePartitions());
        }
    }

    @Test
    public void testAnnotateCorePartitionSetSizeForSingleDimensionShardSpec() {
        ImmutableSet segments = ImmutableSet.of((Object)SegmentPublisherHelperTest.newSegment((ShardSpec)new BuildingSingleDimensionShardSpec(0, "dim", null, "ccc", 0)), (Object)SegmentPublisherHelperTest.newSegment((ShardSpec)new BuildingSingleDimensionShardSpec(1, "dim", null, "ccc", 1)), (Object)SegmentPublisherHelperTest.newSegment((ShardSpec)new BuildingSingleDimensionShardSpec(2, "dim", null, "ccc", 2)));
        Set annotated = SegmentPublisherHelper.annotateShardSpec((Set)segments);
        for (DataSegment segment : annotated) {
            Assert.assertSame(SingleDimensionShardSpec.class, segment.getShardSpec().getClass());
            SingleDimensionShardSpec shardSpec = (SingleDimensionShardSpec)segment.getShardSpec();
            Assert.assertEquals((long)3L, (long)shardSpec.getNumCorePartitions());
        }
    }

    @Test
    public void testAnnotateShardSpecDoNothing() {
        ImmutableSet segments = ImmutableSet.of((Object)SegmentPublisherHelperTest.newSegment((ShardSpec)new NumberedShardSpec(0, 0)), (Object)SegmentPublisherHelperTest.newSegment((ShardSpec)new NumberedShardSpec(1, 0)), (Object)SegmentPublisherHelperTest.newSegment((ShardSpec)new NumberedShardSpec(2, 0)));
        Set annotated = SegmentPublisherHelper.annotateShardSpec((Set)segments);
        Assert.assertEquals((Object)segments, (Object)annotated);
    }

    @Test
    public void testAnnotateShardSpecThrowingExceptionForBucketNumberedShardSpec() {
        ImmutableSet segments = ImmutableSet.of((Object)SegmentPublisherHelperTest.newSegment((ShardSpec)new HashBucketShardSpec(0, 3, null, HashPartitionFunction.MURMUR3_32_ABS, new ObjectMapper())), (Object)SegmentPublisherHelperTest.newSegment((ShardSpec)new HashBucketShardSpec(1, 3, null, HashPartitionFunction.MURMUR3_32_ABS, new ObjectMapper())), (Object)SegmentPublisherHelperTest.newSegment((ShardSpec)new HashBucketShardSpec(2, 3, null, HashPartitionFunction.MURMUR3_32_ABS, new ObjectMapper())));
        this.expectedException.expect(IllegalStateException.class);
        this.expectedException.expectMessage("Cannot publish segments with shardSpec");
        SegmentPublisherHelper.annotateShardSpec((Set)segments);
    }

    private static DataSegment newSegment(ShardSpec shardSpec) {
        return new DataSegment("datasource", Intervals.of((String)"2020-01-01/P1d"), "version", null, (List)ImmutableList.of((Object)"dim"), (List)ImmutableList.of((Object)"met"), shardSpec, Integer.valueOf(9), 10L);
    }
}

