/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.realtime.firehose;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.io.File;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.druid.collections.spatial.search.Bound;
import org.apache.druid.collections.spatial.search.RadiusBound;
import org.apache.druid.data.input.InputRow;
import org.apache.druid.data.input.impl.DelimitedParseSpec;
import org.apache.druid.data.input.impl.DimensionsSpec;
import org.apache.druid.data.input.impl.NewSpatialDimensionSchema;
import org.apache.druid.data.input.impl.ParseSpec;
import org.apache.druid.data.input.impl.StringDimensionSchema;
import org.apache.druid.data.input.impl.StringInputRowParser;
import org.apache.druid.data.input.impl.TimestampSpec;
import org.apache.druid.hll.HyperLogLogCollector;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.aggregation.LongSumAggregatorFactory;
import org.apache.druid.query.aggregation.hyperloglog.HyperUniquesAggregatorFactory;
import org.apache.druid.query.filter.DimFilter;
import org.apache.druid.query.filter.SpatialDimFilter;
import org.apache.druid.segment.IndexIO;
import org.apache.druid.segment.IndexMerger;
import org.apache.druid.segment.IndexSpec;
import org.apache.druid.segment.QueryableIndex;
import org.apache.druid.segment.QueryableIndexStorageAdapter;
import org.apache.druid.segment.StorageAdapter;
import org.apache.druid.segment.TestHelper;
import org.apache.druid.segment.incremental.IncrementalIndex;
import org.apache.druid.segment.incremental.IncrementalIndexSchema;
import org.apache.druid.segment.incremental.IncrementalIndexStorageAdapter;
import org.apache.druid.segment.incremental.OnheapIncrementalIndex;
import org.apache.druid.segment.realtime.firehose.IngestSegmentFirehose;
import org.apache.druid.segment.realtime.firehose.WindowedStorageAdapter;
import org.apache.druid.segment.transform.TransformSpec;
import org.apache.druid.segment.writeout.OffHeapMemorySegmentWriteOutMediumFactory;
import org.apache.druid.segment.writeout.SegmentWriteOutMediumFactory;
import org.apache.druid.segment.writeout.TmpFileSegmentWriteOutMediumFactory;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class IngestSegmentFirehoseTest {
    private static final DimensionsSpec DIMENSIONS_SPEC = new DimensionsSpec((List)ImmutableList.of((Object)new StringDimensionSchema("host"), (Object)new NewSpatialDimensionSchema("spatial", (List)ImmutableList.of((Object)"x", (Object)"y"))), null, null);
    private static final DimensionsSpec DIMENSIONS_SPEC_REINDEX = new DimensionsSpec((List)ImmutableList.of((Object)new StringDimensionSchema("host"), (Object)new NewSpatialDimensionSchema("spatial", (List)ImmutableList.of((Object)"spatial"))), null, null);
    private static final List<AggregatorFactory> AGGREGATORS = ImmutableList.of((Object)new LongSumAggregatorFactory("visited_sum", "visited"), (Object)new HyperUniquesAggregatorFactory("unique_hosts", "host"));
    private static final List<AggregatorFactory> AGGREGATORS_REINDEX = ImmutableList.of((Object)new LongSumAggregatorFactory("visited_sum", "visited_sum"), (Object)new HyperUniquesAggregatorFactory("unique_hosts", "unique_hosts"));
    @Rule
    public final TemporaryFolder tempFolder = new TemporaryFolder();
    private final IndexIO indexIO = TestHelper.getTestIndexIO();
    private final IndexMerger indexMerger;

    @Parameterized.Parameters
    public static Collection<?> constructorFeeder() {
        return ImmutableList.of((Object)new Object[]{TmpFileSegmentWriteOutMediumFactory.instance()}, (Object)new Object[]{OffHeapMemorySegmentWriteOutMediumFactory.instance()});
    }

    public IngestSegmentFirehoseTest(SegmentWriteOutMediumFactory segmentWriteOutMediumFactory) {
        this.indexMerger = TestHelper.getTestIndexMergerV9((SegmentWriteOutMediumFactory)segmentWriteOutMediumFactory);
    }

    @Test
    public void testReadFromIndexAndWriteAnotherIndex() throws Exception {
        File segmentDir = this.tempFolder.newFolder();
        this.createTestIndex(segmentDir);
        try (QueryableIndex qi = this.indexIO.loadIndex(segmentDir);
             IncrementalIndex index = new OnheapIncrementalIndex.Builder().setIndexSchema(new IncrementalIndexSchema.Builder().withDimensionsSpec(DIMENSIONS_SPEC_REINDEX).withMetrics(AGGREGATORS_REINDEX.toArray(new AggregatorFactory[0])).build()).setMaxRowCount(5000).build();){
            QueryableIndexStorageAdapter sa = new QueryableIndexStorageAdapter(qi);
            WindowedStorageAdapter wsa = new WindowedStorageAdapter((StorageAdapter)sa, sa.getInterval());
            IngestSegmentFirehose firehose = new IngestSegmentFirehose((List)ImmutableList.of((Object)wsa, (Object)wsa), TransformSpec.NONE, (List)ImmutableList.of((Object)"host", (Object)"spatial"), (List)ImmutableList.of((Object)"visited_sum", (Object)"unique_hosts"), null);
            int count = 0;
            while (firehose.hasMore()) {
                InputRow row = firehose.nextRow();
                Assert.assertNotNull((Object)row);
                if (count == 0) {
                    Assert.assertEquals((Object)DateTimes.of((String)"2014-10-22T00Z"), (Object)row.getTimestamp());
                    Assert.assertEquals((Object)"host1", (Object)row.getRaw("host"));
                    Assert.assertEquals((Object)"0,1", (Object)row.getRaw("spatial"));
                    Assert.assertEquals((Object)10L, (Object)row.getRaw("visited_sum"));
                    Assert.assertEquals((double)1.0, (double)((HyperLogLogCollector)row.getRaw("unique_hosts")).estimateCardinality(), (double)0.1);
                }
                ++count;
                index.add(row);
            }
            Assert.assertEquals((long)18L, (long)count);
            Assert.assertEquals((long)9L, (long)index.size());
            IncrementalIndexStorageAdapter queryable = new IncrementalIndexStorageAdapter(index);
            Assert.assertEquals((long)2L, (long)queryable.getAvailableDimensions().size());
            Assert.assertEquals((Object)"host", (Object)queryable.getAvailableDimensions().get(0));
            Assert.assertEquals((Object)"spatial", (Object)queryable.getAvailableDimensions().get(1));
            Assert.assertEquals((Object)ImmutableList.of((Object)"visited_sum", (Object)"unique_hosts"), (Object)queryable.getAvailableMetrics());
            IngestSegmentFirehose firehose2 = new IngestSegmentFirehose((List)ImmutableList.of((Object)new WindowedStorageAdapter((StorageAdapter)queryable, Intervals.of((String)"2000/3000"))), TransformSpec.NONE, (List)ImmutableList.of((Object)"host", (Object)"spatial"), (List)ImmutableList.of((Object)"visited_sum", (Object)"unique_hosts"), (DimFilter)new SpatialDimFilter("spatial", (Bound)new RadiusBound(new float[]{1.0f, 0.0f}, 0.1f)));
            InputRow row = firehose2.nextRow();
            Assert.assertFalse((boolean)firehose2.hasMore());
            Assert.assertEquals((Object)DateTimes.of((String)"2014-10-22T00Z"), (Object)row.getTimestamp());
            Assert.assertEquals((Object)"host2", (Object)row.getRaw("host"));
            Assert.assertEquals((Object)"1,0", (Object)row.getRaw("spatial"));
            Assert.assertEquals((Object)40L, (Object)row.getRaw("visited_sum"));
            Assert.assertEquals((double)1.0, (double)((HyperLogLogCollector)row.getRaw("unique_hosts")).estimateCardinality(), (double)0.1);
        }
    }

    private void createTestIndex(File segmentDir) throws Exception {
        ArrayList rows = Lists.newArrayList((Object[])new String[]{"2014102200\thost1\t10\t0\t1", "2014102200\thost2\t20\t1\t0", "2014102200\thost3\t30\t1\t1", "2014102201\thost1\t10\t1\t1", "2014102201\thost2\t20\t1\t1", "2014102201\thost3\t30\t1\t1", "2014102202\thost1\t10\t1\t1", "2014102202\thost2\t20\t1\t1", "2014102202\thost3\t30\t1\t1"});
        StringInputRowParser parser = new StringInputRowParser((ParseSpec)new DelimitedParseSpec(new TimestampSpec("timestamp", "yyyyMMddHH", null), DIMENSIONS_SPEC, "\t", null, (List)ImmutableList.of((Object)"timestamp", (Object)"host", (Object)"visited", (Object)"x", (Object)"y", (Object)"spatial"), false, 0), StandardCharsets.UTF_8.toString());
        try (IncrementalIndex index = new OnheapIncrementalIndex.Builder().setIndexSchema(new IncrementalIndexSchema.Builder().withDimensionsSpec(parser.getParseSpec().getDimensionsSpec()).withMetrics(AGGREGATORS.toArray(new AggregatorFactory[0])).build()).setMaxRowCount(5000).build();){
            for (String line : rows) {
                index.add(parser.parse(line));
            }
            this.indexMerger.persist(index, segmentDir, new IndexSpec(), null);
        }
    }
}

