/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.realtime.firehose;

import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.apache.druid.data.input.FiniteFirehoseFactory;
import org.apache.druid.data.input.Firehose;
import org.apache.druid.data.input.InputRow;
import org.apache.druid.data.input.InputSplit;
import org.apache.druid.data.input.impl.CSVParseSpec;
import org.apache.druid.data.input.impl.DimensionsSpec;
import org.apache.druid.data.input.impl.ParseSpec;
import org.apache.druid.data.input.impl.StringInputRowParser;
import org.apache.druid.data.input.impl.TimestampSpec;
import org.apache.druid.jackson.DefaultObjectMapper;
import org.apache.druid.segment.realtime.firehose.InlineFirehoseFactory;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class InlineFirehoseFactoryTest {
    private static final String DIMENSION_0 = "timestamp";
    private static final String DIMENSION_1 = "value";
    private static final List<String> DIMENSIONS = Arrays.asList("timestamp", "value");
    private static final String DELIMITER = ",";
    private static final StringInputRowParser PARSER = new StringInputRowParser((ParseSpec)new CSVParseSpec(new TimestampSpec("timestamp", "auto", null), new DimensionsSpec(DimensionsSpec.getDefaultSchemas(DIMENSIONS), Collections.emptyList(), Collections.emptyList()), ",", DIMENSIONS, false, 0), StandardCharsets.UTF_8.name());
    private static final File NO_TEMP_DIR = null;
    private static final String TIMESTAMP = "0";
    private static final String VALUE = "a";
    private static final String DATA = "0,a";
    private InlineFirehoseFactory target;

    @Before
    public void setUp() {
        this.target = new InlineFirehoseFactory(DATA);
    }

    @Test
    public void testInterfaceImplementation() {
        Assert.assertTrue((boolean)(this.target instanceof FiniteFirehoseFactory));
        Assert.assertFalse((boolean)this.target.isSplittable());
        Assert.assertEquals((long)1L, (long)this.target.getNumSplits(null));
    }

    @Test(expected=NullPointerException.class)
    public void testContstructorDataRequired() {
        new InlineFirehoseFactory(null);
    }

    @Test
    public void testGetData() {
        Assert.assertEquals((Object)DATA, (Object)this.target.getData());
    }

    @Test
    public void testConnect() throws IOException {
        Firehose firehose = this.target.connect(PARSER, NO_TEMP_DIR);
        InputRow row = firehose.nextRow();
        Assert.assertNotNull((Object)row);
        List values = row.getDimension(DIMENSION_1);
        Assert.assertNotNull((Object)values);
        Assert.assertEquals((long)1L, (long)values.size());
        Assert.assertEquals((Object)VALUE, values.get(0));
    }

    @Test
    public void testForcedSplitAndClone() {
        Optional inputSplitOptional = this.target.getSplits(null).findFirst();
        Assert.assertTrue((boolean)inputSplitOptional.isPresent());
        FiniteFirehoseFactory cloneWithSplit = this.target.withSplit((InputSplit)inputSplitOptional.get());
        Assert.assertTrue((boolean)(cloneWithSplit instanceof InlineFirehoseFactory));
        Assert.assertEquals((Object)DATA, (Object)((InlineFirehoseFactory)cloneWithSplit).getData());
    }

    @Test
    public void testSerde() throws IOException {
        DefaultObjectMapper objectMapper = new DefaultObjectMapper();
        InlineFirehoseFactory factory = new InlineFirehoseFactory(DATA);
        String serialized = objectMapper.writeValueAsString((Object)factory);
        InlineFirehoseFactory deserialized = (InlineFirehoseFactory)objectMapper.readValue(serialized, InlineFirehoseFactory.class);
        Assert.assertEquals((Object)factory, (Object)deserialized);
    }
}

