/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.java.util.common.guava.Sequences;
import org.apache.druid.java.util.emitter.service.ServiceEmitter;
import org.apache.druid.query.DefaultQueryConfig;
import org.apache.druid.query.Druids;
import org.apache.druid.query.GenericQueryMetricsFactory;
import org.apache.druid.query.Query;
import org.apache.druid.query.QueryMetrics;
import org.apache.druid.query.QueryPlus;
import org.apache.druid.query.QueryRunner;
import org.apache.druid.query.QuerySegmentWalker;
import org.apache.druid.query.QueryToolChest;
import org.apache.druid.query.QueryToolChestWarehouse;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.aggregation.CountAggregatorFactory;
import org.apache.druid.query.context.ResponseContext;
import org.apache.druid.query.timeseries.TimeseriesQuery;
import org.apache.druid.server.QueryLifecycle;
import org.apache.druid.server.log.RequestLogger;
import org.apache.druid.server.security.Access;
import org.apache.druid.server.security.AuthenticationResult;
import org.apache.druid.server.security.Authorizer;
import org.apache.druid.server.security.AuthorizerMapper;
import org.easymock.EasyMock;
import org.junit.After;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class QueryLifecycleTest {
    private static final String DATASOURCE = "some_datasource";
    private static final String IDENTITY = "some_identity";
    private final TimeseriesQuery query = Druids.newTimeseriesQueryBuilder().dataSource("some_datasource").intervals((List)ImmutableList.of((Object)Intervals.ETERNITY)).aggregators(new AggregatorFactory[]{new CountAggregatorFactory("chocula")}).build();
    QueryToolChestWarehouse toolChestWarehouse;
    QuerySegmentWalker texasRanger;
    GenericQueryMetricsFactory metricsFactory;
    ServiceEmitter emitter;
    RequestLogger requestLogger;
    AuthorizerMapper authzMapper;
    DefaultQueryConfig queryConfig;
    QueryLifecycle lifecycle;
    QueryToolChest toolChest;
    QueryRunner runner;
    QueryMetrics metrics;
    AuthenticationResult authenticationResult;
    Authorizer authorizer;
    @Rule
    public ExpectedException expectedException = ExpectedException.none();

    @Before
    public void setup() {
        this.toolChestWarehouse = (QueryToolChestWarehouse)EasyMock.createMock(QueryToolChestWarehouse.class);
        this.texasRanger = (QuerySegmentWalker)EasyMock.createMock(QuerySegmentWalker.class);
        this.metricsFactory = (GenericQueryMetricsFactory)EasyMock.createMock(GenericQueryMetricsFactory.class);
        this.emitter = (ServiceEmitter)EasyMock.createMock(ServiceEmitter.class);
        this.requestLogger = (RequestLogger)EasyMock.createNiceMock(RequestLogger.class);
        this.authzMapper = (AuthorizerMapper)EasyMock.createMock(AuthorizerMapper.class);
        this.queryConfig = (DefaultQueryConfig)EasyMock.createMock(DefaultQueryConfig.class);
        long nanos = System.nanoTime();
        long millis = System.currentTimeMillis();
        this.lifecycle = new QueryLifecycle(this.toolChestWarehouse, this.texasRanger, this.metricsFactory, this.emitter, this.requestLogger, this.authzMapper, this.queryConfig, millis, nanos);
        this.toolChest = (QueryToolChest)EasyMock.createMock(QueryToolChest.class);
        this.runner = (QueryRunner)EasyMock.createMock(QueryRunner.class);
        this.metrics = (QueryMetrics)EasyMock.createNiceMock(QueryMetrics.class);
        this.authenticationResult = (AuthenticationResult)EasyMock.createMock(AuthenticationResult.class);
        this.authorizer = (Authorizer)EasyMock.createMock(Authorizer.class);
    }

    @After
    public void teardown() {
        EasyMock.verify((Object[])new Object[]{this.toolChestWarehouse, this.texasRanger, this.metricsFactory, this.emitter, this.requestLogger, this.authzMapper, this.queryConfig, this.toolChest, this.runner, this.metrics, this.authenticationResult, this.authorizer});
    }

    @Test
    public void testRunSimplePreauthorized() {
        EasyMock.expect((Object)this.queryConfig.getContext()).andReturn((Object)ImmutableMap.of()).anyTimes();
        EasyMock.expect((Object)this.authenticationResult.getIdentity()).andReturn((Object)IDENTITY).anyTimes();
        EasyMock.expect((Object)this.toolChestWarehouse.getToolChest((Query)EasyMock.anyObject())).andReturn((Object)this.toolChest).once();
        EasyMock.expect((Object)this.texasRanger.getQueryRunnerForIntervals((Query)EasyMock.anyObject(), (Iterable)EasyMock.anyObject())).andReturn((Object)this.runner).once();
        EasyMock.expect((Object)this.runner.run((QueryPlus)EasyMock.anyObject(), (ResponseContext)EasyMock.anyObject())).andReturn((Object)Sequences.empty()).once();
        this.replayAll();
        this.lifecycle.runSimple((Query)this.query, this.authenticationResult, Access.OK);
    }

    @Test
    public void testRunSimpleUnauthorized() {
        this.expectedException.expect(ISE.class);
        this.expectedException.expectMessage("Unauthorized");
        EasyMock.expect((Object)this.queryConfig.getContext()).andReturn((Object)ImmutableMap.of()).anyTimes();
        EasyMock.expect((Object)this.authenticationResult.getIdentity()).andReturn((Object)IDENTITY).anyTimes();
        EasyMock.expect((Object)this.toolChestWarehouse.getToolChest((Query)EasyMock.anyObject())).andReturn((Object)this.toolChest).once();
        EasyMock.expect((Object)this.toolChest.makeMetrics((Query)EasyMock.anyObject())).andReturn((Object)this.metrics).anyTimes();
        this.replayAll();
        this.lifecycle.runSimple((Query)this.query, this.authenticationResult, new Access(false));
    }

    private void replayAll() {
        EasyMock.replay((Object[])new Object[]{this.toolChestWarehouse, this.texasRanger, this.metricsFactory, this.emitter, this.requestLogger, this.authzMapper, this.queryConfig, this.toolChest, this.runner, this.metrics, this.authenticationResult, this.authorizer});
    }
}

