/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.coordinator;

import java.util.concurrent.ConcurrentHashMap;
import org.apache.druid.client.ImmutableDruidServer;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.server.coordinator.BalancerSegmentHolder;
import org.apache.druid.server.coordinator.DruidCoordinator;
import org.apache.druid.server.coordinator.DruidCoordinatorRuntimeParams;
import org.apache.druid.server.coordinator.LoadQueuePeon;
import org.apache.druid.server.coordinator.ServerHolder;
import org.apache.druid.server.coordinator.duty.BalanceSegments;
import org.apache.druid.timeline.DataSegment;
import org.apache.druid.timeline.SegmentId;

public class BalanceSegmentsTester
extends BalanceSegments {
    public BalanceSegmentsTester(DruidCoordinator coordinator) {
        super(coordinator);
    }

    protected boolean moveSegment(BalancerSegmentHolder segment, ImmutableDruidServer toServer, DruidCoordinatorRuntimeParams params) {
        String toServerName = toServer.getName();
        LoadQueuePeon toPeon = (LoadQueuePeon)params.getLoadManagementPeons().get(toServerName);
        String fromServerName = segment.getFromServer().getName();
        DataSegment segmentToMove = segment.getSegment();
        SegmentId segmentId = segmentToMove.getId();
        if (!toPeon.getSegmentsToLoad().contains(segmentToMove) && toServer.getSegment(segmentId) == null && new ServerHolder(toServer, toPeon).getAvailableSize() > segmentToMove.getSize()) {
            log.info("Moving [%s] from [%s] to [%s]", new Object[]{segmentId, fromServerName, toServerName});
            try {
                LoadQueuePeon loadPeon = (LoadQueuePeon)params.getLoadManagementPeons().get(toServerName);
                loadPeon.loadSegment(segment.getSegment(), () -> {});
                LoadQueuePeon dropPeon = (LoadQueuePeon)params.getLoadManagementPeons().get(fromServerName);
                dropPeon.markSegmentToDrop(segment.getSegment());
                ((ConcurrentHashMap)this.currentlyMovingSegments.get("normal")).put(segmentId, segment);
                return true;
            }
            catch (Exception e) {
                log.info((Throwable)e, StringUtils.format((String)"[%s] : Moving exception", (Object[])new Object[]{segmentId}), new Object[0]);
            }
        }
        return false;
    }
}

