/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.coordinator;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.util.Map;
import org.apache.druid.data.input.SegmentsSplitHintSpec;
import org.apache.druid.data.input.SplitHintSpec;
import org.apache.druid.indexer.partitions.DynamicPartitionsSpec;
import org.apache.druid.indexer.partitions.PartitionsSpec;
import org.apache.druid.jackson.DefaultObjectMapper;
import org.apache.druid.java.util.common.HumanReadableBytes;
import org.apache.druid.java.util.common.granularity.Granularities;
import org.apache.druid.segment.IndexSpec;
import org.apache.druid.segment.data.BitmapSerde;
import org.apache.druid.segment.data.BitmapSerdeFactory;
import org.apache.druid.segment.data.CompressionFactory;
import org.apache.druid.segment.data.CompressionStrategy;
import org.apache.druid.segment.writeout.SegmentWriteOutMediumFactory;
import org.apache.druid.segment.writeout.TmpFileSegmentWriteOutMediumFactory;
import org.apache.druid.server.coordinator.DataSourceCompactionConfig;
import org.apache.druid.server.coordinator.UserCompactionTaskGranularityConfig;
import org.apache.druid.server.coordinator.UserCompactionTaskIOConfig;
import org.apache.druid.server.coordinator.UserCompactionTaskQueryTuningConfig;
import org.joda.time.Duration;
import org.joda.time.Period;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class DataSourceCompactionConfigTest {
    private static final ObjectMapper OBJECT_MAPPER = new DefaultObjectMapper();
    @Rule
    public final ExpectedException expectedException = ExpectedException.none();

    @Test
    public void testSerdeBasic() throws IOException {
        DataSourceCompactionConfig config = new DataSourceCompactionConfig("dataSource", null, Long.valueOf(500L), null, new Period(3600L), null, null, null, (Map)ImmutableMap.of((Object)"key", (Object)"val"));
        String json = OBJECT_MAPPER.writeValueAsString((Object)config);
        DataSourceCompactionConfig fromJson = (DataSourceCompactionConfig)OBJECT_MAPPER.readValue(json, DataSourceCompactionConfig.class);
        Assert.assertEquals((Object)config.getDataSource(), (Object)fromJson.getDataSource());
        Assert.assertEquals((long)25L, (long)fromJson.getTaskPriority());
        Assert.assertEquals((long)config.getInputSegmentSizeBytes(), (long)fromJson.getInputSegmentSizeBytes());
        Assert.assertEquals((Object)config.getMaxRowsPerSegment(), (Object)fromJson.getMaxRowsPerSegment());
        Assert.assertEquals((Object)config.getSkipOffsetFromLatest(), (Object)fromJson.getSkipOffsetFromLatest());
        Assert.assertEquals((Object)config.getTuningConfig(), (Object)fromJson.getTuningConfig());
        Assert.assertEquals((Object)config.getTaskContext(), (Object)fromJson.getTaskContext());
        Assert.assertEquals((Object)config.getGranularitySpec(), (Object)fromJson.getGranularitySpec());
    }

    @Test
    public void testSerdeWithMaxRowsPerSegment() throws IOException {
        DataSourceCompactionConfig config = new DataSourceCompactionConfig("dataSource", null, Long.valueOf(500L), Integer.valueOf(30), new Period(3600L), null, null, null, (Map)ImmutableMap.of((Object)"key", (Object)"val"));
        String json = OBJECT_MAPPER.writeValueAsString((Object)config);
        DataSourceCompactionConfig fromJson = (DataSourceCompactionConfig)OBJECT_MAPPER.readValue(json, DataSourceCompactionConfig.class);
        Assert.assertEquals((Object)config.getDataSource(), (Object)fromJson.getDataSource());
        Assert.assertEquals((long)25L, (long)fromJson.getTaskPriority());
        Assert.assertEquals((long)config.getInputSegmentSizeBytes(), (long)fromJson.getInputSegmentSizeBytes());
        Assert.assertEquals((Object)config.getMaxRowsPerSegment(), (Object)fromJson.getMaxRowsPerSegment());
        Assert.assertEquals((Object)config.getSkipOffsetFromLatest(), (Object)fromJson.getSkipOffsetFromLatest());
        Assert.assertEquals((Object)config.getTuningConfig(), (Object)fromJson.getTuningConfig());
        Assert.assertEquals((Object)config.getTaskContext(), (Object)fromJson.getTaskContext());
    }

    @Test
    public void testSerdeWithMaxTotalRows() throws IOException {
        DataSourceCompactionConfig config = new DataSourceCompactionConfig("dataSource", null, Long.valueOf(500L), null, new Period(3600L), new UserCompactionTaskQueryTuningConfig(null, null, Long.valueOf(10000L), null, null, null, null, null, null, null, null, null, null, null, null, null, null), null, null, (Map)ImmutableMap.of((Object)"key", (Object)"val"));
        String json = OBJECT_MAPPER.writeValueAsString((Object)config);
        DataSourceCompactionConfig fromJson = (DataSourceCompactionConfig)OBJECT_MAPPER.readValue(json, DataSourceCompactionConfig.class);
        Assert.assertEquals((Object)config.getDataSource(), (Object)fromJson.getDataSource());
        Assert.assertEquals((long)25L, (long)fromJson.getTaskPriority());
        Assert.assertEquals((long)config.getInputSegmentSizeBytes(), (long)fromJson.getInputSegmentSizeBytes());
        Assert.assertEquals((Object)config.getMaxRowsPerSegment(), (Object)fromJson.getMaxRowsPerSegment());
        Assert.assertEquals((Object)config.getSkipOffsetFromLatest(), (Object)fromJson.getSkipOffsetFromLatest());
        Assert.assertEquals((Object)config.getTuningConfig(), (Object)fromJson.getTuningConfig());
        Assert.assertEquals((Object)config.getTaskContext(), (Object)fromJson.getTaskContext());
    }

    @Test
    public void testSerdeMaxTotalRowsWithMaxRowsPerSegment() throws IOException {
        DataSourceCompactionConfig config = new DataSourceCompactionConfig("dataSource", null, Long.valueOf(500L), Integer.valueOf(10000), new Period(3600L), new UserCompactionTaskQueryTuningConfig(null, null, Long.valueOf(10000L), null, null, null, null, null, null, null, null, null, null, null, null, null, null), null, null, (Map)ImmutableMap.of((Object)"key", (Object)"val"));
        String json = OBJECT_MAPPER.writeValueAsString((Object)config);
        DataSourceCompactionConfig fromJson = (DataSourceCompactionConfig)OBJECT_MAPPER.readValue(json, DataSourceCompactionConfig.class);
        Assert.assertEquals((Object)config.getDataSource(), (Object)fromJson.getDataSource());
        Assert.assertEquals((long)25L, (long)fromJson.getTaskPriority());
        Assert.assertEquals((long)config.getInputSegmentSizeBytes(), (long)fromJson.getInputSegmentSizeBytes());
        Assert.assertEquals((Object)config.getMaxRowsPerSegment(), (Object)fromJson.getMaxRowsPerSegment());
        Assert.assertEquals((Object)config.getSkipOffsetFromLatest(), (Object)fromJson.getSkipOffsetFromLatest());
        Assert.assertEquals((Object)config.getTuningConfig(), (Object)fromJson.getTuningConfig());
        Assert.assertEquals((Object)config.getTaskContext(), (Object)fromJson.getTaskContext());
    }

    @Test
    public void testSerdeUserCompactionTuningConfig() throws IOException {
        UserCompactionTaskQueryTuningConfig tuningConfig = new UserCompactionTaskQueryTuningConfig(Integer.valueOf(40000), Long.valueOf(2000L), null, (SplitHintSpec)new SegmentsSplitHintSpec(new HumanReadableBytes(100000L), null), (PartitionsSpec)new DynamicPartitionsSpec(Integer.valueOf(1000), Long.valueOf(20000L)), new IndexSpec((BitmapSerdeFactory)new BitmapSerde.DefaultBitmapSerdeFactory(), CompressionStrategy.LZ4, CompressionStrategy.LZF, CompressionFactory.LongEncodingStrategy.LONGS), new IndexSpec((BitmapSerdeFactory)new BitmapSerde.DefaultBitmapSerdeFactory(), CompressionStrategy.LZ4, CompressionStrategy.UNCOMPRESSED, CompressionFactory.LongEncodingStrategy.AUTO), Integer.valueOf(2), Long.valueOf(1000L), (SegmentWriteOutMediumFactory)TmpFileSegmentWriteOutMediumFactory.instance(), Integer.valueOf(100), Integer.valueOf(5), Long.valueOf(1000L), new Duration(3000L), Integer.valueOf(7), Integer.valueOf(1000), Integer.valueOf(100));
        String json = OBJECT_MAPPER.writeValueAsString((Object)tuningConfig);
        UserCompactionTaskQueryTuningConfig fromJson = (UserCompactionTaskQueryTuningConfig)OBJECT_MAPPER.readValue(json, UserCompactionTaskQueryTuningConfig.class);
        Assert.assertEquals((Object)tuningConfig, (Object)fromJson);
    }

    @Test
    public void testSerdeGranularitySpec() throws IOException {
        DataSourceCompactionConfig config = new DataSourceCompactionConfig("dataSource", null, Long.valueOf(500L), null, new Period(3600L), null, new UserCompactionTaskGranularityConfig(Granularities.HOUR, null), null, (Map)ImmutableMap.of((Object)"key", (Object)"val"));
        String json = OBJECT_MAPPER.writeValueAsString((Object)config);
        DataSourceCompactionConfig fromJson = (DataSourceCompactionConfig)OBJECT_MAPPER.readValue(json, DataSourceCompactionConfig.class);
        Assert.assertEquals((Object)config.getDataSource(), (Object)fromJson.getDataSource());
        Assert.assertEquals((long)25L, (long)fromJson.getTaskPriority());
        Assert.assertEquals((long)config.getInputSegmentSizeBytes(), (long)fromJson.getInputSegmentSizeBytes());
        Assert.assertEquals((Object)config.getMaxRowsPerSegment(), (Object)fromJson.getMaxRowsPerSegment());
        Assert.assertEquals((Object)config.getSkipOffsetFromLatest(), (Object)fromJson.getSkipOffsetFromLatest());
        Assert.assertEquals((Object)config.getTuningConfig(), (Object)fromJson.getTuningConfig());
        Assert.assertEquals((Object)config.getTaskContext(), (Object)fromJson.getTaskContext());
        Assert.assertEquals((Object)config.getGranularitySpec(), (Object)fromJson.getGranularitySpec());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testFailIfGranularitySpecContainsNonDefaultQueryGranularity() {
        new DataSourceCompactionConfig("dataSource", null, Long.valueOf(500L), null, new Period(3600L), null, new UserCompactionTaskGranularityConfig(Granularities.HOUR, Granularities.MONTH), null, (Map)ImmutableMap.of((Object)"key", (Object)"val"));
    }

    @Test
    public void testSerdeWithNullGranularitySpec() throws IOException {
        DataSourceCompactionConfig config = new DataSourceCompactionConfig("dataSource", null, Long.valueOf(500L), null, new Period(3600L), null, null, null, (Map)ImmutableMap.of((Object)"key", (Object)"val"));
        String json = OBJECT_MAPPER.writeValueAsString((Object)config);
        DataSourceCompactionConfig fromJson = (DataSourceCompactionConfig)OBJECT_MAPPER.readValue(json, DataSourceCompactionConfig.class);
        Assert.assertEquals((Object)config.getDataSource(), (Object)fromJson.getDataSource());
        Assert.assertEquals((long)25L, (long)fromJson.getTaskPriority());
        Assert.assertEquals((long)config.getInputSegmentSizeBytes(), (long)fromJson.getInputSegmentSizeBytes());
        Assert.assertEquals((Object)config.getMaxRowsPerSegment(), (Object)fromJson.getMaxRowsPerSegment());
        Assert.assertEquals((Object)config.getSkipOffsetFromLatest(), (Object)fromJson.getSkipOffsetFromLatest());
        Assert.assertEquals((Object)config.getTuningConfig(), (Object)fromJson.getTuningConfig());
        Assert.assertEquals((Object)config.getTaskContext(), (Object)fromJson.getTaskContext());
        Assert.assertEquals((Object)config.getGranularitySpec(), (Object)fromJson.getGranularitySpec());
    }

    @Test
    public void testSerdeGranularitySpecWithNullValues() throws IOException {
        DataSourceCompactionConfig config = new DataSourceCompactionConfig("dataSource", null, Long.valueOf(500L), null, new Period(3600L), null, new UserCompactionTaskGranularityConfig(null, null), null, (Map)ImmutableMap.of((Object)"key", (Object)"val"));
        String json = OBJECT_MAPPER.writeValueAsString((Object)config);
        DataSourceCompactionConfig fromJson = (DataSourceCompactionConfig)OBJECT_MAPPER.readValue(json, DataSourceCompactionConfig.class);
        Assert.assertEquals((Object)config.getDataSource(), (Object)fromJson.getDataSource());
        Assert.assertEquals((long)25L, (long)fromJson.getTaskPriority());
        Assert.assertEquals((long)config.getInputSegmentSizeBytes(), (long)fromJson.getInputSegmentSizeBytes());
        Assert.assertEquals((Object)config.getMaxRowsPerSegment(), (Object)fromJson.getMaxRowsPerSegment());
        Assert.assertEquals((Object)config.getSkipOffsetFromLatest(), (Object)fromJson.getSkipOffsetFromLatest());
        Assert.assertEquals((Object)config.getTuningConfig(), (Object)fromJson.getTuningConfig());
        Assert.assertEquals((Object)config.getTaskContext(), (Object)fromJson.getTaskContext());
        Assert.assertEquals((Object)config.getGranularitySpec(), (Object)fromJson.getGranularitySpec());
    }

    @Test
    public void testSerdeIOConfigWithNonNullDropExisting() throws IOException {
        DataSourceCompactionConfig config = new DataSourceCompactionConfig("dataSource", null, Long.valueOf(500L), null, new Period(3600L), null, new UserCompactionTaskGranularityConfig(Granularities.HOUR, null), new UserCompactionTaskIOConfig(Boolean.valueOf(true)), (Map)ImmutableMap.of((Object)"key", (Object)"val"));
        String json = OBJECT_MAPPER.writeValueAsString((Object)config);
        DataSourceCompactionConfig fromJson = (DataSourceCompactionConfig)OBJECT_MAPPER.readValue(json, DataSourceCompactionConfig.class);
        Assert.assertEquals((Object)config.getDataSource(), (Object)fromJson.getDataSource());
        Assert.assertEquals((long)25L, (long)fromJson.getTaskPriority());
        Assert.assertEquals((long)config.getInputSegmentSizeBytes(), (long)fromJson.getInputSegmentSizeBytes());
        Assert.assertEquals((Object)config.getMaxRowsPerSegment(), (Object)fromJson.getMaxRowsPerSegment());
        Assert.assertEquals((Object)config.getSkipOffsetFromLatest(), (Object)fromJson.getSkipOffsetFromLatest());
        Assert.assertEquals((Object)config.getTuningConfig(), (Object)fromJson.getTuningConfig());
        Assert.assertEquals((Object)config.getTaskContext(), (Object)fromJson.getTaskContext());
        Assert.assertEquals((Object)config.getGranularitySpec(), (Object)fromJson.getGranularitySpec());
        Assert.assertEquals((Object)config.getIoConfig(), (Object)fromJson.getIoConfig());
    }

    @Test
    public void testSerdeIOConfigWithNullDropExisting() throws IOException {
        DataSourceCompactionConfig config = new DataSourceCompactionConfig("dataSource", null, Long.valueOf(500L), null, new Period(3600L), null, new UserCompactionTaskGranularityConfig(Granularities.HOUR, null), new UserCompactionTaskIOConfig(null), (Map)ImmutableMap.of((Object)"key", (Object)"val"));
        String json = OBJECT_MAPPER.writeValueAsString((Object)config);
        DataSourceCompactionConfig fromJson = (DataSourceCompactionConfig)OBJECT_MAPPER.readValue(json, DataSourceCompactionConfig.class);
        Assert.assertEquals((Object)config.getDataSource(), (Object)fromJson.getDataSource());
        Assert.assertEquals((long)25L, (long)fromJson.getTaskPriority());
        Assert.assertEquals((long)config.getInputSegmentSizeBytes(), (long)fromJson.getInputSegmentSizeBytes());
        Assert.assertEquals((Object)config.getMaxRowsPerSegment(), (Object)fromJson.getMaxRowsPerSegment());
        Assert.assertEquals((Object)config.getSkipOffsetFromLatest(), (Object)fromJson.getSkipOffsetFromLatest());
        Assert.assertEquals((Object)config.getTuningConfig(), (Object)fromJson.getTuningConfig());
        Assert.assertEquals((Object)config.getTaskContext(), (Object)fromJson.getTaskContext());
        Assert.assertEquals((Object)config.getGranularitySpec(), (Object)fromJson.getGranularitySpec());
        Assert.assertEquals((Object)config.getIoConfig(), (Object)fromJson.getIoConfig());
    }
}

