/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.coordinator;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.druid.client.DruidServer;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.java.util.emitter.EmittingLogger;
import org.apache.druid.java.util.emitter.service.ServiceEmitter;
import org.apache.druid.java.util.emitter.service.ServiceEventBuilder;
import org.apache.druid.metadata.MetadataRuleManager;
import org.apache.druid.metadata.SegmentsMetadataManager;
import org.apache.druid.server.coordination.ServerType;
import org.apache.druid.server.coordinator.BalancerStrategy;
import org.apache.druid.server.coordinator.CoordinatorDynamicConfig;
import org.apache.druid.server.coordinator.CoordinatorRuntimeParamsTestHelpers;
import org.apache.druid.server.coordinator.CoordinatorStats;
import org.apache.druid.server.coordinator.CostBalancerStrategy;
import org.apache.druid.server.coordinator.CostBalancerStrategyFactory;
import org.apache.druid.server.coordinator.DruidCluster;
import org.apache.druid.server.coordinator.DruidClusterBuilder;
import org.apache.druid.server.coordinator.DruidCoordinator;
import org.apache.druid.server.coordinator.DruidCoordinatorRuntimeParams;
import org.apache.druid.server.coordinator.LoadPeonCallback;
import org.apache.druid.server.coordinator.LoadQueuePeon;
import org.apache.druid.server.coordinator.RandomBalancerStrategy;
import org.apache.druid.server.coordinator.ReplicationThrottler;
import org.apache.druid.server.coordinator.SegmentReplicantLookup;
import org.apache.druid.server.coordinator.ServerHolder;
import org.apache.druid.server.coordinator.duty.RunRules;
import org.apache.druid.server.coordinator.rules.ForeverLoadRule;
import org.apache.druid.server.coordinator.rules.IntervalDropRule;
import org.apache.druid.server.coordinator.rules.IntervalLoadRule;
import org.apache.druid.server.coordinator.rules.Rule;
import org.apache.druid.timeline.DataSegment;
import org.apache.druid.timeline.partition.NoneShardSpec;
import org.apache.druid.timeline.partition.ShardSpec;
import org.easymock.EasyMock;
import org.joda.time.DateTime;
import org.joda.time.Interval;
import org.joda.time.ReadableInstant;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class RunRulesTest {
    public static final CoordinatorDynamicConfig COORDINATOR_CONFIG_WITH_ZERO_LEADING_TIME_BEFORE_CAN_MARK_AS_UNUSED_OVERSHADOWED_SEGMENTS = CoordinatorDynamicConfig.builder().withLeadingTimeMillisBeforeCanMarkAsUnusedOvershadowedSegments(0L).build();
    private DruidCoordinator coordinator;
    private LoadQueuePeon mockPeon;
    private List<DataSegment> usedSegments;
    private RunRules ruleRunner;
    private ServiceEmitter emitter;
    private MetadataRuleManager databaseRuleManager;
    private SegmentsMetadataManager segmentsMetadataManager;

    @Before
    public void setUp() {
        this.coordinator = (DruidCoordinator)EasyMock.createMock(DruidCoordinator.class);
        this.mockPeon = (LoadQueuePeon)EasyMock.createMock(LoadQueuePeon.class);
        this.emitter = (ServiceEmitter)EasyMock.createMock(ServiceEmitter.class);
        EmittingLogger.registerEmitter((ServiceEmitter)this.emitter);
        this.databaseRuleManager = (MetadataRuleManager)EasyMock.createMock(MetadataRuleManager.class);
        this.segmentsMetadataManager = (SegmentsMetadataManager)EasyMock.createNiceMock(SegmentsMetadataManager.class);
        DateTime start = DateTimes.of((String)"2012-01-01");
        this.usedSegments = new ArrayList<DataSegment>();
        for (int i = 0; i < 24; ++i) {
            this.usedSegments.add(new DataSegment("test", new Interval((ReadableInstant)start, (ReadableInstant)start.plusHours(1)), DateTimes.nowUtc().toString(), new HashMap(), new ArrayList(), new ArrayList(), (ShardSpec)NoneShardSpec.instance(), Integer.valueOf(9), 1L));
            start = start.plusHours(1);
        }
        this.ruleRunner = new RunRules(new ReplicationThrottler(24, 1, false), this.coordinator);
    }

    @After
    public void tearDown() {
        EasyMock.verify((Object[])new Object[]{this.coordinator});
        EasyMock.verify((Object[])new Object[]{this.databaseRuleManager});
    }

    @Test
    public void testOneTierTwoReplicantsWithStrictReplicantLimit() {
        this.mockCoordinator();
        this.mockPeon.loadSegment((DataSegment)EasyMock.anyObject(), (LoadPeonCallback)EasyMock.anyObject());
        EasyMock.expectLastCall().atLeastOnce();
        this.mockEmptyPeon();
        EasyMock.expect((Object)this.databaseRuleManager.getRulesWithDefault((String)EasyMock.anyObject())).andReturn(Collections.singletonList(new IntervalLoadRule(Intervals.of((String)"2012-01-01T00:00:00.000Z/2012-01-02T00:00:00.000Z"), (Map)ImmutableMap.of((Object)"normal", (Object)2)))).atLeastOnce();
        EasyMock.replay((Object[])new Object[]{this.databaseRuleManager});
        DruidCluster druidCluster = DruidClusterBuilder.newBuilder().addTier("normal", new ServerHolder(new DruidServer("serverNorm", "hostNorm", null, 1000L, ServerType.HISTORICAL, "normal", 0).toImmutableDruidServer(), this.mockPeon), new ServerHolder(new DruidServer("serverNorm2", "hostNorm2", null, 1000L, ServerType.HISTORICAL, "normal", 0).toImmutableDruidServer(), this.mockPeon)).build();
        ListeningExecutorService exec = MoreExecutors.listeningDecorator((ExecutorService)Executors.newFixedThreadPool(1));
        CostBalancerStrategy balancerStrategy = new CostBalancerStrategyFactory().createBalancerStrategy(exec);
        DruidCoordinatorRuntimeParams params = this.makeCoordinatorRuntimeParams(druidCluster, (BalancerStrategy)balancerStrategy).withDynamicConfigs(CoordinatorDynamicConfig.builder().withMaxSegmentsToMove(5).withMaxNonPrimaryReplicantsToLoad(10).build()).build();
        DruidCoordinatorRuntimeParams afterParams = this.ruleRunner.run(params);
        CoordinatorStats stats = afterParams.getCoordinatorStats();
        Assert.assertEquals((long)34L, (long)stats.getTieredStat("assignedCount", "normal"));
        Assert.assertEquals((long)10L, (long)stats.getGlobalStat("totalNonPrimaryReplicantsLoaded"));
        exec.shutdown();
        EasyMock.verify((Object[])new Object[]{this.mockPeon});
    }

    @Test
    public void testTwoTiersTwoReplicantsWithStrictReplicantLimit() {
        this.mockCoordinator();
        this.mockPeon.loadSegment((DataSegment)EasyMock.anyObject(), (LoadPeonCallback)EasyMock.anyObject());
        EasyMock.expectLastCall().atLeastOnce();
        this.mockEmptyPeon();
        EasyMock.expect((Object)this.databaseRuleManager.getRulesWithDefault((String)EasyMock.anyObject())).andReturn(Collections.singletonList(new IntervalLoadRule(Intervals.of((String)"2012-01-01T00:00:00.000Z/2012-01-02T00:00:00.000Z"), (Map)ImmutableMap.of((Object)"hot", (Object)2, (Object)"normal", (Object)2)))).atLeastOnce();
        EasyMock.replay((Object[])new Object[]{this.databaseRuleManager});
        DruidCluster druidCluster = DruidClusterBuilder.newBuilder().addTier("hot", new ServerHolder(new DruidServer("serverHot", "hostHot", null, 1000L, ServerType.HISTORICAL, "hot", 0).toImmutableDruidServer(), this.mockPeon), new ServerHolder(new DruidServer("serverHot2", "hostHot2", null, 1000L, ServerType.HISTORICAL, "hot", 0).toImmutableDruidServer(), this.mockPeon)).addTier("normal", new ServerHolder(new DruidServer("serverNorm", "hostNorm", null, 1000L, ServerType.HISTORICAL, "normal", 0).toImmutableDruidServer(), this.mockPeon), new ServerHolder(new DruidServer("serverNorm2", "hostNorm2", null, 1000L, ServerType.HISTORICAL, "normal", 0).toImmutableDruidServer(), this.mockPeon)).build();
        ListeningExecutorService exec = MoreExecutors.listeningDecorator((ExecutorService)Executors.newFixedThreadPool(1));
        CostBalancerStrategy balancerStrategy = new CostBalancerStrategyFactory().createBalancerStrategy(exec);
        DruidCoordinatorRuntimeParams params = this.makeCoordinatorRuntimeParams(druidCluster, (BalancerStrategy)balancerStrategy).withDynamicConfigs(CoordinatorDynamicConfig.builder().withMaxSegmentsToMove(5).withMaxNonPrimaryReplicantsToLoad(48).build()).build();
        DruidCoordinatorRuntimeParams afterParams = this.ruleRunner.run(params);
        CoordinatorStats stats = afterParams.getCoordinatorStats();
        Assert.assertEquals((long)72L, (long)(stats.getTieredStat("assignedCount", "hot") + stats.getTieredStat("assignedCount", "normal")));
        Assert.assertEquals((long)48L, (long)stats.getGlobalStat("totalNonPrimaryReplicantsLoaded"));
        exec.shutdown();
        EasyMock.verify((Object[])new Object[]{this.mockPeon});
    }

    @Test
    public void testRunThreeTiersOneReplicant() {
        this.mockCoordinator();
        this.mockPeon.loadSegment((DataSegment)EasyMock.anyObject(), (LoadPeonCallback)EasyMock.anyObject());
        EasyMock.expectLastCall().atLeastOnce();
        this.mockEmptyPeon();
        EasyMock.expect((Object)this.databaseRuleManager.getRulesWithDefault((String)EasyMock.anyObject())).andReturn((Object)Lists.newArrayList((Object[])new Rule[]{new IntervalLoadRule(Intervals.of((String)"2012-01-01T00:00:00.000Z/2012-01-01T06:00:00.000Z"), (Map)ImmutableMap.of((Object)"hot", (Object)1)), new IntervalLoadRule(Intervals.of((String)"2012-01-01T00:00:00.000Z/2012-01-01T12:00:00.000Z"), (Map)ImmutableMap.of((Object)"normal", (Object)1)), new IntervalLoadRule(Intervals.of((String)"2012-01-01T00:00:00.000Z/2012-01-02T00:00:00.000Z"), (Map)ImmutableMap.of((Object)"cold", (Object)1))})).atLeastOnce();
        EasyMock.replay((Object[])new Object[]{this.databaseRuleManager});
        DruidCluster druidCluster = DruidClusterBuilder.newBuilder().addTier("hot", new ServerHolder(new DruidServer("serverHot", "hostHot", null, 1000L, ServerType.HISTORICAL, "hot", 0).toImmutableDruidServer(), this.mockPeon)).addTier("normal", new ServerHolder(new DruidServer("serverNorm", "hostNorm", null, 1000L, ServerType.HISTORICAL, "normal", 0).toImmutableDruidServer(), this.mockPeon)).addTier("cold", new ServerHolder(new DruidServer("serverCold", "hostCold", null, 1000L, ServerType.HISTORICAL, "cold", 0).toImmutableDruidServer(), this.mockPeon)).build();
        ListeningExecutorService exec = MoreExecutors.listeningDecorator((ExecutorService)Executors.newFixedThreadPool(1));
        CostBalancerStrategy balancerStrategy = new CostBalancerStrategyFactory().createBalancerStrategy(exec);
        DruidCoordinatorRuntimeParams params = this.makeCoordinatorRuntimeParams(druidCluster, (BalancerStrategy)balancerStrategy).withDynamicConfigs(CoordinatorDynamicConfig.builder().withMaxSegmentsToMove(5).build()).build();
        DruidCoordinatorRuntimeParams afterParams = this.ruleRunner.run(params);
        CoordinatorStats stats = afterParams.getCoordinatorStats();
        Assert.assertEquals((long)6L, (long)stats.getTieredStat("assignedCount", "hot"));
        Assert.assertEquals((long)6L, (long)stats.getTieredStat("assignedCount", "normal"));
        Assert.assertEquals((long)12L, (long)stats.getTieredStat("assignedCount", "cold"));
        Assert.assertTrue((boolean)stats.getTiers("unassignedCount").isEmpty());
        Assert.assertTrue((boolean)stats.getTiers("unassignedSize").isEmpty());
        exec.shutdown();
        EasyMock.verify((Object[])new Object[]{this.mockPeon});
    }

    private DruidCoordinatorRuntimeParams.Builder makeCoordinatorRuntimeParams(DruidCluster druidCluster, BalancerStrategy balancerStrategy) {
        return this.makeCoordinatorRuntimeParams(druidCluster, balancerStrategy, this.usedSegments);
    }

    private DruidCoordinatorRuntimeParams.Builder makeCoordinatorRuntimeParams(DruidCluster druidCluster, BalancerStrategy balancerStrategy, List<DataSegment> dataSegments) {
        return this.createCoordinatorRuntimeParams(druidCluster, dataSegments).withSegmentReplicantLookup(SegmentReplicantLookup.make((DruidCluster)druidCluster, (boolean)false)).withBalancerStrategy(balancerStrategy);
    }

    private DruidCoordinatorRuntimeParams.Builder createCoordinatorRuntimeParams(DruidCluster druidCluster) {
        return this.createCoordinatorRuntimeParams(druidCluster, this.usedSegments);
    }

    private DruidCoordinatorRuntimeParams.Builder createCoordinatorRuntimeParams(DruidCluster druidCluster, List<DataSegment> dataSegments) {
        return CoordinatorRuntimeParamsTestHelpers.newBuilder().withDruidCluster(druidCluster).withUsedSegmentsInTest(dataSegments).withDatabaseRuleManager(this.databaseRuleManager);
    }

    @Test
    public void testRunTwoTiersTwoReplicants() {
        this.mockCoordinator();
        this.mockPeon.loadSegment((DataSegment)EasyMock.anyObject(), (LoadPeonCallback)EasyMock.anyObject());
        EasyMock.expectLastCall().atLeastOnce();
        this.mockEmptyPeon();
        EasyMock.expect((Object)this.databaseRuleManager.getRulesWithDefault((String)EasyMock.anyObject())).andReturn((Object)Lists.newArrayList((Object[])new Rule[]{new IntervalLoadRule(Intervals.of((String)"2012-01-01T00:00:00.000Z/2012-01-01T06:00:00.000Z"), (Map)ImmutableMap.of((Object)"hot", (Object)2)), new IntervalLoadRule(Intervals.of((String)"2012-01-01T00:00:00.000Z/2012-01-02T00:00:00.000Z"), (Map)ImmutableMap.of((Object)"cold", (Object)1))})).atLeastOnce();
        EasyMock.replay((Object[])new Object[]{this.databaseRuleManager});
        DruidCluster druidCluster = DruidClusterBuilder.newBuilder().addTier("hot", new ServerHolder(new DruidServer("serverHot", "hostHot", null, 1000L, ServerType.HISTORICAL, "hot", 0).toImmutableDruidServer(), this.mockPeon), new ServerHolder(new DruidServer("serverHot2", "hostHot2", null, 1000L, ServerType.HISTORICAL, "hot", 0).toImmutableDruidServer(), this.mockPeon)).addTier("cold", new ServerHolder(new DruidServer("serverCold", "hostCold", null, 1000L, ServerType.HISTORICAL, "cold", 0).toImmutableDruidServer(), this.mockPeon)).build();
        ListeningExecutorService exec = MoreExecutors.listeningDecorator((ExecutorService)Executors.newFixedThreadPool(1));
        CostBalancerStrategy balancerStrategy = new CostBalancerStrategyFactory().createBalancerStrategy(exec);
        DruidCoordinatorRuntimeParams params = this.makeCoordinatorRuntimeParams(druidCluster, (BalancerStrategy)balancerStrategy).build();
        DruidCoordinatorRuntimeParams afterParams = this.ruleRunner.run(params);
        CoordinatorStats stats = afterParams.getCoordinatorStats();
        Assert.assertEquals((long)12L, (long)stats.getTieredStat("assignedCount", "hot"));
        Assert.assertEquals((long)18L, (long)stats.getTieredStat("assignedCount", "cold"));
        Assert.assertTrue((boolean)stats.getTiers("unassignedCount").isEmpty());
        Assert.assertTrue((boolean)stats.getTiers("unassignedSize").isEmpty());
        exec.shutdown();
        EasyMock.verify((Object[])new Object[]{this.mockPeon});
    }

    @Test
    public void testRunTwoTiersWithExistingSegments() {
        this.mockCoordinator();
        this.mockPeon.loadSegment((DataSegment)EasyMock.anyObject(), (LoadPeonCallback)EasyMock.anyObject());
        EasyMock.expectLastCall().atLeastOnce();
        this.mockEmptyPeon();
        EasyMock.expect((Object)this.databaseRuleManager.getRulesWithDefault((String)EasyMock.anyObject())).andReturn((Object)Lists.newArrayList((Object[])new Rule[]{new IntervalLoadRule(Intervals.of((String)"2012-01-01T00:00:00.000Z/2012-01-01T12:00:00.000Z"), (Map)ImmutableMap.of((Object)"hot", (Object)1)), new IntervalLoadRule(Intervals.of((String)"2012-01-01T00:00:00.000Z/2012-01-02T00:00:00.000Z"), (Map)ImmutableMap.of((Object)"normal", (Object)1))})).atLeastOnce();
        EasyMock.replay((Object[])new Object[]{this.databaseRuleManager});
        DruidServer normServer = new DruidServer("serverNorm", "hostNorm", null, 1000L, ServerType.HISTORICAL, "normal", 0);
        for (DataSegment segment : this.usedSegments) {
            normServer.addDataSegment(segment);
        }
        DruidCluster druidCluster = DruidClusterBuilder.newBuilder().addTier("hot", new ServerHolder(new DruidServer("serverHot", "hostHot", null, 1000L, ServerType.HISTORICAL, "hot", 0).toImmutableDruidServer(), this.mockPeon)).addTier("normal", new ServerHolder(normServer.toImmutableDruidServer(), this.mockPeon)).build();
        SegmentReplicantLookup segmentReplicantLookup = SegmentReplicantLookup.make((DruidCluster)druidCluster, (boolean)false);
        ListeningExecutorService exec = MoreExecutors.listeningDecorator((ExecutorService)Executors.newFixedThreadPool(1));
        CostBalancerStrategy balancerStrategy = new CostBalancerStrategyFactory().createBalancerStrategy(exec);
        DruidCoordinatorRuntimeParams params = this.createCoordinatorRuntimeParams(druidCluster).withSegmentReplicantLookup(segmentReplicantLookup).withBalancerStrategy((BalancerStrategy)balancerStrategy).build();
        DruidCoordinatorRuntimeParams afterParams = this.ruleRunner.run(params);
        CoordinatorStats stats = afterParams.getCoordinatorStats();
        Assert.assertEquals((long)12L, (long)stats.getTieredStat("assignedCount", "hot"));
        Assert.assertEquals((long)0L, (long)stats.getTieredStat("assignedCount", "normal"));
        Assert.assertTrue((boolean)stats.getTiers("unassignedCount").isEmpty());
        Assert.assertTrue((boolean)stats.getTiers("unassignedSize").isEmpty());
        exec.shutdown();
        EasyMock.verify((Object[])new Object[]{this.mockPeon});
    }

    @Test
    public void testRunTwoTiersTierDoesNotExist() {
        this.mockCoordinator();
        this.mockPeon.loadSegment((DataSegment)EasyMock.anyObject(), (LoadPeonCallback)EasyMock.anyObject());
        EasyMock.expectLastCall().atLeastOnce();
        this.mockEmptyPeon();
        this.emitter.emit((ServiceEventBuilder)EasyMock.anyObject());
        EasyMock.expectLastCall().times(12);
        EasyMock.replay((Object[])new Object[]{this.emitter});
        EasyMock.expect((Object)this.databaseRuleManager.getRulesWithDefault((String)EasyMock.anyObject())).andReturn((Object)Lists.newArrayList((Object[])new Rule[]{new IntervalLoadRule(Intervals.of((String)"2012-01-01T00:00:00.000Z/2012-01-01T12:00:00.000Z"), (Map)ImmutableMap.of((Object)"hot", (Object)1)), new IntervalLoadRule(Intervals.of((String)"2012-01-01T00:00:00.000Z/2012-01-02T00:00:00.000Z"), (Map)ImmutableMap.of((Object)"normal", (Object)1))})).atLeastOnce();
        EasyMock.replay((Object[])new Object[]{this.databaseRuleManager});
        DruidCluster druidCluster = DruidClusterBuilder.newBuilder().addTier("normal", new ServerHolder(new DruidServer("serverNorm", "hostNorm", null, 1000L, ServerType.HISTORICAL, "normal", 0).toImmutableDruidServer(), this.mockPeon)).build();
        ListeningExecutorService exec = MoreExecutors.listeningDecorator((ExecutorService)Executors.newFixedThreadPool(1));
        CostBalancerStrategy balancerStrategy = new CostBalancerStrategyFactory().createBalancerStrategy(exec);
        DruidCoordinatorRuntimeParams params = this.makeCoordinatorRuntimeParams(druidCluster, (BalancerStrategy)balancerStrategy).withEmitter(this.emitter).build();
        this.ruleRunner.run(params);
        exec.shutdown();
        EasyMock.verify((Object[])new Object[]{this.emitter});
        EasyMock.verify((Object[])new Object[]{this.mockPeon});
    }

    @Test
    public void testRunRuleDoesNotExist() {
        this.mockCoordinator();
        this.emitter.emit((ServiceEventBuilder)EasyMock.anyObject());
        EasyMock.expectLastCall().times(1);
        EasyMock.replay((Object[])new Object[]{this.emitter});
        EasyMock.expect((Object)this.databaseRuleManager.getRulesWithDefault((String)EasyMock.anyObject())).andReturn(Collections.singletonList(new IntervalLoadRule(Intervals.of((String)"2012-01-02T00:00:00.000Z/2012-01-03T00:00:00.000Z"), (Map)ImmutableMap.of((Object)"normal", (Object)1)))).atLeastOnce();
        EasyMock.expect((Object)this.mockPeon.getLoadQueueSize()).andReturn((Object)0L).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.databaseRuleManager, this.mockPeon});
        DruidCluster druidCluster = DruidClusterBuilder.newBuilder().addTier("normal", new ServerHolder(new DruidServer("serverNorm", "hostNorm", null, 1000L, ServerType.HISTORICAL, "normal", 0).toImmutableDruidServer(), this.mockPeon)).build();
        DruidCoordinatorRuntimeParams params = this.createCoordinatorRuntimeParams(druidCluster).withSegmentReplicantLookup(SegmentReplicantLookup.make((DruidCluster)new DruidCluster(), (boolean)false)).withEmitter(this.emitter).build();
        this.ruleRunner.run(params);
        EasyMock.verify((Object[])new Object[]{this.emitter, this.mockPeon});
    }

    @Test
    public void testDropRemove() {
        this.mockPeon.dropSegment((DataSegment)EasyMock.anyObject(), (LoadPeonCallback)EasyMock.anyObject());
        EasyMock.expectLastCall().atLeastOnce();
        this.mockEmptyPeon();
        EasyMock.expect((Object)this.coordinator.getDynamicConfigs()).andReturn((Object)this.createCoordinatorDynamicConfig()).anyTimes();
        this.coordinator.markSegmentAsUnused((DataSegment)EasyMock.anyObject());
        EasyMock.expectLastCall().atLeastOnce();
        EasyMock.replay((Object[])new Object[]{this.coordinator});
        EasyMock.expect((Object)this.databaseRuleManager.getRulesWithDefault((String)EasyMock.anyObject())).andReturn((Object)Lists.newArrayList((Object[])new Rule[]{new IntervalLoadRule(Intervals.of((String)"2012-01-01T00:00:00.000Z/2012-01-01T12:00:00.000Z"), (Map)ImmutableMap.of((Object)"normal", (Object)1)), new IntervalDropRule(Intervals.of((String)"2012-01-01T00:00:00.000Z/2012-01-02T00:00:00.000Z"))})).atLeastOnce();
        EasyMock.replay((Object[])new Object[]{this.databaseRuleManager});
        DruidServer server = new DruidServer("serverNorm", "hostNorm", null, 1000L, ServerType.HISTORICAL, "normal", 0);
        for (DataSegment segment : this.usedSegments) {
            server.addDataSegment(segment);
        }
        DruidCluster druidCluster = DruidClusterBuilder.newBuilder().addTier("normal", new ServerHolder(server.toImmutableDruidServer(), this.mockPeon)).build();
        SegmentReplicantLookup segmentReplicantLookup = SegmentReplicantLookup.make((DruidCluster)druidCluster, (boolean)false);
        ListeningExecutorService exec = MoreExecutors.listeningDecorator((ExecutorService)Executors.newFixedThreadPool(1));
        CostBalancerStrategy balancerStrategy = new CostBalancerStrategyFactory().createBalancerStrategy(exec);
        DruidCoordinatorRuntimeParams params = this.createCoordinatorRuntimeParams(druidCluster).withDynamicConfigs(COORDINATOR_CONFIG_WITH_ZERO_LEADING_TIME_BEFORE_CAN_MARK_AS_UNUSED_OVERSHADOWED_SEGMENTS).withSegmentReplicantLookup(segmentReplicantLookup).withBalancerStrategy((BalancerStrategy)balancerStrategy).build();
        DruidCoordinatorRuntimeParams afterParams = this.ruleRunner.run(params);
        CoordinatorStats stats = afterParams.getCoordinatorStats();
        Assert.assertEquals((long)12L, (long)stats.getGlobalStat("deletedCount"));
        exec.shutdown();
        EasyMock.verify((Object[])new Object[]{this.coordinator});
    }

    @Test
    public void testDropTooManyInSameTier() {
        this.mockCoordinator();
        this.mockPeon.dropSegment((DataSegment)EasyMock.anyObject(), (LoadPeonCallback)EasyMock.anyObject());
        EasyMock.expectLastCall().atLeastOnce();
        this.mockEmptyPeon();
        EasyMock.expect((Object)this.databaseRuleManager.getRulesWithDefault((String)EasyMock.anyObject())).andReturn((Object)Lists.newArrayList((Object[])new Rule[]{new IntervalLoadRule(Intervals.of((String)"2012-01-01T00:00:00.000Z/2012-01-01T12:00:00.000Z"), (Map)ImmutableMap.of((Object)"normal", (Object)1)), new IntervalDropRule(Intervals.of((String)"2012-01-01T00:00:00.000Z/2012-01-02T00:00:00.000Z"))})).atLeastOnce();
        EasyMock.replay((Object[])new Object[]{this.databaseRuleManager});
        DruidServer server1 = new DruidServer("serverNorm", "hostNorm", null, 1000L, ServerType.HISTORICAL, "normal", 0);
        server1.addDataSegment(this.usedSegments.get(0));
        DruidServer server2 = new DruidServer("serverNorm2", "hostNorm2", null, 1000L, ServerType.HISTORICAL, "normal", 0);
        for (DataSegment segment : this.usedSegments) {
            server2.addDataSegment(segment);
        }
        DruidCluster druidCluster = DruidClusterBuilder.newBuilder().addTier("normal", new ServerHolder(server1.toImmutableDruidServer(), this.mockPeon), new ServerHolder(server2.toImmutableDruidServer(), this.mockPeon)).build();
        SegmentReplicantLookup segmentReplicantLookup = SegmentReplicantLookup.make((DruidCluster)druidCluster, (boolean)false);
        ListeningExecutorService exec = MoreExecutors.listeningDecorator((ExecutorService)Executors.newFixedThreadPool(1));
        CostBalancerStrategy balancerStrategy = new CostBalancerStrategyFactory().createBalancerStrategy(exec);
        DruidCoordinatorRuntimeParams params = this.createCoordinatorRuntimeParams(druidCluster).withDynamicConfigs(CoordinatorDynamicConfig.builder().withLeadingTimeMillisBeforeCanMarkAsUnusedOvershadowedSegments(0L).build()).withSegmentReplicantLookup(segmentReplicantLookup).withBalancerStrategy((BalancerStrategy)balancerStrategy).build();
        DruidCoordinatorRuntimeParams afterParams = this.ruleRunner.run(params);
        CoordinatorStats stats = afterParams.getCoordinatorStats();
        Assert.assertEquals((long)1L, (long)stats.getTieredStat("droppedCount", "normal"));
        Assert.assertEquals((long)12L, (long)stats.getGlobalStat("deletedCount"));
        exec.shutdown();
        EasyMock.verify((Object[])new Object[]{this.mockPeon});
    }

    @Test
    public void testDropTooManyInDifferentTiers() {
        this.mockCoordinator();
        this.mockPeon.loadSegment((DataSegment)EasyMock.anyObject(), (LoadPeonCallback)EasyMock.anyObject());
        EasyMock.expectLastCall().atLeastOnce();
        this.mockPeon.dropSegment((DataSegment)EasyMock.anyObject(), (LoadPeonCallback)EasyMock.anyObject());
        EasyMock.expectLastCall().atLeastOnce();
        this.mockEmptyPeon();
        EasyMock.expect((Object)this.databaseRuleManager.getRulesWithDefault((String)EasyMock.anyObject())).andReturn((Object)Lists.newArrayList((Object[])new Rule[]{new IntervalLoadRule(Intervals.of((String)"2012-01-01T00:00:00.000Z/2012-01-01T12:00:00.000Z"), (Map)ImmutableMap.of((Object)"hot", (Object)1)), new IntervalDropRule(Intervals.of((String)"2012-01-01T00:00:00.000Z/2012-01-02T00:00:00.000Z"))})).atLeastOnce();
        EasyMock.replay((Object[])new Object[]{this.databaseRuleManager});
        DruidServer server1 = new DruidServer("server1", "host1", null, 1000L, ServerType.HISTORICAL, "hot", 0);
        server1.addDataSegment(this.usedSegments.get(0));
        DruidServer server2 = new DruidServer("serverNorm2", "hostNorm2", null, 1000L, ServerType.HISTORICAL, "normal", 0);
        for (DataSegment segment : this.usedSegments) {
            server2.addDataSegment(segment);
        }
        DruidCluster druidCluster = DruidClusterBuilder.newBuilder().addTier("hot", new ServerHolder(server1.toImmutableDruidServer(), this.mockPeon)).addTier("normal", new ServerHolder(server2.toImmutableDruidServer(), this.mockPeon)).build();
        SegmentReplicantLookup segmentReplicantLookup = SegmentReplicantLookup.make((DruidCluster)druidCluster, (boolean)false);
        ListeningExecutorService exec = MoreExecutors.listeningDecorator((ExecutorService)Executors.newFixedThreadPool(1));
        CostBalancerStrategy balancerStrategy = new CostBalancerStrategyFactory().createBalancerStrategy(exec);
        DruidCoordinatorRuntimeParams params = this.createCoordinatorRuntimeParams(druidCluster).withDynamicConfigs(COORDINATOR_CONFIG_WITH_ZERO_LEADING_TIME_BEFORE_CAN_MARK_AS_UNUSED_OVERSHADOWED_SEGMENTS).withSegmentReplicantLookup(segmentReplicantLookup).withBalancerStrategy((BalancerStrategy)balancerStrategy).build();
        DruidCoordinatorRuntimeParams afterParams = this.ruleRunner.run(params);
        CoordinatorStats stats = afterParams.getCoordinatorStats();
        Assert.assertEquals((long)1L, (long)stats.getTieredStat("droppedCount", "normal"));
        Assert.assertEquals((long)12L, (long)stats.getGlobalStat("deletedCount"));
        exec.shutdown();
        EasyMock.verify((Object[])new Object[]{this.mockPeon});
    }

    @Test
    public void testDontDropInDifferentTiers() {
        this.mockCoordinator();
        this.mockPeon.loadSegment((DataSegment)EasyMock.anyObject(), (LoadPeonCallback)EasyMock.anyObject());
        EasyMock.expectLastCall().atLeastOnce();
        this.mockEmptyPeon();
        EasyMock.expect((Object)this.databaseRuleManager.getRulesWithDefault((String)EasyMock.anyObject())).andReturn((Object)Lists.newArrayList((Object[])new Rule[]{new IntervalLoadRule(Intervals.of((String)"2012-01-01T00:00:00.000Z/2012-01-01T12:00:00.000Z"), (Map)ImmutableMap.of((Object)"hot", (Object)1)), new IntervalDropRule(Intervals.of((String)"2012-01-01T00:00:00.000Z/2012-01-02T00:00:00.000Z"))})).atLeastOnce();
        EasyMock.replay((Object[])new Object[]{this.databaseRuleManager});
        DruidServer server1 = new DruidServer("server1", "host1", null, 1000L, ServerType.HISTORICAL, "hot", 0);
        DruidServer server2 = new DruidServer("serverNorm2", "hostNorm2", null, 1000L, ServerType.HISTORICAL, "normal", 0);
        for (DataSegment segment : this.usedSegments) {
            server2.addDataSegment(segment);
        }
        DruidCluster druidCluster = DruidClusterBuilder.newBuilder().addTier("hot", new ServerHolder(server1.toImmutableDruidServer(), this.mockPeon)).addTier("normal", new ServerHolder(server2.toImmutableDruidServer(), this.mockPeon)).build();
        SegmentReplicantLookup segmentReplicantLookup = SegmentReplicantLookup.make((DruidCluster)druidCluster, (boolean)false);
        ListeningExecutorService exec = MoreExecutors.listeningDecorator((ExecutorService)Executors.newFixedThreadPool(1));
        CostBalancerStrategy balancerStrategy = new CostBalancerStrategyFactory().createBalancerStrategy(exec);
        DruidCoordinatorRuntimeParams params = this.createCoordinatorRuntimeParams(druidCluster).withDynamicConfigs(COORDINATOR_CONFIG_WITH_ZERO_LEADING_TIME_BEFORE_CAN_MARK_AS_UNUSED_OVERSHADOWED_SEGMENTS).withSegmentReplicantLookup(segmentReplicantLookup).withBalancerStrategy((BalancerStrategy)balancerStrategy).build();
        DruidCoordinatorRuntimeParams afterParams = this.ruleRunner.run(params);
        CoordinatorStats stats = afterParams.getCoordinatorStats();
        Assert.assertTrue((boolean)stats.getTiers("droppedCount").isEmpty());
        Assert.assertEquals((long)12L, (long)stats.getGlobalStat("deletedCount"));
        exec.shutdown();
        EasyMock.verify((Object[])new Object[]{this.mockPeon});
    }

    @Test
    public void testDropServerActuallyServesSegment() {
        this.mockCoordinator();
        EasyMock.expect((Object)this.databaseRuleManager.getRulesWithDefault((String)EasyMock.anyObject())).andReturn(Collections.singletonList(new IntervalLoadRule(Intervals.of((String)"2012-01-01T00:00:00.000Z/2012-01-01T01:00:00.000Z"), (Map)ImmutableMap.of((Object)"normal", (Object)0)))).atLeastOnce();
        EasyMock.replay((Object[])new Object[]{this.databaseRuleManager});
        DruidServer server1 = new DruidServer("server1", "host1", null, 1000L, ServerType.HISTORICAL, "normal", 0);
        server1.addDataSegment(this.usedSegments.get(0));
        DruidServer server2 = new DruidServer("serverNorm2", "hostNorm2", null, 1000L, ServerType.HISTORICAL, "normal", 0);
        server2.addDataSegment(this.usedSegments.get(1));
        DruidServer server3 = new DruidServer("serverNorm3", "hostNorm3", null, 1000L, ServerType.HISTORICAL, "normal", 0);
        server3.addDataSegment(this.usedSegments.get(1));
        server3.addDataSegment(this.usedSegments.get(2));
        this.mockPeon.dropSegment((DataSegment)EasyMock.anyObject(), (LoadPeonCallback)EasyMock.anyObject());
        EasyMock.expectLastCall().atLeastOnce();
        this.mockEmptyPeon();
        LoadQueuePeon anotherMockPeon = (LoadQueuePeon)EasyMock.createMock(LoadQueuePeon.class);
        EasyMock.expect((Object)anotherMockPeon.getLoadQueueSize()).andReturn((Object)10L).atLeastOnce();
        EasyMock.expect((Object)anotherMockPeon.getSegmentsToLoad()).andReturn(new HashSet()).anyTimes();
        EasyMock.replay((Object[])new Object[]{anotherMockPeon});
        DruidCluster druidCluster = DruidClusterBuilder.newBuilder().addTier("normal", new ServerHolder(server1.toImmutableDruidServer(), this.mockPeon, false), new ServerHolder(server2.toImmutableDruidServer(), anotherMockPeon, false), new ServerHolder(server3.toImmutableDruidServer(), anotherMockPeon, false)).build();
        SegmentReplicantLookup segmentReplicantLookup = SegmentReplicantLookup.make((DruidCluster)druidCluster, (boolean)false);
        ListeningExecutorService exec = MoreExecutors.listeningDecorator((ExecutorService)Executors.newFixedThreadPool(1));
        CostBalancerStrategy balancerStrategy = new CostBalancerStrategyFactory().createBalancerStrategy(exec);
        DruidCoordinatorRuntimeParams params = CoordinatorRuntimeParamsTestHelpers.newBuilder().withDruidCluster(druidCluster).withDynamicConfigs(COORDINATOR_CONFIG_WITH_ZERO_LEADING_TIME_BEFORE_CAN_MARK_AS_UNUSED_OVERSHADOWED_SEGMENTS).withUsedSegmentsInTest(this.usedSegments).withDatabaseRuleManager(this.databaseRuleManager).withSegmentReplicantLookup(segmentReplicantLookup).withBalancerStrategy((BalancerStrategy)balancerStrategy).build();
        DruidCoordinatorRuntimeParams afterParams = this.ruleRunner.run(params);
        CoordinatorStats stats = afterParams.getCoordinatorStats();
        Assert.assertEquals((long)1L, (long)stats.getTieredStat("droppedCount", "normal"));
        exec.shutdown();
        EasyMock.verify((Object[])new Object[]{this.mockPeon});
        EasyMock.verify((Object[])new Object[]{anotherMockPeon});
    }

    @Test
    public void testReplicantThrottle() {
        this.mockCoordinator();
        this.mockPeon.loadSegment((DataSegment)EasyMock.anyObject(), (LoadPeonCallback)EasyMock.anyObject());
        EasyMock.expectLastCall().atLeastOnce();
        this.mockEmptyPeon();
        EasyMock.expect((Object)this.databaseRuleManager.getRulesWithDefault((String)EasyMock.anyObject())).andReturn(Collections.singletonList(new IntervalLoadRule(Intervals.of((String)"2012-01-01T00:00:00.000Z/2013-01-01T00:00:00.000Z"), (Map)ImmutableMap.of((Object)"hot", (Object)2)))).atLeastOnce();
        EasyMock.replay((Object[])new Object[]{this.databaseRuleManager});
        DruidCluster druidCluster = DruidClusterBuilder.newBuilder().addTier("hot", new ServerHolder(new DruidServer("serverHot", "hostHot", null, 1000L, ServerType.HISTORICAL, "hot", 0).toImmutableDruidServer(), this.mockPeon), new ServerHolder(new DruidServer("serverHot2", "hostHot2", null, 1000L, ServerType.HISTORICAL, "hot", 0).toImmutableDruidServer(), this.mockPeon)).build();
        ListeningExecutorService exec = MoreExecutors.listeningDecorator((ExecutorService)Executors.newFixedThreadPool(1));
        CostBalancerStrategy balancerStrategy = new CostBalancerStrategyFactory().createBalancerStrategy(exec);
        DruidCoordinatorRuntimeParams params = this.makeCoordinatorRuntimeParams(druidCluster, (BalancerStrategy)balancerStrategy).build();
        DruidCoordinatorRuntimeParams afterParams = this.ruleRunner.run(params);
        CoordinatorStats stats = afterParams.getCoordinatorStats();
        Assert.assertEquals((long)48L, (long)stats.getTieredStat("assignedCount", "hot"));
        Assert.assertTrue((boolean)stats.getTiers("unassignedCount").isEmpty());
        Assert.assertTrue((boolean)stats.getTiers("unassignedSize").isEmpty());
        DataSegment overFlowSegment = new DataSegment("test", Intervals.of((String)"2012-02-01/2012-02-02"), DateTimes.nowUtc().toString(), new HashMap(), new ArrayList(), new ArrayList(), (ShardSpec)NoneShardSpec.instance(), Integer.valueOf(1), 0L);
        afterParams = this.ruleRunner.run(CoordinatorRuntimeParamsTestHelpers.newBuilder().withDruidCluster(druidCluster).withEmitter(this.emitter).withUsedSegmentsInTest(new DataSegment[]{overFlowSegment}).withDatabaseRuleManager(this.databaseRuleManager).withBalancerStrategy((BalancerStrategy)balancerStrategy).withSegmentReplicantLookup(SegmentReplicantLookup.make((DruidCluster)new DruidCluster(), (boolean)false)).build());
        stats = afterParams.getCoordinatorStats();
        Assert.assertEquals((long)1L, (long)stats.getTieredStat("assignedCount", "hot"));
        Assert.assertTrue((boolean)stats.getTiers("unassignedCount").isEmpty());
        Assert.assertTrue((boolean)stats.getTiers("unassignedSize").isEmpty());
        EasyMock.verify((Object[])new Object[]{this.mockPeon});
        exec.shutdown();
    }

    @Test
    public void testReplicantThrottleAcrossTiers() {
        EasyMock.expect((Object)this.coordinator.getDynamicConfigs()).andReturn((Object)CoordinatorDynamicConfig.builder().withReplicationThrottleLimit(7).withReplicantLifetime(1).withMaxSegmentsInNodeLoadingQueue(1000).build()).atLeastOnce();
        this.coordinator.markSegmentAsUnused((DataSegment)EasyMock.anyObject());
        EasyMock.expectLastCall().anyTimes();
        EasyMock.replay((Object[])new Object[]{this.coordinator});
        this.mockPeon.loadSegment((DataSegment)EasyMock.anyObject(), (LoadPeonCallback)EasyMock.anyObject());
        EasyMock.expectLastCall().atLeastOnce();
        this.mockEmptyPeon();
        EasyMock.expect((Object)this.databaseRuleManager.getRulesWithDefault((String)EasyMock.anyObject())).andReturn(Collections.singletonList(new IntervalLoadRule(Intervals.of((String)"2012-01-01T00:00:00.000Z/2013-01-01T00:00:00.000Z"), (Map)ImmutableMap.of((Object)"hot", (Object)1, (Object)"_default_tier", (Object)1)))).atLeastOnce();
        EasyMock.replay((Object[])new Object[]{this.databaseRuleManager});
        DruidCluster druidCluster = DruidClusterBuilder.newBuilder().addTier("hot", new ServerHolder(new DruidServer("serverHot", "hostHot", null, 1000L, ServerType.HISTORICAL, "hot", 1).toImmutableDruidServer(), this.mockPeon)).addTier("_default_tier", new ServerHolder(new DruidServer("serverNorm", "hostNorm", null, 1000L, ServerType.HISTORICAL, "_default_tier", 0).toImmutableDruidServer(), this.mockPeon)).build();
        ListeningExecutorService exec = MoreExecutors.listeningDecorator((ExecutorService)Executors.newFixedThreadPool(1));
        CostBalancerStrategy balancerStrategy = new CostBalancerStrategyFactory().createBalancerStrategy(exec);
        DruidCoordinatorRuntimeParams params = this.makeCoordinatorRuntimeParams(druidCluster, (BalancerStrategy)balancerStrategy).build();
        RunRules runner = new RunRules(new ReplicationThrottler(7, 1, false), this.coordinator);
        DruidCoordinatorRuntimeParams afterParams = runner.run(params);
        CoordinatorStats stats = afterParams.getCoordinatorStats();
        Assert.assertEquals((long)24L, (long)stats.getTieredStat("assignedCount", "hot"));
        Assert.assertEquals((long)7L, (long)stats.getTieredStat("assignedCount", "_default_tier"));
        Assert.assertTrue((boolean)stats.getTiers("unassignedCount").isEmpty());
        Assert.assertTrue((boolean)stats.getTiers("unassignedSize").isEmpty());
        EasyMock.verify((Object[])new Object[]{this.mockPeon});
        exec.shutdown();
    }

    @Test
    public void testDropReplicantThrottle() {
        this.mockCoordinator();
        this.mockPeon.dropSegment((DataSegment)EasyMock.anyObject(), (LoadPeonCallback)EasyMock.anyObject());
        EasyMock.expectLastCall().atLeastOnce();
        this.mockEmptyPeon();
        EasyMock.expect((Object)this.databaseRuleManager.getRulesWithDefault((String)EasyMock.anyObject())).andReturn(Collections.singletonList(new IntervalLoadRule(Intervals.of((String)"2012-01-01T00:00:00.000Z/2013-01-02T00:00:00.000Z"), (Map)ImmutableMap.of((Object)"normal", (Object)1)))).atLeastOnce();
        EasyMock.replay((Object[])new Object[]{this.databaseRuleManager});
        DataSegment overFlowSegment = new DataSegment("test", Intervals.of((String)"2012-02-01/2012-02-02"), DateTimes.nowUtc().toString(), new HashMap(), new ArrayList(), new ArrayList(), (ShardSpec)NoneShardSpec.instance(), Integer.valueOf(1), 0L);
        ArrayList longerUsedSegments = Lists.newArrayList(this.usedSegments);
        longerUsedSegments.add(overFlowSegment);
        DruidServer server1 = new DruidServer("serverNorm1", "hostNorm1", null, 1000L, ServerType.HISTORICAL, "normal", 0);
        for (Object segment : longerUsedSegments) {
            server1.addDataSegment((DataSegment)segment);
        }
        DruidServer server2 = new DruidServer("serverNorm2", "hostNorm2", null, 1000L, ServerType.HISTORICAL, "normal", 0);
        for (DataSegment segment : longerUsedSegments) {
            server2.addDataSegment(segment);
        }
        DruidCluster druidCluster = DruidClusterBuilder.newBuilder().addTier("normal", new ServerHolder(server1.toImmutableDruidServer(), this.mockPeon), new ServerHolder(server2.toImmutableDruidServer(), this.mockPeon)).build();
        SegmentReplicantLookup segmentReplicantLookup = SegmentReplicantLookup.make((DruidCluster)druidCluster, (boolean)false);
        ListeningExecutorService exec = MoreExecutors.listeningDecorator((ExecutorService)Executors.newFixedThreadPool(1));
        CostBalancerStrategy balancerStrategy = new CostBalancerStrategyFactory().createBalancerStrategy(exec);
        DruidCoordinatorRuntimeParams params = CoordinatorRuntimeParamsTestHelpers.newBuilder().withDruidCluster(druidCluster).withDynamicConfigs(COORDINATOR_CONFIG_WITH_ZERO_LEADING_TIME_BEFORE_CAN_MARK_AS_UNUSED_OVERSHADOWED_SEGMENTS).withUsedSegmentsInTest((Collection)longerUsedSegments).withDatabaseRuleManager(this.databaseRuleManager).withSegmentReplicantLookup(segmentReplicantLookup).withBalancerStrategy((BalancerStrategy)balancerStrategy).build();
        DruidCoordinatorRuntimeParams afterParams = this.ruleRunner.run(params);
        CoordinatorStats stats = afterParams.getCoordinatorStats();
        Assert.assertEquals((long)25L, (long)stats.getTieredStat("droppedCount", "normal"));
        EasyMock.verify((Object[])new Object[]{this.mockPeon});
        exec.shutdown();
    }

    @Test
    public void testRulesRunOnNonOvershadowedSegmentsOnly() {
        HashSet<DataSegment> usedSegments = new HashSet<DataSegment>();
        DataSegment v1 = new DataSegment("test", Intervals.of((String)"2012-01-01/2012-01-02"), "1", new HashMap(), new ArrayList(), new ArrayList(), (ShardSpec)NoneShardSpec.instance(), Integer.valueOf(9), 1L);
        DataSegment v2 = new DataSegment("test", Intervals.of((String)"2012-01-01/2012-01-02"), "2", new HashMap(), new ArrayList(), new ArrayList(), (ShardSpec)NoneShardSpec.instance(), Integer.valueOf(9), 1L);
        usedSegments.add(v1);
        usedSegments.add(v2);
        this.mockCoordinator();
        this.mockPeon.loadSegment((DataSegment)EasyMock.eq((Object)v2), (LoadPeonCallback)EasyMock.anyObject());
        EasyMock.expectLastCall().once();
        this.mockEmptyPeon();
        EasyMock.expect((Object)this.databaseRuleManager.getRulesWithDefault((String)EasyMock.anyObject())).andReturn(Collections.singletonList(new ForeverLoadRule((Map)ImmutableMap.of((Object)"_default_tier", (Object)1)))).atLeastOnce();
        EasyMock.replay((Object[])new Object[]{this.databaseRuleManager});
        DruidCluster druidCluster = DruidClusterBuilder.newBuilder().addTier("_default_tier", new ServerHolder(new DruidServer("serverHot", "hostHot", null, 1000L, ServerType.HISTORICAL, "_default_tier", 0).toImmutableDruidServer(), this.mockPeon)).build();
        ListeningExecutorService exec = MoreExecutors.listeningDecorator((ExecutorService)Executors.newFixedThreadPool(1));
        CostBalancerStrategy balancerStrategy = new CostBalancerStrategyFactory().createBalancerStrategy(exec);
        DruidCoordinatorRuntimeParams params = CoordinatorRuntimeParamsTestHelpers.newBuilder().withDruidCluster(druidCluster).withUsedSegmentsInTest(usedSegments).withDatabaseRuleManager(this.databaseRuleManager).withSegmentReplicantLookup(SegmentReplicantLookup.make((DruidCluster)new DruidCluster(), (boolean)false)).withBalancerStrategy((BalancerStrategy)balancerStrategy).withDynamicConfigs(CoordinatorDynamicConfig.builder().withMaxSegmentsToMove(5).build()).build();
        DruidCoordinatorRuntimeParams afterParams = this.ruleRunner.run(params);
        CoordinatorStats stats = afterParams.getCoordinatorStats();
        Assert.assertEquals((long)1L, (long)stats.getTiers("assignedCount").size());
        Assert.assertEquals((long)1L, (long)stats.getTieredStat("assignedCount", "_default_tier"));
        Assert.assertTrue((boolean)stats.getTiers("unassignedCount").isEmpty());
        Assert.assertTrue((boolean)stats.getTiers("unassignedSize").isEmpty());
        Assert.assertEquals((long)2L, (long)usedSegments.size());
        Assert.assertEquals(usedSegments, (Object)params.getUsedSegments());
        Assert.assertEquals(usedSegments, (Object)afterParams.getUsedSegments());
        EasyMock.verify((Object[])new Object[]{this.mockPeon});
        exec.shutdown();
    }

    @Test(timeout=5000L)
    public void testTwoNodesOneTierThreeReplicantsRandomStrategyNotEnoughNodes() {
        this.mockCoordinator();
        this.mockEmptyPeon();
        EasyMock.expect((Object)this.databaseRuleManager.getRulesWithDefault((String)EasyMock.anyObject())).andReturn(Collections.singletonList(new ForeverLoadRule((Map)ImmutableMap.of((Object)"_default_tier", (Object)3)))).atLeastOnce();
        EasyMock.replay((Object[])new Object[]{this.databaseRuleManager});
        DataSegment dataSegment = new DataSegment("test", Intervals.utc((long)0L, (long)1L), DateTimes.nowUtc().toString(), new HashMap(), new ArrayList(), new ArrayList(), (ShardSpec)NoneShardSpec.instance(), Integer.valueOf(9), 1L);
        DruidCluster druidCluster = DruidClusterBuilder.newBuilder().addTier("_default_tier", new ServerHolder(new DruidServer("server1", "host1", null, 1000L, ServerType.HISTORICAL, "_default_tier", 0).addDataSegment(dataSegment).toImmutableDruidServer(), this.mockPeon), new ServerHolder(new DruidServer("server2", "host2", null, 1000L, ServerType.HISTORICAL, "_default_tier", 0).addDataSegment(dataSegment).toImmutableDruidServer(), this.mockPeon)).build();
        RandomBalancerStrategy balancerStrategy = new RandomBalancerStrategy();
        DruidCoordinatorRuntimeParams params = this.makeCoordinatorRuntimeParams(druidCluster, (BalancerStrategy)balancerStrategy, Collections.singletonList(dataSegment)).withDynamicConfigs(CoordinatorDynamicConfig.builder().withMaxSegmentsToMove(5).build()).build();
        DruidCoordinatorRuntimeParams afterParams = this.ruleRunner.run(params);
        CoordinatorStats stats = afterParams.getCoordinatorStats();
        Assert.assertEquals((long)0L, (long)stats.getTieredStat("assignedCount", "_default_tier"));
        Assert.assertTrue((boolean)stats.getTiers("unassignedCount").isEmpty());
        Assert.assertTrue((boolean)stats.getTiers("unassignedSize").isEmpty());
        EasyMock.verify((Object[])new Object[]{this.mockPeon});
    }

    @Test(timeout=5000L)
    public void testOneNodesOneTierOneReplicantRandomStrategyEnoughSpace() {
        this.mockCoordinator();
        this.mockPeon.loadSegment((DataSegment)EasyMock.anyObject(), (LoadPeonCallback)EasyMock.anyObject());
        EasyMock.expectLastCall().atLeastOnce();
        this.mockEmptyPeon();
        EasyMock.expect((Object)this.databaseRuleManager.getRulesWithDefault((String)EasyMock.anyObject())).andReturn(Collections.singletonList(new ForeverLoadRule((Map)ImmutableMap.of((Object)"_default_tier", (Object)1)))).atLeastOnce();
        EasyMock.replay((Object[])new Object[]{this.databaseRuleManager});
        DataSegment dataSegment = new DataSegment("test", Intervals.utc((long)0L, (long)1L), DateTimes.nowUtc().toString(), new HashMap(), new ArrayList(), new ArrayList(), (ShardSpec)NoneShardSpec.instance(), Integer.valueOf(9), 1L);
        DruidCluster druidCluster = DruidClusterBuilder.newBuilder().addTier("_default_tier", new ServerHolder(new DruidServer("server1", "host1", null, 1000L, ServerType.HISTORICAL, "_default_tier", 0).toImmutableDruidServer(), this.mockPeon)).build();
        RandomBalancerStrategy balancerStrategy = new RandomBalancerStrategy();
        DruidCoordinatorRuntimeParams params = this.makeCoordinatorRuntimeParams(druidCluster, (BalancerStrategy)balancerStrategy, Collections.singletonList(dataSegment)).withDynamicConfigs(CoordinatorDynamicConfig.builder().withMaxSegmentsToMove(5).build()).build();
        DruidCoordinatorRuntimeParams afterParams = this.ruleRunner.run(params);
        CoordinatorStats stats = afterParams.getCoordinatorStats();
        Assert.assertEquals((long)1L, (long)stats.getTieredStat("assignedCount", "_default_tier"));
        Assert.assertTrue((boolean)stats.getTiers("unassignedCount").isEmpty());
        Assert.assertTrue((boolean)stats.getTiers("unassignedSize").isEmpty());
        EasyMock.verify((Object[])new Object[]{this.mockPeon});
    }

    @Test(timeout=5000L)
    public void testOneNodesOneTierOneReplicantRandomStrategyNotEnoughSpace() {
        this.mockCoordinator();
        this.mockEmptyPeon();
        int numReplicants = 1;
        EasyMock.expect((Object)this.databaseRuleManager.getRulesWithDefault((String)EasyMock.anyObject())).andReturn(Collections.singletonList(new ForeverLoadRule((Map)ImmutableMap.of((Object)"_default_tier", (Object)numReplicants)))).atLeastOnce();
        EasyMock.replay((Object[])new Object[]{this.databaseRuleManager});
        DataSegment dataSegment = new DataSegment("test", Intervals.utc((long)0L, (long)1L), DateTimes.nowUtc().toString(), new HashMap(), new ArrayList(), new ArrayList(), (ShardSpec)NoneShardSpec.instance(), Integer.valueOf(9), 11L);
        DruidCluster druidCluster = DruidClusterBuilder.newBuilder().addTier("_default_tier", new ServerHolder(new DruidServer("server1", "host1", null, 10L, ServerType.HISTORICAL, "_default_tier", 0).toImmutableDruidServer(), this.mockPeon)).build();
        RandomBalancerStrategy balancerStrategy = new RandomBalancerStrategy();
        DruidCoordinatorRuntimeParams params = this.makeCoordinatorRuntimeParams(druidCluster, (BalancerStrategy)balancerStrategy, Collections.singletonList(dataSegment)).withDynamicConfigs(CoordinatorDynamicConfig.builder().withMaxSegmentsToMove(5).build()).build();
        DruidCoordinatorRuntimeParams afterParams = this.ruleRunner.run(params);
        CoordinatorStats stats = afterParams.getCoordinatorStats();
        Assert.assertEquals((long)(dataSegment.getSize() * (long)numReplicants), (long)stats.getTieredStat("requiredCapacity", "_default_tier"));
        Assert.assertTrue((boolean)stats.getTiers("assignedCount").isEmpty());
        Assert.assertTrue((boolean)stats.getTiers("unassignedCount").isEmpty());
        Assert.assertTrue((boolean)stats.getTiers("unassignedSize").isEmpty());
        EasyMock.verify((Object[])new Object[]{this.mockPeon});
    }

    @Test
    public void testOneNodesOneTierOneReplicantCostBalancerStrategyNotEnoughSpace() {
        this.mockCoordinator();
        this.mockEmptyPeon();
        int numReplicants = 1;
        EasyMock.expect((Object)this.databaseRuleManager.getRulesWithDefault((String)EasyMock.anyObject())).andReturn(Collections.singletonList(new ForeverLoadRule((Map)ImmutableMap.of((Object)"_default_tier", (Object)numReplicants)))).atLeastOnce();
        EasyMock.replay((Object[])new Object[]{this.databaseRuleManager});
        DataSegment dataSegment = new DataSegment("test", Intervals.utc((long)0L, (long)1L), DateTimes.nowUtc().toString(), new HashMap(), new ArrayList(), new ArrayList(), (ShardSpec)NoneShardSpec.instance(), Integer.valueOf(9), 11L);
        DruidCluster druidCluster = DruidClusterBuilder.newBuilder().addTier("_default_tier", new ServerHolder(new DruidServer("server1", "host1", null, 10L, ServerType.HISTORICAL, "_default_tier", 0).toImmutableDruidServer(), this.mockPeon)).build();
        ListeningExecutorService exec = MoreExecutors.listeningDecorator((ExecutorService)Executors.newFixedThreadPool(1));
        CostBalancerStrategy balancerStrategy = new CostBalancerStrategy(exec);
        DruidCoordinatorRuntimeParams params = this.makeCoordinatorRuntimeParams(druidCluster, (BalancerStrategy)balancerStrategy, Collections.singletonList(dataSegment)).withDynamicConfigs(CoordinatorDynamicConfig.builder().withMaxSegmentsToMove(5).build()).build();
        DruidCoordinatorRuntimeParams afterParams = this.ruleRunner.run(params);
        CoordinatorStats stats = afterParams.getCoordinatorStats();
        Assert.assertEquals((long)(dataSegment.getSize() * (long)numReplicants), (long)stats.getTieredStat("requiredCapacity", "_default_tier"));
        Assert.assertTrue((boolean)stats.getTiers("assignedCount").isEmpty());
        Assert.assertTrue((boolean)stats.getTiers("unassignedCount").isEmpty());
        Assert.assertTrue((boolean)stats.getTiers("unassignedSize").isEmpty());
        exec.shutdown();
        EasyMock.verify((Object[])new Object[]{this.mockPeon});
    }

    private void mockCoordinator() {
        EasyMock.expect((Object)this.coordinator.getDynamicConfigs()).andReturn((Object)this.createCoordinatorDynamicConfig()).anyTimes();
        this.coordinator.markSegmentAsUnused((DataSegment)EasyMock.anyObject());
        EasyMock.expectLastCall().anyTimes();
        EasyMock.replay((Object[])new Object[]{this.coordinator, this.segmentsMetadataManager});
    }

    private void mockEmptyPeon() {
        EasyMock.expect((Object)this.mockPeon.getSegmentsToLoad()).andReturn(new HashSet()).anyTimes();
        EasyMock.expect((Object)this.mockPeon.getSegmentsMarkedToDrop()).andReturn(new HashSet()).anyTimes();
        EasyMock.expect((Object)this.mockPeon.getLoadQueueSize()).andReturn((Object)0L).atLeastOnce();
        EasyMock.expect((Object)this.mockPeon.getNumberOfSegmentsInQueue()).andReturn((Object)0).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.mockPeon});
    }

    private CoordinatorDynamicConfig createCoordinatorDynamicConfig() {
        return CoordinatorDynamicConfig.builder().withLeadingTimeMillisBeforeCanMarkAsUnusedOvershadowedSegments(0L).withMergeBytesLimit(0L).withMergeSegmentsLimit(0).withMaxSegmentsToMove(0).withReplicantLifetime(1).withReplicationThrottleLimit(24).withBalancerComputeThreads(0).withEmitBalancingStats(false).withSpecificDataSourcesToKillUnusedSegmentsIn(null).withKillUnusedSegmentsInAllDataSources(false).withMaxSegmentsInNodeLoadingQueue(1000).withPauseCoordination(false).build();
    }
}

