/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.coordinator.duty;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import org.apache.druid.indexing.overlord.IndexerMetadataStorageCoordinator;
import org.apache.druid.java.util.emitter.service.ServiceEmitter;
import org.apache.druid.java.util.emitter.service.ServiceEventBuilder;
import org.apache.druid.metadata.MetadataSupervisorManager;
import org.apache.druid.metadata.TestSupervisorSpec;
import org.apache.druid.server.coordinator.DruidCoordinatorConfig;
import org.apache.druid.server.coordinator.DruidCoordinatorRuntimeParams;
import org.apache.druid.server.coordinator.TestDruidCoordinatorConfig;
import org.apache.druid.server.coordinator.duty.KillDatasourceMetadata;
import org.joda.time.Duration;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class KillDatasourceMetadataTest {
    @Mock
    private IndexerMetadataStorageCoordinator mockIndexerMetadataStorageCoordinator;
    @Mock
    private MetadataSupervisorManager mockMetadataSupervisorManager;
    @Mock
    private DruidCoordinatorRuntimeParams mockDruidCoordinatorRuntimeParams;
    @Mock
    private TestSupervisorSpec mockKinesisSupervisorSpec;
    @Mock
    private ServiceEmitter mockServiceEmitter;
    @Rule
    public ExpectedException exception = ExpectedException.none();
    private KillDatasourceMetadata killDatasourceMetadata;

    @Test
    public void testRunSkipIfLastRunLessThanPeriod() {
        TestDruidCoordinatorConfig druidCoordinatorConfig = new TestDruidCoordinatorConfig(null, null, null, new Duration((Object)"PT5S"), null, null, null, null, null, null, null, null, null, null, new Duration(Long.MAX_VALUE), new Duration((Object)"PT1S"), 10, null);
        this.killDatasourceMetadata = new KillDatasourceMetadata((DruidCoordinatorConfig)druidCoordinatorConfig, this.mockIndexerMetadataStorageCoordinator, this.mockMetadataSupervisorManager);
        this.killDatasourceMetadata.run(this.mockDruidCoordinatorRuntimeParams);
        Mockito.verifyZeroInteractions((Object[])new Object[]{this.mockIndexerMetadataStorageCoordinator});
        Mockito.verifyZeroInteractions((Object[])new Object[]{this.mockMetadataSupervisorManager});
    }

    @Test
    public void testRunNotSkipIfLastRunMoreThanPeriod() {
        Mockito.when((Object)this.mockDruidCoordinatorRuntimeParams.getEmitter()).thenReturn((Object)this.mockServiceEmitter);
        TestDruidCoordinatorConfig druidCoordinatorConfig = new TestDruidCoordinatorConfig(null, null, null, new Duration((Object)"PT5S"), null, null, null, null, null, null, null, null, null, null, new Duration((Object)"PT6S"), new Duration((Object)"PT1S"), 10, null);
        this.killDatasourceMetadata = new KillDatasourceMetadata((DruidCoordinatorConfig)druidCoordinatorConfig, this.mockIndexerMetadataStorageCoordinator, this.mockMetadataSupervisorManager);
        this.killDatasourceMetadata.run(this.mockDruidCoordinatorRuntimeParams);
        ((IndexerMetadataStorageCoordinator)Mockito.verify((Object)this.mockIndexerMetadataStorageCoordinator)).removeDataSourceMetadataOlderThan(ArgumentMatchers.anyLong(), ArgumentMatchers.anySet());
        ((ServiceEmitter)Mockito.verify((Object)this.mockServiceEmitter)).emit((ServiceEventBuilder)ArgumentMatchers.any(ServiceEventBuilder.class));
    }

    @Test
    public void testConstructorFailIfInvalidPeriod() {
        TestDruidCoordinatorConfig druidCoordinatorConfig = new TestDruidCoordinatorConfig(null, null, null, new Duration((Object)"PT5S"), null, null, null, null, null, null, null, null, null, null, new Duration((Object)"PT3S"), new Duration((Object)"PT1S"), 10, null);
        this.exception.expect(IllegalArgumentException.class);
        this.exception.expectMessage("Coordinator datasource metadata kill period must be >= druid.coordinator.period.metadataStoreManagementPeriod");
        this.killDatasourceMetadata = new KillDatasourceMetadata((DruidCoordinatorConfig)druidCoordinatorConfig, this.mockIndexerMetadataStorageCoordinator, this.mockMetadataSupervisorManager);
    }

    @Test
    public void testConstructorFailIfInvalidRetainDuration() {
        TestDruidCoordinatorConfig druidCoordinatorConfig = new TestDruidCoordinatorConfig(null, null, null, new Duration((Object)"PT5S"), null, null, null, null, null, null, null, null, null, null, new Duration((Object)"PT6S"), new Duration((Object)"PT-1S"), 10, null);
        this.exception.expect(IllegalArgumentException.class);
        this.exception.expectMessage("Coordinator datasource metadata kill retainDuration must be >= 0");
        this.killDatasourceMetadata = new KillDatasourceMetadata((DruidCoordinatorConfig)druidCoordinatorConfig, this.mockIndexerMetadataStorageCoordinator, this.mockMetadataSupervisorManager);
    }

    @Test
    public void testRunWithEmptyFilterExcludedDatasource() {
        Mockito.when((Object)this.mockDruidCoordinatorRuntimeParams.getEmitter()).thenReturn((Object)this.mockServiceEmitter);
        TestDruidCoordinatorConfig druidCoordinatorConfig = new TestDruidCoordinatorConfig(null, null, null, new Duration((Object)"PT5S"), null, null, null, null, null, null, null, null, null, null, new Duration((Object)"PT6S"), new Duration((Object)"PT1S"), 10, null);
        this.killDatasourceMetadata = new KillDatasourceMetadata((DruidCoordinatorConfig)druidCoordinatorConfig, this.mockIndexerMetadataStorageCoordinator, this.mockMetadataSupervisorManager);
        this.killDatasourceMetadata.run(this.mockDruidCoordinatorRuntimeParams);
        ((IndexerMetadataStorageCoordinator)Mockito.verify((Object)this.mockIndexerMetadataStorageCoordinator)).removeDataSourceMetadataOlderThan(ArgumentMatchers.anyLong(), (Set)ArgumentMatchers.eq((Object)ImmutableSet.of()));
        ((ServiceEmitter)Mockito.verify((Object)this.mockServiceEmitter)).emit((ServiceEventBuilder)ArgumentMatchers.any(ServiceEventBuilder.class));
    }
}

