/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.coordinator.duty;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.apache.druid.client.indexing.IndexingServiceClient;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.metadata.SegmentsMetadataManager;
import org.apache.druid.server.coordinator.DruidCoordinatorConfig;
import org.apache.druid.server.coordinator.TestDruidCoordinatorConfig;
import org.apache.druid.server.coordinator.duty.KillUnusedSegments;
import org.easymock.EasyMock;
import org.joda.time.DateTime;
import org.joda.time.Duration;
import org.joda.time.Interval;
import org.junit.Assert;
import org.junit.Test;

public class KillUnusedSegmentsTest {
    @Test
    public void testFindIntervalForKill() {
        this.testFindIntervalForKill(null, null);
        this.testFindIntervalForKill((List<Interval>)ImmutableList.of(), null);
        this.testFindIntervalForKill((List<Interval>)ImmutableList.of((Object)Intervals.of((String)"2014/2015")), Intervals.of((String)"2014/2015"));
        this.testFindIntervalForKill((List<Interval>)ImmutableList.of((Object)Intervals.of((String)"2014/2015"), (Object)Intervals.of((String)"2016/2017")), Intervals.of((String)"2014/2017"));
        this.testFindIntervalForKill((List<Interval>)ImmutableList.of((Object)Intervals.of((String)"2014/2015"), (Object)Intervals.of((String)"2015/2016")), Intervals.of((String)"2014/2016"));
        this.testFindIntervalForKill((List<Interval>)ImmutableList.of((Object)Intervals.of((String)"2015/2016"), (Object)Intervals.of((String)"2014/2015")), Intervals.of((String)"2014/2016"));
        this.testFindIntervalForKill((List<Interval>)ImmutableList.of((Object)Intervals.of((String)"2015/2017"), (Object)Intervals.of((String)"2014/2016")), Intervals.of((String)"2014/2017"));
        this.testFindIntervalForKill((List<Interval>)ImmutableList.of((Object)Intervals.of((String)"2015/2019"), (Object)Intervals.of((String)"2014/2016"), (Object)Intervals.of((String)"2018/2020")), Intervals.of((String)"2014/2020"));
        this.testFindIntervalForKill((List<Interval>)ImmutableList.of((Object)Intervals.of((String)"2015/2019"), (Object)Intervals.of((String)"2014/2016"), (Object)Intervals.of((String)"2018/2020"), (Object)Intervals.of((String)"2021/2022")), Intervals.of((String)"2014/2022"));
    }

    private void testFindIntervalForKill(List<Interval> segmentIntervals, Interval expected) {
        SegmentsMetadataManager segmentsMetadataManager = (SegmentsMetadataManager)EasyMock.createMock(SegmentsMetadataManager.class);
        EasyMock.expect((Object)segmentsMetadataManager.getUnusedSegmentIntervals(EasyMock.anyString(), (DateTime)EasyMock.anyObject(DateTime.class), EasyMock.anyInt())).andReturn(segmentIntervals);
        EasyMock.replay((Object[])new Object[]{segmentsMetadataManager});
        IndexingServiceClient indexingServiceClient = (IndexingServiceClient)EasyMock.createMock(IndexingServiceClient.class);
        KillUnusedSegments unusedSegmentsKiller = new KillUnusedSegments(segmentsMetadataManager, indexingServiceClient, (DruidCoordinatorConfig)new TestDruidCoordinatorConfig(null, null, Duration.parse((String)"PT76400S"), null, new Duration(1L), Duration.parse((String)"PT86400S"), Duration.parse((String)"PT86400S"), null, null, null, null, null, null, null, null, null, 1000, Duration.ZERO));
        Assert.assertEquals((Object)expected, (Object)unusedSegmentsKiller.findIntervalForKill("test", 10000));
    }
}

