/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.client.cache;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.function.Function;
import org.apache.druid.client.cache.Cache;
import org.apache.druid.client.cache.CachePopulator;
import org.apache.druid.client.cache.CachePopulatorStats;
import org.apache.druid.common.guava.GuavaUtils;
import org.apache.druid.java.util.common.concurrent.Execs;
import org.apache.druid.java.util.common.guava.Sequence;
import org.apache.druid.java.util.common.guava.Sequences;
import org.apache.druid.java.util.common.logger.Logger;

public class BackgroundCachePopulator
implements CachePopulator {
    private static final Logger log = new Logger(BackgroundCachePopulator.class);
    private final ListeningExecutorService exec;
    private final ObjectMapper objectMapper;
    private final CachePopulatorStats cachePopulatorStats;
    private final long maxEntrySize;

    public BackgroundCachePopulator(ExecutorService exec, ObjectMapper objectMapper, CachePopulatorStats cachePopulatorStats, long maxEntrySize) {
        this.exec = MoreExecutors.listeningDecorator((ExecutorService)exec);
        this.objectMapper = (ObjectMapper)Preconditions.checkNotNull((Object)objectMapper, (Object)"objectMapper");
        this.cachePopulatorStats = (CachePopulatorStats)Preconditions.checkNotNull((Object)cachePopulatorStats, (Object)"cachePopulatorStats");
        this.maxEntrySize = maxEntrySize;
    }

    @Override
    public <T, CacheType> Sequence<T> wrap(Sequence<T> sequence, Function<T, CacheType> cacheFn, final Cache cache, final Cache.NamedKey cacheKey) {
        final ArrayList cacheFutures = new ArrayList();
        Sequence wrappedSequence = Sequences.map(sequence, input -> {
            cacheFutures.add(this.exec.submit(() -> cacheFn.apply(input)));
            return input;
        });
        return Sequences.withEffect((Sequence)wrappedSequence, () -> Futures.addCallback((ListenableFuture)Futures.allAsList((Iterable)cacheFutures), (FutureCallback)new FutureCallback<List<CacheType>>(){

            public void onSuccess(List<CacheType> results) {
                BackgroundCachePopulator.this.populateCache(cache, cacheKey, results);
                cacheFutures.clear();
            }

            public void onFailure(Throwable t) {
                GuavaUtils.cancelAll((boolean)true, null, (List)cacheFutures);
                log.error(t, "Background caching failed", new Object[0]);
            }
        }, (Executor)this.exec), (Executor)Execs.directExecutor());
    }

    private <CacheType> void populateCache(Cache cache, Cache.NamedKey cacheKey, List<CacheType> results) {
        try {
            ByteArrayOutputStream bytes = new ByteArrayOutputStream();
            try (JsonGenerator gen = this.objectMapper.getFactory().createGenerator((OutputStream)bytes);){
                for (CacheType result : results) {
                    gen.writeObject(result);
                    if (this.maxEntrySize <= 0L || (long)bytes.size() <= this.maxEntrySize) continue;
                    this.cachePopulatorStats.incrementOversized();
                    return;
                }
            }
            if (this.maxEntrySize > 0L && (long)bytes.size() > this.maxEntrySize) {
                this.cachePopulatorStats.incrementOversized();
                return;
            }
            cache.put(cacheKey, bytes.toByteArray());
            this.cachePopulatorStats.incrementOk();
        }
        catch (Exception e) {
            log.warn((Throwable)e, "Could not populate cache", new Object[0]);
            this.cachePopulatorStats.incrementError();
        }
    }
}

