/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.client.indexing;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import java.util.Map;
import java.util.Objects;
import org.apache.druid.client.indexing.ClientCompactionIOConfig;
import org.apache.druid.client.indexing.ClientCompactionTaskGranularitySpec;
import org.apache.druid.client.indexing.ClientCompactionTaskQueryTuningConfig;
import org.apache.druid.client.indexing.ClientTaskQuery;

public class ClientCompactionTaskQuery
implements ClientTaskQuery {
    static final String TYPE = "compact";
    private final String id;
    private final String dataSource;
    private final ClientCompactionIOConfig ioConfig;
    private final ClientCompactionTaskQueryTuningConfig tuningConfig;
    private final ClientCompactionTaskGranularitySpec granularitySpec;
    private final Map<String, Object> context;

    @JsonCreator
    public ClientCompactionTaskQuery(@JsonProperty(value="id") String id, @JsonProperty(value="dataSource") String dataSource, @JsonProperty(value="ioConfig") ClientCompactionIOConfig ioConfig, @JsonProperty(value="tuningConfig") ClientCompactionTaskQueryTuningConfig tuningConfig, @JsonProperty(value="granularitySpec") ClientCompactionTaskGranularitySpec granularitySpec, @JsonProperty(value="context") Map<String, Object> context) {
        this.id = (String)Preconditions.checkNotNull((Object)id, (Object)"id");
        this.dataSource = dataSource;
        this.ioConfig = ioConfig;
        this.tuningConfig = tuningConfig;
        this.granularitySpec = granularitySpec;
        this.context = context;
    }

    @Override
    @JsonProperty
    public String getId() {
        return this.id;
    }

    @Override
    @JsonProperty
    public String getType() {
        return TYPE;
    }

    @Override
    @JsonProperty
    public String getDataSource() {
        return this.dataSource;
    }

    @JsonProperty
    public ClientCompactionIOConfig getIoConfig() {
        return this.ioConfig;
    }

    @JsonProperty
    public ClientCompactionTaskQueryTuningConfig getTuningConfig() {
        return this.tuningConfig;
    }

    @JsonProperty
    public ClientCompactionTaskGranularitySpec getGranularitySpec() {
        return this.granularitySpec;
    }

    @JsonProperty
    public Map<String, Object> getContext() {
        return this.context;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClientCompactionTaskQuery that = (ClientCompactionTaskQuery)o;
        return Objects.equals(this.id, that.id) && Objects.equals(this.dataSource, that.dataSource) && Objects.equals(this.ioConfig, that.ioConfig) && Objects.equals(this.tuningConfig, that.tuningConfig) && Objects.equals(this.granularitySpec, that.granularitySpec) && Objects.equals(this.context, that.context);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.dataSource, this.ioConfig, this.tuningConfig, this.granularitySpec, this.context);
    }

    public String toString() {
        return "ClientCompactionTaskQuery{id='" + this.id + '\'' + ", dataSource='" + this.dataSource + '\'' + ", ioConfig=" + this.ioConfig + ", tuningConfig=" + this.tuningConfig + ", granularitySpec=" + this.granularitySpec + ", context=" + this.context + '}';
    }
}

