/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.coordinator;

import java.util.Iterator;
import java.util.List;
import java.util.NavigableSet;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.druid.server.coordinator.BalancerSegmentHolder;
import org.apache.druid.server.coordinator.CoordinatorStats;
import org.apache.druid.server.coordinator.ReservoirSegmentSampler;
import org.apache.druid.server.coordinator.ServerHolder;
import org.apache.druid.timeline.DataSegment;

public interface BalancerStrategy {
    @Nullable
    public ServerHolder findNewSegmentHomeBalancer(DataSegment var1, List<ServerHolder> var2);

    @Nullable
    public ServerHolder findNewSegmentHomeReplicator(DataSegment var1, List<ServerHolder> var2);

    default public Iterator<BalancerSegmentHolder> pickSegmentsToMove(final List<ServerHolder> serverHolders, final Set<String> broadcastDatasources, final int reservoirSize, final double percentOfSegmentsToConsider) {
        if (reservoirSize > 1) {
            return new Iterator<BalancerSegmentHolder>(){
                private Iterator<BalancerSegmentHolder> it = this.sample();

                private Iterator<BalancerSegmentHolder> sample() {
                    return ReservoirSegmentSampler.getRandomBalancerSegmentHolders(serverHolders, broadcastDatasources, reservoirSize).iterator();
                }

                @Override
                public boolean hasNext() {
                    if (this.it.hasNext()) {
                        return true;
                    }
                    this.it = this.sample();
                    return this.it.hasNext();
                }

                @Override
                public BalancerSegmentHolder next() {
                    return this.it.next();
                }
            };
        }
        return new Iterator<BalancerSegmentHolder>(){
            private BalancerSegmentHolder next = this.sample();

            private BalancerSegmentHolder sample() {
                return ReservoirSegmentSampler.getRandomBalancerSegmentHolder(serverHolders, broadcastDatasources, percentOfSegmentsToConsider);
            }

            @Override
            public boolean hasNext() {
                return this.next != null;
            }

            @Override
            public BalancerSegmentHolder next() {
                BalancerSegmentHolder ret = this.next;
                this.next = this.sample();
                return ret;
            }
        };
    }

    default public Iterator<ServerHolder> pickServersToDrop(DataSegment toDropSegment, NavigableSet<ServerHolder> serverHolders) {
        return serverHolders.descendingIterator();
    }

    public void emitStats(String var1, CoordinatorStats var2, List<ServerHolder> var3);
}

