/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.discovery;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BooleanSupplier;
import org.apache.druid.discovery.DataNodeService;
import org.apache.druid.discovery.DiscoveryDruidNode;
import org.apache.druid.discovery.DruidNodeDiscovery;
import org.apache.druid.discovery.DruidNodeDiscoveryProvider;
import org.apache.druid.discovery.LookupNodeService;
import org.apache.druid.discovery.NodeRole;
import org.apache.druid.server.DruidNode;
import org.apache.druid.server.coordination.ServerType;
import org.junit.Assert;
import org.junit.Test;

public class DruidNodeDiscoveryProviderTest {
    @Test
    public void testGetForService() {
        TestDruidNodeDiscoveryProvider provider = new TestDruidNodeDiscoveryProvider();
        DruidNodeDiscovery dataNodeDiscovery = provider.getForService("dataNodeService");
        final HashSet dataNodes = new HashSet();
        dataNodeDiscovery.registerListener(new DruidNodeDiscovery.Listener(){

            public void nodesAdded(Collection<DiscoveryDruidNode> nodes) {
                dataNodes.addAll(nodes);
            }

            public void nodesRemoved(Collection<DiscoveryDruidNode> nodes) {
                dataNodes.removeAll(nodes);
            }
        });
        DruidNodeDiscovery lookupNodeDiscovery = provider.getForService("lookupNodeService");
        final HashSet lookupNodes = new HashSet();
        lookupNodeDiscovery.registerListener(new DruidNodeDiscovery.Listener(){

            public void nodesAdded(Collection<DiscoveryDruidNode> nodes) {
                lookupNodes.addAll(nodes);
            }

            public void nodesRemoved(Collection<DiscoveryDruidNode> nodes) {
                lookupNodes.removeAll(nodes);
            }
        });
        Assert.assertTrue((boolean)dataNodes.isEmpty());
        Assert.assertTrue((boolean)dataNodes.isEmpty());
        Assert.assertTrue((boolean)dataNodeDiscovery.getAllNodes().isEmpty());
        Assert.assertTrue((boolean)lookupNodes.isEmpty());
        Assert.assertTrue((boolean)lookupNodeDiscovery.getAllNodes().isEmpty());
        DiscoveryDruidNode node1 = new DiscoveryDruidNode(new DruidNode("s1", "h1", false, Integer.valueOf(8080), null, true, false), NodeRole.HISTORICAL, (Map)ImmutableMap.of((Object)"dataNodeService", (Object)new DataNodeService("tier", 1000L, ServerType.HISTORICAL, 0), (Object)"lookupNodeService", (Object)new LookupNodeService("tier")));
        DiscoveryDruidNode node2 = new DiscoveryDruidNode(new DruidNode("s2", "h2", false, Integer.valueOf(8080), null, true, false), NodeRole.HISTORICAL, (Map)ImmutableMap.of((Object)"dataNodeService", (Object)new DataNodeService("tier", 1000L, ServerType.HISTORICAL, 0)));
        DiscoveryDruidNode node3 = new DiscoveryDruidNode(new DruidNode("s3", "h3", false, Integer.valueOf(8080), null, true, false), NodeRole.HISTORICAL, (Map)ImmutableMap.of((Object)"lookupNodeService", (Object)new LookupNodeService("tier")));
        DiscoveryDruidNode node4 = new DiscoveryDruidNode(new DruidNode("s4", "h4", false, Integer.valueOf(8080), null, true, false), NodeRole.PEON, (Map)ImmutableMap.of((Object)"dataNodeService", (Object)new DataNodeService("tier", 1000L, ServerType.HISTORICAL, 0), (Object)"lookupNodeService", (Object)new LookupNodeService("tier")));
        DiscoveryDruidNode node5 = new DiscoveryDruidNode(new DruidNode("s5", "h5", false, Integer.valueOf(8080), null, true, false), NodeRole.PEON, (Map)ImmutableMap.of((Object)"dataNodeService", (Object)new DataNodeService("tier", 1000L, ServerType.HISTORICAL, 0)));
        DiscoveryDruidNode node6 = new DiscoveryDruidNode(new DruidNode("s6", "h6", false, Integer.valueOf(8080), null, true, false), NodeRole.PEON, (Map)ImmutableMap.of((Object)"lookupNodeService", (Object)new LookupNodeService("tier")));
        DiscoveryDruidNode node7 = new DiscoveryDruidNode(new DruidNode("s7", "h7", false, Integer.valueOf(8080), null, true, false), NodeRole.BROKER, (Map)ImmutableMap.of((Object)"lookupNodeService", (Object)new LookupNodeService("tier")));
        DiscoveryDruidNode node7Clone = new DiscoveryDruidNode(new DruidNode("s7", "h7", false, Integer.valueOf(8080), null, true, false), NodeRole.BROKER, (Map)ImmutableMap.of((Object)"lookupNodeService", (Object)new LookupNodeService("tier")));
        DiscoveryDruidNode node8 = new DiscoveryDruidNode(new DruidNode("s8", "h8", false, Integer.valueOf(8080), null, true, false), NodeRole.COORDINATOR, (Map)ImmutableMap.of());
        provider.add(node1);
        provider.add(node2);
        provider.add(node3);
        provider.add(node4);
        provider.add(node5);
        provider.add(node6);
        provider.add(node7);
        provider.add(node7Clone);
        provider.add(node8);
        Assert.assertEquals((Object)ImmutableSet.of((Object)node1, (Object)node2, (Object)node4, (Object)node5), (Object)ImmutableSet.copyOf((Collection)dataNodeDiscovery.getAllNodes()));
        Assert.assertEquals((Object)ImmutableSet.of((Object)node1, (Object)node2, (Object)node4, (Object)node5), dataNodes);
        Assert.assertEquals((Object)ImmutableSet.of((Object)node1, (Object)node3, (Object)node4, (Object)node6, (Object)node7), (Object)ImmutableSet.copyOf((Collection)lookupNodeDiscovery.getAllNodes()));
        Assert.assertEquals((Object)ImmutableSet.of((Object)node1, (Object)node3, (Object)node4, (Object)node6, (Object)node7), lookupNodes);
        provider.remove(node8);
        provider.remove(node7Clone);
        provider.remove(node6);
        provider.remove(node5);
        provider.remove(node4);
        Assert.assertEquals((Object)ImmutableSet.of((Object)node1, (Object)node2), (Object)ImmutableSet.copyOf((Collection)dataNodeDiscovery.getAllNodes()));
        Assert.assertEquals((Object)ImmutableSet.of((Object)node1, (Object)node2), dataNodes);
        Assert.assertEquals((Object)ImmutableSet.of((Object)node1, (Object)node3), (Object)ImmutableSet.copyOf((Collection)lookupNodeDiscovery.getAllNodes()));
        Assert.assertEquals((Object)ImmutableSet.of((Object)node1, (Object)node3), lookupNodes);
    }

    @Test
    public void test_removeListener_withNullListener_noException() {
        TestDruidNodeDiscoveryProvider provider = new TestDruidNodeDiscoveryProvider();
        DruidNodeDiscovery dataNodeDiscovery = provider.getForService("dataNodeService");
        dataNodeDiscovery.removeListener(null);
    }

    private static class TestDruidNodeDiscoveryProvider
    extends DruidNodeDiscoveryProvider {
        private List<DruidNodeDiscovery.Listener> listeners = new ArrayList<DruidNodeDiscovery.Listener>();

        private TestDruidNodeDiscoveryProvider() {
        }

        public BooleanSupplier getForNode(DruidNode node, NodeRole nodeRole) {
            throw new UnsupportedOperationException();
        }

        public DruidNodeDiscovery getForNodeRole(NodeRole nodeRole) {
            return new DruidNodeDiscovery(){

                public Set<DiscoveryDruidNode> getAllNodes() {
                    throw new UnsupportedOperationException();
                }

                public void registerListener(DruidNodeDiscovery.Listener listener) {
                    listeners.add(listener);
                }
            };
        }

        void add(DiscoveryDruidNode node) {
            for (DruidNodeDiscovery.Listener listener : this.listeners) {
                listener.nodesAdded((Collection)ImmutableList.of((Object)node));
            }
        }

        void remove(DiscoveryDruidNode node) {
            for (DruidNodeDiscovery.Listener listener : this.listeners) {
                listener.nodesRemoved((Collection)ImmutableList.of((Object)node));
            }
        }
    }
}

