/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.metadata;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.druid.audit.AuditEntry;
import org.apache.druid.audit.AuditInfo;
import org.apache.druid.audit.AuditManager;
import org.apache.druid.jackson.DefaultObjectMapper;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.emitter.service.ServiceEmitter;
import org.apache.druid.metadata.MetadataRuleManagerConfig;
import org.apache.druid.metadata.MetadataStorageTablesConfig;
import org.apache.druid.metadata.SQLMetadataConnector;
import org.apache.druid.metadata.SQLMetadataRuleManager;
import org.apache.druid.metadata.SQLMetadataSegmentPublisher;
import org.apache.druid.metadata.TestDerbyConnector;
import org.apache.druid.segment.TestHelper;
import org.apache.druid.server.audit.SQLAuditManager;
import org.apache.druid.server.audit.SQLAuditManagerConfig;
import org.apache.druid.server.coordinator.rules.IntervalLoadRule;
import org.apache.druid.server.coordinator.rules.Rule;
import org.apache.druid.server.metrics.NoopServiceEmitter;
import org.apache.druid.timeline.DataSegment;
import org.apache.druid.timeline.partition.NoneShardSpec;
import org.apache.druid.timeline.partition.ShardSpec;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.skife.jdbi.v2.Handle;
import org.skife.jdbi.v2.tweak.HandleCallback;

public class SQLMetadataRuleManagerTest {
    @org.junit.Rule
    public final TestDerbyConnector.DerbyConnectorRule derbyConnectorRule = new TestDerbyConnector.DerbyConnectorRule();
    private TestDerbyConnector connector;
    private MetadataStorageTablesConfig tablesConfig;
    private SQLMetadataRuleManager ruleManager;
    private AuditManager auditManager;
    private SQLMetadataSegmentPublisher publisher;
    private final ObjectMapper mapper = new DefaultObjectMapper();
    private final ObjectMapper jsonMapper = TestHelper.makeJsonMapper();

    @Before
    public void setUp() {
        this.connector = this.derbyConnectorRule.getConnector();
        this.tablesConfig = (MetadataStorageTablesConfig)this.derbyConnectorRule.metadataTablesConfigSupplier().get();
        this.connector.createAuditTable();
        this.auditManager = new SQLAuditManager((SQLMetadataConnector)this.connector, Suppliers.ofInstance((Object)this.tablesConfig), (ServiceEmitter)new NoopServiceEmitter(), this.mapper, new SQLAuditManagerConfig());
        this.connector.createRulesTable();
        this.ruleManager = new SQLMetadataRuleManager(this.mapper, new MetadataRuleManagerConfig(), this.tablesConfig, (SQLMetadataConnector)this.connector, this.auditManager);
        this.connector.createSegmentTable();
        this.publisher = new SQLMetadataSegmentPublisher(this.jsonMapper, (MetadataStorageTablesConfig)this.derbyConnectorRule.metadataTablesConfigSupplier().get(), (SQLMetadataConnector)this.connector);
    }

    @Test
    public void testMultipleStopAndStart() {
        this.ruleManager.start();
        this.ruleManager.stop();
        this.ruleManager.start();
        this.ruleManager.stop();
    }

    @Test
    public void testRuleInsert() {
        List<IntervalLoadRule> rules = Collections.singletonList(new IntervalLoadRule(Intervals.of((String)"2015-01-01/2015-02-01"), (Map)ImmutableMap.of((Object)"_default_tier", (Object)2)));
        AuditInfo auditInfo = new AuditInfo("test_author", "test_comment", "127.0.0.1");
        this.ruleManager.overrideRule("test_dataSource", rules, auditInfo);
        Map allRules = this.ruleManager.getAllRules();
        Assert.assertEquals((long)1L, (long)allRules.size());
        Assert.assertEquals((long)1L, (long)((List)allRules.get("test_dataSource")).size());
        Assert.assertEquals((Object)rules.get(0), ((List)allRules.get("test_dataSource")).get(0));
    }

    @Test
    public void testAuditEntryCreated() throws Exception {
        List<IntervalLoadRule> rules = Collections.singletonList(new IntervalLoadRule(Intervals.of((String)"2015-01-01/2015-02-01"), (Map)ImmutableMap.of((Object)"_default_tier", (Object)2)));
        AuditInfo auditInfo = new AuditInfo("test_author", "test_comment", "127.0.0.1");
        this.ruleManager.overrideRule("test_dataSource", rules, auditInfo);
        this.ruleManager.poll();
        Assert.assertEquals(rules, (Object)this.ruleManager.getRules("test_dataSource"));
        List auditEntries = this.auditManager.fetchAuditHistory("test_dataSource", "rules", null);
        Assert.assertEquals((long)1L, (long)auditEntries.size());
        AuditEntry entry = (AuditEntry)auditEntries.get(0);
        Assert.assertEquals(rules, (Object)this.mapper.readValue(entry.getPayload(), (TypeReference)new TypeReference<List<Rule>>(){}));
        Assert.assertEquals((Object)auditInfo, (Object)entry.getAuditInfo());
        Assert.assertEquals((Object)"test_dataSource", (Object)entry.getKey());
    }

    @Test
    public void testFetchAuditEntriesForAllDataSources() throws Exception {
        List<IntervalLoadRule> rules = Collections.singletonList(new IntervalLoadRule(Intervals.of((String)"2015-01-01/2015-02-01"), (Map)ImmutableMap.of((Object)"_default_tier", (Object)2)));
        AuditInfo auditInfo = new AuditInfo("test_author", "test_comment", "127.0.0.1");
        this.ruleManager.overrideRule("test_dataSource", rules, auditInfo);
        this.ruleManager.overrideRule("test_dataSource2", rules, auditInfo);
        this.ruleManager.poll();
        Assert.assertEquals(rules, (Object)this.ruleManager.getRules("test_dataSource"));
        Assert.assertEquals(rules, (Object)this.ruleManager.getRules("test_dataSource2"));
        List auditEntries = this.auditManager.fetchAuditHistory("rules", null);
        Assert.assertEquals((long)2L, (long)auditEntries.size());
        for (AuditEntry entry : auditEntries) {
            Assert.assertEquals(rules, (Object)this.mapper.readValue(entry.getPayload(), (TypeReference)new TypeReference<List<Rule>>(){}));
            Assert.assertEquals((Object)auditInfo, (Object)entry.getAuditInfo());
        }
    }

    @Test
    public void testRemoveRulesOlderThanWithNonExistenceDatasourceAndOlderThanTimestampShouldDelete() {
        ImmutableList rules = ImmutableList.of((Object)new IntervalLoadRule(Intervals.of((String)"2015-01-01/2015-02-01"), (Map)ImmutableMap.of((Object)"_default_tier", (Object)2)));
        AuditInfo auditInfo = new AuditInfo("test_author", "test_comment", "127.0.0.1");
        this.ruleManager.overrideRule("test_dataSource", (List)rules, auditInfo);
        this.ruleManager.poll();
        Map allRules = this.ruleManager.getAllRules();
        Assert.assertEquals((long)1L, (long)allRules.size());
        Assert.assertEquals((long)1L, (long)((List)allRules.get("test_dataSource")).size());
        this.ruleManager.removeRulesForEmptyDatasourcesOlderThan(System.currentTimeMillis());
        this.ruleManager.poll();
        allRules = this.ruleManager.getAllRules();
        Assert.assertEquals((long)0L, (long)allRules.size());
    }

    @Test
    public void testRemoveRulesOlderThanWithNonExistenceDatasourceAndNewerThanTimestampShouldNotDelete() {
        ImmutableList rules = ImmutableList.of((Object)new IntervalLoadRule(Intervals.of((String)"2015-01-01/2015-02-01"), (Map)ImmutableMap.of((Object)"_default_tier", (Object)2)));
        AuditInfo auditInfo = new AuditInfo("test_author", "test_comment", "127.0.0.1");
        this.ruleManager.overrideRule("test_dataSource", (List)rules, auditInfo);
        this.ruleManager.poll();
        Map allRules = this.ruleManager.getAllRules();
        Assert.assertEquals((long)1L, (long)allRules.size());
        Assert.assertEquals((long)1L, (long)((List)allRules.get("test_dataSource")).size());
        this.ruleManager.removeRulesForEmptyDatasourcesOlderThan(DateTimes.of((String)"2012-01-01T00:00:00Z").getMillis());
        this.ruleManager.poll();
        allRules = this.ruleManager.getAllRules();
        Assert.assertEquals((long)1L, (long)allRules.size());
        Assert.assertEquals((long)1L, (long)((List)allRules.get("test_dataSource")).size());
    }

    @Test
    public void testRemoveRulesOlderThanWithActiveDatasourceShouldNotDelete() throws Exception {
        ImmutableList rules = ImmutableList.of((Object)new IntervalLoadRule(Intervals.of((String)"2015-01-01/2015-02-01"), (Map)ImmutableMap.of((Object)"_default_tier", (Object)2)));
        AuditInfo auditInfo = new AuditInfo("test_author", "test_comment", "127.0.0.1");
        this.ruleManager.overrideRule("test_dataSource", (List)rules, auditInfo);
        this.ruleManager.poll();
        Map allRules = this.ruleManager.getAllRules();
        Assert.assertEquals((long)1L, (long)allRules.size());
        Assert.assertEquals((long)1L, (long)((List)allRules.get("test_dataSource")).size());
        DataSegment dataSegment = new DataSegment("test_dataSource", Intervals.of((String)"2015-01-01/2015-02-01"), "1", (Map)ImmutableMap.of((Object)"type", (Object)"s3_zip", (Object)"bucket", (Object)"test", (Object)"key", (Object)"test_dataSource/xxx"), (List)ImmutableList.of((Object)"dim1", (Object)"dim2", (Object)"dim3"), (List)ImmutableList.of((Object)"count", (Object)"value"), (ShardSpec)NoneShardSpec.instance(), Integer.valueOf(1), 1234L);
        this.publisher.publishSegment(dataSegment);
        this.ruleManager.removeRulesForEmptyDatasourcesOlderThan(System.currentTimeMillis());
        this.ruleManager.poll();
        allRules = this.ruleManager.getAllRules();
        Assert.assertEquals((long)1L, (long)allRules.size());
        Assert.assertEquals((long)1L, (long)((List)allRules.get("test_dataSource")).size());
    }

    @Test
    public void testRemoveRulesOlderThanShouldNotDeleteDefault() {
        this.ruleManager.start();
        this.ruleManager.poll();
        Map allRules = this.ruleManager.getAllRules();
        Assert.assertEquals((long)1L, (long)allRules.size());
        Assert.assertEquals((long)1L, (long)((List)allRules.get("_default")).size());
        this.ruleManager.removeRulesForEmptyDatasourcesOlderThan(System.currentTimeMillis());
        this.ruleManager.poll();
        allRules = this.ruleManager.getAllRules();
        Assert.assertEquals((long)1L, (long)allRules.size());
        Assert.assertEquals((long)1L, (long)((List)allRules.get("_default")).size());
    }

    @After
    public void cleanup() {
        this.dropTable(this.tablesConfig.getAuditTable());
        this.dropTable(this.tablesConfig.getRulesTable());
    }

    private void dropTable(final String tableName) {
        this.connector.getDBI().withHandle((HandleCallback)new HandleCallback<Void>(){

            public Void withHandle(Handle handle) {
                handle.createStatement(StringUtils.format((String)"DROP TABLE %s", (Object[])new Object[]{tableName})).execute();
                return null;
            }
        });
    }
}

