/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.loading;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.inject.Binder;
import com.google.inject.Injector;
import com.google.inject.multibindings.MapBinder;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.druid.guice.Binders;
import org.apache.druid.guice.GuiceInjectors;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.segment.loading.DataSegmentKiller;
import org.apache.druid.segment.loading.OmniDataSegmentKiller;
import org.apache.druid.segment.loading.SegmentLoadingException;
import org.apache.druid.timeline.DataSegment;
import org.apache.druid.timeline.partition.ShardSpec;
import org.apache.druid.timeline.partition.TombstoneShardSpec;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class OmniDataSegmentKillerTest {
    @Test
    public void testKillSegmentWithType() throws SegmentLoadingException {
        DataSegmentKiller killer = (DataSegmentKiller)Mockito.mock(DataSegmentKiller.class);
        DataSegment segment = (DataSegment)Mockito.mock(DataSegment.class);
        Mockito.when((Object)segment.isTombstone()).thenReturn((Object)false);
        Mockito.when((Object)segment.getLoadSpec()).thenReturn((Object)ImmutableMap.of((Object)"type", (Object)"sane"));
        Injector injector = OmniDataSegmentKillerTest.createInjector(killer);
        OmniDataSegmentKiller segmentKiller = (OmniDataSegmentKiller)injector.getInstance(OmniDataSegmentKiller.class);
        segmentKiller.kill(segment);
        ((DataSegmentKiller)Mockito.verify((Object)killer, (VerificationMode)Mockito.times((int)1))).kill(segment);
    }

    @Test
    public void testKillSegmentUnknowType() {
        DataSegment segment = (DataSegment)Mockito.mock(DataSegment.class);
        Mockito.when((Object)segment.getLoadSpec()).thenReturn((Object)ImmutableMap.of((Object)"type", (Object)"unknown-type"));
        Injector injector = OmniDataSegmentKillerTest.createInjector(null);
        OmniDataSegmentKiller segmentKiller = (OmniDataSegmentKiller)injector.getInstance(OmniDataSegmentKiller.class);
        Assert.assertThrows((String)"Unknown loader type[unknown-type]. Known types are [explode]", SegmentLoadingException.class, () -> segmentKiller.kill(segment));
    }

    private static Injector createInjector(@Nullable DataSegmentKiller killer) {
        return GuiceInjectors.makeStartupInjectorWithModules((Iterable)ImmutableList.of(binder -> {
            MapBinder mapBinder = Binders.dataSegmentKillerBinder((Binder)binder);
            if (killer != null) {
                mapBinder.addBinding((Object)"sane").toInstance((Object)killer);
            }
        }));
    }

    @Test
    public void testKillTombstone() throws Exception {
        DataSegment tombstone = DataSegment.builder().dataSource("test").interval(Intervals.of((String)"2021-01-01/P1D")).version("version").size(1L).loadSpec((Map)ImmutableMap.of((Object)"type", (Object)"tombstone", (Object)"path", (Object)"null")).shardSpec((ShardSpec)new TombstoneShardSpec()).build();
        Injector injector = OmniDataSegmentKillerTest.createInjector(null);
        OmniDataSegmentKiller segmentKiller = (OmniDataSegmentKiller)injector.getInstance(OmniDataSegmentKiller.class);
        segmentKiller.kill(tombstone);
    }
}

